/*
 * Decompiled with CFR 0.152.
 */
package kr.icetang0123.mods.hit_particles.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import kr.icetang0123.mods.hit_particles.config.ConfigScreenFactory;
import net.minecraft.class_310;

public class ConfigSerializer {
    public Map<String, Object> load() {
        try {
            File configFile = new File(Paths.get(class_310.method_1551().field_1697.getAbsolutePath(), "config", "hit_particles.json").toUri());
            Gson gson = new Gson();
            if (!configFile.exists() && configFile.createNewFile()) {
                Files.writeString(configFile.toPath(), (CharSequence)gson.toJson(this.getDefaultConfig()), new OpenOption[0]);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));
            StringBuilder file = new StringBuilder();
            String line = null;
            do {
                if (line == null) continue;
                file.append("\n");
                file.append(line);
            } while ((line = br.readLine()) != null);
            br.close();
            return ConfigSerializer.mergeMap((Map)gson.fromJson(file.toString(), Map.class), this.getDefaultConfig());
        }
        catch (IOException iOException) {
            return this.getDefaultConfig();
        }
    }

    public void save() {
        HashMap<String, Object> file = new HashMap<String, Object>();
        GsonBuilder gson = new GsonBuilder();
        file.put("particle_type", ConfigScreenFactory.particleType.get());
        file.put("particle_count", ConfigScreenFactory.particleCount.get());
        file.put("radius_x", ConfigScreenFactory.radiusX.get());
        file.put("radius_y", ConfigScreenFactory.radiusY.get());
        file.put("radius_z", ConfigScreenFactory.radiusZ.get());
        file.put("offset_x", ConfigScreenFactory.offsetX.get());
        file.put("offset_y", ConfigScreenFactory.offsetY.get());
        file.put("offset_z", ConfigScreenFactory.offsetZ.get());
        file.put("spawn_at_feet", ConfigScreenFactory.spawnAtFeet.get());
        file.put("velocity_min", ConfigScreenFactory.velocityMin.get());
        file.put("velocity_max", ConfigScreenFactory.velocityMax.get());
        try {
            BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(Paths.get(class_310.method_1551().field_1697.getAbsolutePath(), "config", "hit_particles.json").toUri())), StandardCharsets.UTF_8));
            br.write(gson.setPrettyPrinting().create().toJson(file).toCharArray());
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Map<String, Object> getDefaultConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>(Map.of());
        config.put("particle_type", "minecraft:enchanted_hit");
        config.put("particle_count", 25);
        config.put("radius_x", 0.0);
        config.put("radius_y", 0.0);
        config.put("radius_z", 0.0);
        config.put("offset_x", 0.0);
        config.put("offset_y", 0.0);
        config.put("offset_z", 0.0);
        config.put("spawn_at_feet", false);
        config.put("velocity_min", 0.001);
        config.put("velocity_max", 1.0);
        return config;
    }

    private static <K, V> Map<K, V> mergeMap(Map<K, V> map, Map<K, V> defaultMap) {
        HashMap<K, V> merged = new HashMap<K, V>(defaultMap);
        merged.putAll(map);
        return merged;
    }
}

