/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import terrails.colorfulhearts.CColorfulHearts;

public class ConfigOption<C, O>
implements Supplier<O> {
    private final String path;
    private final String comment;
    private final C defaultValue;
    private final Predicate<Object> optionValidator;
    private Supplier<C> valueGetter;
    private Consumer<C> valueSetter;
    private final Function<O, C> valueSerializer;
    private final Function<C, O> valueDeserializer;
    private boolean dirty;
    protected O cachedValue;

    public ConfigOption(String path, String comment, C defaultValue, Function<O, C> serializer, Function<C, O> deserializer, Predicate<Object> optionValidator) {
        this.path = path;
        this.defaultValue = defaultValue;
        this.optionValidator = optionValidator;
        this.valueSerializer = serializer;
        this.valueDeserializer = deserializer;
        this.dirty = true;
        if (!((String)comment).isEmpty()) {
            comment = (String)comment + "\n";
        }
        if (defaultValue instanceof List) {
            List list = (List)defaultValue;
            if (list.isEmpty()) {
                comment = (String)comment + "Default: []";
            } else {
                Stream<String> stream = list.stream().map(Object::toString);
                comment = list.get(0) instanceof String ? (String)comment + "Default: [" + stream.map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")) + "]" : (String)comment + "Default: [" + stream.collect(Collectors.joining(", ")) + "]";
            }
        } else {
            comment = defaultValue instanceof String ? (String)comment + "Default: \"" + String.valueOf(defaultValue) + "\"" : (String)comment + "Default: " + String.valueOf(defaultValue);
        }
        this.comment = comment;
    }

    public ConfigOption(String path, String comment, C defaultValue, Function<O, C> serializer, Function<C, O> deserializer) {
        this(path, comment, defaultValue, serializer, deserializer, o -> o != null && defaultValue.getClass().isAssignableFrom(o.getClass()));
    }

    public void initialize(Supplier<C> valueGetter, Consumer<C> valueSetter) {
        if (this.isInitialized()) {
            CColorfulHearts.LOGGER.error("ConfigOption {} is already initialized.", (Object)this.path);
            throw new RuntimeException("ConfigOption " + this.path + " is already initialized");
        }
        this.valueGetter = valueGetter;
        this.valueSetter = valueSetter;
    }

    public void reload() {
        this.dirty = true;
    }

    private boolean isInitialized() {
        return this.valueGetter != null && this.valueSetter != null;
    }

    public String getPath() {
        return this.path;
    }

    public String getComment() {
        return this.comment;
    }

    public Predicate<Object> getOptionValidator() {
        return this.optionValidator;
    }

    public O getDefault() {
        return this.valueDeserializer.apply(this.defaultValue);
    }

    public C getRawDefault() {
        return this.defaultValue;
    }

    @Override
    public O get() {
        if (!this.isInitialized()) {
            CColorfulHearts.LOGGER.error("ConfigOption {} has not yet been initialized.", (Object)this.path);
            throw new RuntimeException("ConfigOption " + this.path + " has not yet been initialized");
        }
        if (this.dirty) {
            this.cachedValue = this.valueDeserializer.apply(this.getRaw());
            this.dirty = false;
        }
        return this.cachedValue;
    }

    public C getRaw() {
        if (!this.isInitialized()) {
            CColorfulHearts.LOGGER.error("ConfigOption {} has not yet been initialized.", (Object)this.path);
            throw new RuntimeException("ConfigOption " + this.path + " has not yet been initialized");
        }
        return this.valueGetter.get();
    }

    public void set(O value) {
        if (!this.isInitialized()) {
            CColorfulHearts.LOGGER.error("ConfigOption {} has not yet been initialized.", (Object)this.path);
            throw new RuntimeException("ConfigOption " + this.path + " has not yet been initialized");
        }
        this.valueSetter.accept(this.valueSerializer.apply(value));
        this.reload();
    }

    public void setRaw(C value) {
        if (!this.isInitialized()) {
            CColorfulHearts.LOGGER.error("ConfigOption {} has not yet been initialized.", (Object)this.path);
            throw new RuntimeException("ConfigOption " + this.path + " has not yet been initialized");
        }
        this.valueSetter.accept(value);
        this.reload();
    }
}

