/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config.screen;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.ConfigOption;
import terrails.colorfulhearts.config.ConfigUtils;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.config.SimpleConfigOption;
import terrails.colorfulhearts.config.screen.HeartType;
import terrails.colorfulhearts.config.screen.base.ScrollableWidgetList;
import terrails.colorfulhearts.config.screen.widgets.HeartColorEditBox;
import terrails.colorfulhearts.render.HeartRenderer;
import terrails.colorfulhearts.render.TabHeartRenderer;

public class ColorSelectionScreen
extends class_437 {
    private final class_437 lastScreen;
    private List<HeartColorEditBox> editBoxes;
    private List<class_4185> heartTypeButtons;
    private class_4185 saveButton;
    private boolean vanillaHeart;
    private boolean hasChanged;
    private boolean colorsChanged;
    private boolean vanillaChanged;
    private ScrollableWidgetList colorSelectionList;
    private HeartType heartType;

    public ColorSelectionScreen(class_437 lastScreen, boolean health) {
        super((class_2561)class_2561.method_43471((String)(health ? "colorfulhearts.screen.health.title" : "colorfulhearts.screen.absorption.title")));
        this.lastScreen = lastScreen;
        this.heartType = health ? HeartType.HEALTH : HeartType.ABSORBING;
        this.updateHeartType(this.heartType, false);
    }

    public void method_25393() {
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.field_22763 = false;
            });
            this.saveButton.field_22763 = this.canApplyChanges();
        } else if (this.saveButton.field_22763) {
            this.method_41843();
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.colorsChanged = false;
        int width = class_310.method_1551().method_22683().method_4486();
        int height = class_310.method_1551().method_22683().method_4502();
        int marginY = 32;
        double prevScrollAmount = this.colorSelectionList == null ? 0.0 : this.colorSelectionList.method_25341();
        this.colorSelectionList = (ScrollableWidgetList)this.method_37063((class_364)new ScrollableWidgetList(class_310.method_1551(), width, height - marginY * 2, marginY, 26));
        this.addColorElements();
        this.colorSelectionList.method_25307(prevScrollAmount);
        int BUTTON_SPACING = 10;
        int BUTTON_WIDTH = 80;
        int BUTTON_HEIGHT = 20;
        int startX = (width - BUTTON_WIDTH * 4 - BUTTON_SPACING * 3) / 2;
        int y = (marginY - 20) / 2;
        class_4185 normalHearts = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"colorfulhearts.options.button.hearttype.normal"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH : HeartType.ABSORBING, true)).method_46433(startX, y).method_46437(BUTTON_WIDTH, BUTTON_HEIGHT).method_46431());
        normalHearts.field_22763 = this.heartType != HeartType.HEALTH && this.heartType != HeartType.ABSORBING;
        int x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        class_4185 poisonedHearts = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"colorfulhearts.options.button.hearttype.poisoned"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH_POISONED : HeartType.ABSORBING_POISONED, true)).method_46433(x, y).method_46437(BUTTON_WIDTH, BUTTON_HEIGHT).method_46431());
        poisonedHearts.field_22763 = this.heartType != HeartType.HEALTH_POISONED && this.heartType != HeartType.ABSORBING_POISONED;
        class_4185 witheredHearts = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"colorfulhearts.options.button.hearttype.withered"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH_WITHERED : HeartType.ABSORBING_WITHERED, true)).method_46433(x += BUTTON_WIDTH + BUTTON_SPACING, y).method_46437(BUTTON_WIDTH, BUTTON_HEIGHT).method_46431());
        witheredHearts.field_22763 = this.heartType != HeartType.HEALTH_WITHERED && this.heartType != HeartType.ABSORBING_WITHERED;
        class_4185 frozenHearts = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"colorfulhearts.options.button.hearttype.frozen"), btn -> this.updateHeartType(this.heartType.isHealthType() ? HeartType.HEALTH_FROZEN : HeartType.ABSORBING_FROZEN, true)).method_46433(x += BUTTON_WIDTH + BUTTON_SPACING, y).method_46437(BUTTON_WIDTH, BUTTON_HEIGHT).method_46431());
        frozenHearts.field_22763 = this.heartType != HeartType.HEALTH_FROZEN && this.heartType != HeartType.ABSORBING_FROZEN;
        this.heartTypeButtons = List.of(normalHearts, poisonedHearts, witheredHearts, frozenHearts);
        BUTTON_WIDTH = 120;
        BUTTON_SPACING = 30;
        startX = (width - BUTTON_WIDTH * 2 - BUTTON_SPACING) / 2;
        y = height - BUTTON_HEIGHT / 2 - marginY / 2;
        this.saveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"colorfulhearts.options.button.confirmsave"), btn -> {
            this.saveConfig();
            this.method_25419();
        }).method_46433(startX, y).method_46437(BUTTON_WIDTH, BUTTON_HEIGHT).method_46431());
        this.saveButton.field_22763 = false;
        x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"colorfulhearts.options.button.cancel"), btn -> this.method_25419()).method_46433(x, y).method_46437(BUTTON_WIDTH, BUTTON_HEIGHT).method_46431());
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.field_22763 = false;
            });
        }
        if (this.canApplyChanges()) {
            this.saveButton.field_22763 = true;
        }
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.lastScreen);
        if (this.colorsChanged) {
            this.field_22787.method_1521();
            ConfigUtils.loadColoredHearts();
            ConfigUtils.loadStatusEffectHearts();
            HeartRenderer.INSTANCE.lastHealth = 0;
            TabHeartRenderer.INSTANCE.lastHealth = 0;
            CColorfulHearts.PROXY.heartUpdateEvent();
        } else if (this.vanillaChanged) {
            ConfigUtils.loadColoredHearts();
            ConfigUtils.loadStatusEffectHearts();
            HeartRenderer.INSTANCE.lastHealth = 0;
            TabHeartRenderer.INSTANCE.lastHealth = 0;
            CColorfulHearts.PROXY.heartUpdateEvent();
        }
    }

    public void updateHeartType(HeartType type, boolean rebuildWidgets) {
        this.heartType = type;
        this.editBoxes = null;
        boolean bl = this.vanillaHeart = this.hasVanillaVariant() && type.isVanillaVariantPresent();
        if (rebuildWidgets) {
            this.method_41843();
        }
    }

    public boolean hasVanillaVariant() {
        return this.heartType.isHealthType() || this.heartType == HeartType.ABSORBING;
    }

    private void addColorElements() {
        int ELEMENTS_PER_ROW = 4;
        int ELEMENT_SPACING = 6;
        int EDIT_BOX_WIDTH = 60;
        int BUTTON_DIMS = 20;
        int BUTTON_SPACING = 3;
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int totalElementWidth = 350;
        int startX = (screenWidth - totalElementWidth) / 2;
        ArrayList<class_339> widgets = new ArrayList<class_339>();
        int OFFSET = 0;
        if (this.hasVanillaVariant()) {
            OFFSET = 1;
            Supplier<class_2561> componentSupplier = () -> class_2561.method_43471((String)(this.vanillaHeart ? "colorfulhearts.options.button.vanillaheart.true" : "colorfulhearts.options.button.vanillaheart.false"));
            widgets.add((class_339)class_4185.method_46430((class_2561)componentSupplier.get(), btn -> {
                this.vanillaHeart = !this.vanillaHeart;
                this.hasChanged = this.haveValuesChanged();
                btn.method_25355((class_2561)componentSupplier.get());
                this.method_41843();
            }).method_46433(startX, 0).method_46437(83, 20).method_46431());
        }
        if (this.editBoxes == null) {
            this.editBoxes = new LinkedList<HeartColorEditBox>();
            for (String color : this.heartType.getConfigOption().getRaw()) {
                HeartColorEditBox box = new HeartColorEditBox(this.field_22793, 0, 0, 0, 0, this.heartType);
                box.method_1852(color);
                this.editBoxes.add(box);
            }
        }
        int elementCount = this.editBoxes.size();
        for (int i = 0; i < elementCount; ++i) {
            boolean canAddMoreHearts;
            boolean stop;
            boolean bl = stop = this.heartType.isHealthType() && this.heartType != HeartType.HEALTH && (i > 0 && this.vanillaHeart || i > 1);
            if (stop) {
                this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
                break;
            }
            int column = (i + OFFSET) % 4;
            int x = startX + column * 89;
            int i_ = i;
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-").method_27692(class_124.field_1061), btn -> {
                this.editBoxes.remove(i_);
                this.hasChanged = this.haveValuesChanged();
                this.method_41843();
            }).method_46433(x, 0).method_46437(20, 20).method_46431();
            HeartColorEditBox box = this.editBoxes.get(i);
            box = new HeartColorEditBox(this.field_22793, x + 20 + 3, 0, 58, 20, box, this.heartType);
            box.method_1863(str -> {
                this.hasChanged = this.haveValuesChanged();
            });
            this.editBoxes.set(i, box);
            widgets.add((class_339)button);
            widgets.add((class_339)box);
            if (column + 1 == 4) {
                this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
                widgets.clear();
            }
            if (i + 1 != elementCount) continue;
            boolean bl2 = canAddMoreHearts = !this.heartType.isEffectType() || !this.hasEnoughColors();
            if (canAddMoreHearts) {
                column = (column + 1) % 4;
                x = startX + column * 89;
                class_4185 addButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+").method_27692(class_124.field_1060), btn -> {
                    this.editBoxes.add(new HeartColorEditBox(this.field_22793, 0, 0, 38, 20, this.heartType));
                    this.hasChanged = this.haveValuesChanged();
                    this.method_41843();
                }).method_46433(x, 0).method_46437(20, 20).method_46431();
                widgets.add((class_339)addButton);
            }
            this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
        }
        if (this.editBoxes.isEmpty()) {
            int x = startX + 60 + 20 + 6 + 3;
            class_4185 addButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+").method_27692(class_124.field_1060), btn -> {
                this.editBoxes.add(new HeartColorEditBox(this.field_22793, 0, 0, 38, 20, this.heartType));
                this.method_41843();
            }).method_46433(x, 0).method_46437(20, 20).method_46431();
            widgets.add((class_339)addButton);
            this.colorSelectionList.addEntry(new ScrollableWidgetList.Entry(widgets));
        }
    }

    public boolean hasEnoughColors() {
        int count = this.editBoxes.size();
        return count > 0 && this.heartType.isHealthType() && (this.heartType == HeartType.HEALTH || this.vanillaHeart || count == 2) || !this.heartType.isHealthType() && (this.heartType == HeartType.ABSORBING || count == 2);
    }

    public boolean canApplyChanges() {
        if (this.editBoxes.stream().anyMatch(HeartColorEditBox::isInvalid)) {
            return false;
        }
        return this.hasChanged && this.hasEnoughColors();
    }

    private boolean haveValuesChanged() {
        if (this.editBoxes.stream().anyMatch(HeartColorEditBox::isInvalid)) {
            return true;
        }
        if (this.vanillaHeart != this.heartType.isVanillaVariantPresent()) {
            return true;
        }
        List<Integer> currentColors = this.heartType.getColors();
        List<Integer> newColors = this.editBoxes.stream().map(HeartColorEditBox::getColor).toList();
        if (currentColors.size() != newColors.size()) {
            return true;
        }
        for (int i = 0; i < currentColors.size(); ++i) {
            if (Objects.equals(currentColors.get(i), newColors.get(i))) continue;
            return true;
        }
        return false;
    }

    private SimpleConfigOption<Boolean> getConfigVanilla() {
        return switch (this.heartType) {
            case HeartType.HEALTH -> Configuration.HEALTH.vanillaHearts;
            case HeartType.ABSORBING -> Configuration.ABSORPTION.vanillaHearts;
            default -> null;
        };
    }

    private void saveConfig() {
        SimpleConfigOption<Boolean> configVanilla = this.getConfigVanilla();
        if (configVanilla != null && this.vanillaHeart != configVanilla.get()) {
            configVanilla.set(this.vanillaHeart);
            this.vanillaChanged = true;
        }
        ConfigOption<List<String>, List<Integer>> configColors = this.heartType.getConfigOption();
        List<Integer> currentColors = configColors.get();
        List<Integer> newColors = this.editBoxes.stream().map(HeartColorEditBox::getColor).toList();
        if (currentColors.size() != newColors.size()) {
            configColors.set(newColors);
            this.colorsChanged = true;
        } else {
            for (int i = 0; i < currentColors.size(); ++i) {
                if (Objects.equals(currentColors.get(i), newColors.get(i))) continue;
                configColors.set(newColors);
                this.colorsChanged = true;
                break;
            }
        }
        CColorfulHearts.PROXY.applyConfig();
    }
}

