/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.fabric.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.core.utils.CommentedConfigWrapper;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.ConfigOption;
import terrails.colorfulhearts.config.ConfigUtils;
import terrails.colorfulhearts.config.Configuration;

public class FabConfig
extends CommentedConfigWrapper<CommentedFileConfig>
implements CommentedFileConfig {
    private final Runnable NO_OP = () -> {};
    private final Runnable CONFIG_RELOAD = this::reload;
    private final List<ConfigOption<?, ?>> options = new ArrayList();
    private final ConfigSpec spec = new ConfigSpec();
    private final FileWatcher watcher = FileWatcher.defaultInstance();
    private boolean firstLoad = true;

    public FabConfig() {
        super((CommentedConfig)((CommentedFileConfig)CommentedFileConfig.builder((Path)FabricLoader.getInstance().getConfigDir().resolve("colorfulhearts.toml"), (ConfigFormat)TomlFormat.instance()).onFileNotFound(FileNotFoundAction.CREATE_EMPTY).writingMode(WritingMode.REPLACE).sync().build()));
        for (Object instance : new Object[]{Configuration.HEALTH, Configuration.ABSORPTION}) {
            for (Field field : instance.getClass().getDeclaredFields()) {
                try {
                    Object object = field.get(instance);
                    if (object instanceof ConfigOption) {
                        ConfigOption option = (ConfigOption)object;
                        this.options.add(option);
                        Object c = option.getRawDefault();
                        if (c instanceof List) {
                            List list = (List)c;
                            this.spec.defineList(option.getPath(), list, option.getOptionValidator());
                            continue;
                        }
                        this.spec.define(option.getPath(), option.getRawDefault(), option.getOptionValidator());
                        continue;
                    }
                    CColorfulHearts.LOGGER.debug("Skipping {} field in {} as it is not a ConfigOption", (Object)field.getName(), (Object)instance.getClass().getName());
                }
                catch (IllegalAccessException e) {
                    CColorfulHearts.LOGGER.error("Could not process {} field in {}", (Object)field.getName(), (Object)instance.getClass().getName(), (Object)e);
                }
            }
        }
        this.load();
    }

    public File getFile() {
        return ((CommentedFileConfig)this.config).getFile();
    }

    public Path getNioPath() {
        return ((CommentedFileConfig)this.config).getNioPath();
    }

    public void save() {
        CColorfulHearts.LOGGER.debug("Saving {} config file.", (Object)this.getFile().getName());
        ((CommentedFileConfig)this.config).save();
    }

    public void load() {
        int corrections;
        while (true) {
            try {
                if (this.firstLoad) {
                    CColorfulHearts.LOGGER.info("Loading {} config file", (Object)this.getFile().getName());
                }
                ((CommentedFileConfig)this.config).load();
            }
            catch (ParsingException e) {
                CColorfulHearts.LOGGER.error("Failed to load {} due to a parsing error", (Object)this.getFile().getName(), (Object)e);
                this.disableWatcher();
                String deformedFile = "colorfulhearts-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss")) + "-deformed.toml";
                try {
                    Files.move(this.getNioPath(), FabricLoader.getInstance().getConfigDir().resolve(deformedFile), new CopyOption[0]);
                    CColorfulHearts.LOGGER.error("Deformed config file renamed to {}", (Object)deformedFile);
                }
                catch (IOException ee) {
                    CColorfulHearts.LOGGER.error("Moving deformed config file failed", (Throwable)ee);
                    throw new RuntimeException("Moving deformed config file failed: " + String.valueOf((Object)e));
                }
                this.createFile();
                this.enableWatcher();
                continue;
            }
            break;
        }
        boolean modified = false;
        if (!this.spec.isCorrect((Config)this.config) && (corrections = this.spec.correct((Config)this.config, (action, pathList, incorrectValue, correctedValue) -> {
            String path = String.join((CharSequence)".", pathList);
            switch (action) {
                case ADD: {
                    CColorfulHearts.LOGGER.info("Missing entry {} = {} added to {}", (Object)path, correctedValue, (Object)this.getFile().getName());
                    break;
                }
                case REMOVE: {
                    CColorfulHearts.LOGGER.info("Invalid entry {} removed from {}", (Object)path, (Object)this.getFile().getName());
                    break;
                }
                case REPLACE: {
                    CColorfulHearts.LOGGER.info("Invalid entry {}: value {} replaced by {} in {}", (Object)path, incorrectValue, correctedValue, (Object)this.getFile().getName());
                }
            }
        })) > 0) {
            CColorfulHearts.LOGGER.info("{} correction(s) applied to {} config file", (Object)corrections, (Object)this.getFile().getName());
            modified = true;
        }
        for (ConfigOption<?, ?> option : this.options) {
            if (!this.spec.isDefined(option.getPath())) continue;
            String oldComment = this.getComment(option.getPath());
            String newComment = option.getComment();
            if (oldComment != null && newComment != null) {
                oldComment = oldComment.replaceAll("\r\n", "\n");
                newComment = newComment.replaceAll("\r\n", "\n");
            }
            if ((oldComment != null || newComment == null) && (oldComment == null || oldComment.equals(newComment))) continue;
            this.setComment(option.getPath(), newComment);
            modified = true;
        }
        if (modified) {
            CColorfulHearts.LOGGER.info("Saving corrected {} config file", (Object)this.getFile().getName());
            this.save();
        }
        if (this.firstLoad) {
            for (ConfigOption<?, ?> option : this.options) {
                option.initialize(() -> this.get(option.getPath()), v -> this.set(option.getPath(), v));
                option.reload();
            }
            this.enableWatcher();
            this.firstLoad = false;
        } else {
            this.options.forEach(ConfigOption::reload);
        }
        ConfigUtils.loadColoredHearts();
        ConfigUtils.loadStatusEffectHearts();
    }

    public void reload() {
        CColorfulHearts.LOGGER.info("Reloading {} config file", (Object)this.getFile().getName());
        this.load();
        CColorfulHearts.LOGGER.debug("Reloaded {} config file", (Object)this.getFile().getName());
    }

    public void close() {
        this.watcher.removeWatch(this.getFile());
        ((CommentedFileConfig)this.config).close();
    }

    private void createFile() {
        if (Files.notExists(this.getNioPath(), new LinkOption[0])) {
            try {
                FileNotFoundAction.CREATE_EMPTY.run(this.getNioPath(), (ConfigFormat)TomlFormat.instance());
            }
            catch (IOException e) {
                ((CommentedFileConfig)this.config).close();
                throw new WritingException("An exception occurred while executing the FileNotFoundAction for file " + String.valueOf(this.getNioPath()), (Throwable)e);
            }
        }
    }

    private void disableWatcher() {
        try {
            this.watcher.setWatchFuture(this.getNioPath(), this.NO_OP).get();
        }
        catch (Exception e) {
            ((CommentedFileConfig)this.config).close();
            throw new RuntimeException("Unable to disable a file watcher", e);
        }
    }

    private void enableWatcher() {
        try {
            this.watcher.setWatchFuture(this.getNioPath(), this.CONFIG_RELOAD).get();
        }
        catch (Exception e) {
            ((CommentedFileConfig)this.config).close();
            throw new RuntimeException("Unable to add a file watcher", e);
        }
    }

    public CommentedFileConfig createSubConfig() {
        return (CommentedFileConfig)((CommentedFileConfig)this.config).createSubConfig();
    }

    public <R> R bulkCommentedUpdate(Function<? super CommentedConfig, R> action) {
        return (R)((CommentedFileConfig)this.config).bulkCommentedUpdate(action);
    }

    public <R> R bulkCommentedRead(Function<? super UnmodifiableCommentedConfig, R> action) {
        return (R)((CommentedFileConfig)this.config).bulkCommentedRead(action);
    }
}

