/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render;

import java.util.function.IntUnaryOperator;
import net.minecraft.class_1011;
import net.minecraft.class_3532;
import net.minecraft.class_5253;

public class ImageUtils {
    public static void blendNormal(class_1011 base, class_1011 blend) {
        int width = Math.max(base.method_4307(), blend.method_4307());
        int height = Math.max(base.method_4323(), blend.method_4323());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixelBase = base.method_36559(x, y) ? 0 : base.method_4315(x, y);
                int pixelBlend = blend.method_36559(x, y) ? 0 : blend.method_4315(x, y);
                int alphaBackground = class_5253.class_8045.method_48342((int)pixelBase);
                if (alphaBackground == 0) {
                    base.method_4305(x, y, pixelBlend);
                    continue;
                }
                int blueBackground = class_5253.class_8045.method_48347((int)pixelBase);
                int greenBackground = class_5253.class_8045.method_48346((int)pixelBase);
                int redBackground = class_5253.class_8045.method_48345((int)pixelBase);
                int alphaForeground = class_5253.class_8045.method_48342((int)pixelBlend);
                if (alphaForeground == 0) continue;
                int blueForeground = class_5253.class_8045.method_48347((int)pixelBlend);
                int greenForeground = class_5253.class_8045.method_48346((int)pixelBlend);
                int redForeground = class_5253.class_8045.method_48345((int)pixelBlend);
                int alphaInvert = 255 - alphaForeground;
                int alpha = Math.max(alphaForeground, alphaBackground);
                int blue = class_3532.method_15340((int)((blueForeground * alphaForeground + blueBackground * alphaInvert) / 255), (int)0, (int)255);
                int green = class_3532.method_15340((int)((greenForeground * alphaForeground + greenBackground * alphaInvert) / 255), (int)0, (int)255);
                int red = class_3532.method_15340((int)((redForeground * alphaForeground + redBackground * alphaInvert) / 255), (int)0, (int)255);
                int color = class_5253.class_8045.method_48344((int)alpha, (int)blue, (int)green, (int)red);
                base.method_4305(x, y, color);
            }
        }
    }

    public static void blendMultiply(class_1011 base, class_1011 blend) {
        int width = Math.max(base.method_4307(), blend.method_4307());
        int height = Math.max(base.method_4323(), blend.method_4323());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixelBase = base.method_36559(x, y) ? 0 : base.method_4315(x, y);
                int pixelBlend = blend.method_36559(x, y) ? 0 : blend.method_4315(x, y);
                int alphaBase = class_5253.class_8045.method_48342((int)pixelBase);
                if (alphaBase == 0) {
                    base.method_4305(x, y, pixelBlend);
                    continue;
                }
                int alphaBlend = class_5253.class_8045.method_48342((int)pixelBlend);
                if (alphaBlend == 0) continue;
                int blueBase = class_5253.class_8045.method_48347((int)pixelBase);
                int greenBase = class_5253.class_8045.method_48346((int)pixelBase);
                int redBase = class_5253.class_8045.method_48345((int)pixelBase);
                int blueBlend = class_5253.class_8045.method_48347((int)pixelBlend);
                int greenBlend = class_5253.class_8045.method_48346((int)pixelBlend);
                int redBlend = class_5253.class_8045.method_48345((int)pixelBlend);
                int alpha = Math.max(alphaBase, alphaBlend);
                int blue = blueBase * blueBlend / 255;
                int green = greenBase * greenBlend / 255;
                int red = redBase * redBlend / 255;
                int color = class_5253.class_8045.method_48344((int)alpha, (int)blue, (int)green, (int)red);
                base.method_4305(x, y, color);
            }
        }
    }

    public static void blendScreen(class_1011 base, class_1011 blend) {
        int width = Math.max(base.method_4307(), blend.method_4307());
        int height = Math.max(base.method_4323(), blend.method_4323());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixelBase = base.method_36559(x, y) ? 0 : base.method_4315(x, y);
                int pixelBlend = blend.method_36559(x, y) ? 0 : blend.method_4315(x, y);
                int alphaBase = class_5253.class_8045.method_48342((int)pixelBase);
                if (alphaBase == 0) {
                    base.method_4305(x, y, pixelBlend);
                    continue;
                }
                int alphaBlend = class_5253.class_8045.method_48342((int)pixelBlend);
                if (alphaBlend == 0) continue;
                int blueBase = class_5253.class_8045.method_48347((int)pixelBase);
                int greenBase = class_5253.class_8045.method_48346((int)pixelBase);
                int redBase = class_5253.class_8045.method_48345((int)pixelBase);
                int blueBlend = class_5253.class_8045.method_48347((int)pixelBlend);
                int greenBlend = class_5253.class_8045.method_48346((int)pixelBlend);
                int redBlend = class_5253.class_8045.method_48345((int)pixelBlend);
                int alpha = Math.max(alphaBase, alphaBlend);
                int blue = class_3532.method_15340((int)(255 - (255 - blueBase) * (255 - blueBlend) / 255), (int)0, (int)255);
                int green = class_3532.method_15340((int)(255 - (255 - greenBase) * (255 - greenBlend) / 255), (int)0, (int)255);
                int red = class_3532.method_15340((int)(255 - (255 - redBase) * (255 - redBlend) / 255), (int)0, (int)255);
                int color = class_5253.class_8045.method_48344((int)alpha, (int)blue, (int)green, (int)red);
                base.method_4305(x, y, color);
            }
        }
    }

    public static void blendOverlay(class_1011 base, class_1011 blend) {
        int width = Math.max(base.method_4307(), blend.method_4307());
        int height = Math.max(base.method_4323(), blend.method_4323());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixelBase = base.method_36559(x, y) ? 0 : base.method_4315(x, y);
                int pixelBlend = blend.method_36559(x, y) ? 0 : blend.method_4315(x, y);
                int alphaBase = class_5253.class_8045.method_48342((int)pixelBase);
                if (alphaBase == 0) {
                    base.method_4305(x, y, pixelBlend);
                    continue;
                }
                int alphaBlend = class_5253.class_8045.method_48342((int)pixelBlend);
                if (alphaBlend == 0) continue;
                int blueBase = class_5253.class_8045.method_48347((int)pixelBase);
                int greenBase = class_5253.class_8045.method_48346((int)pixelBase);
                int redBase = class_5253.class_8045.method_48345((int)pixelBase);
                int blueBlend = class_5253.class_8045.method_48347((int)pixelBlend);
                int greenBlend = class_5253.class_8045.method_48346((int)pixelBlend);
                int redBlend = class_5253.class_8045.method_48345((int)pixelBlend);
                int alpha = Math.max(alphaBase, alphaBlend);
                int blue = blueBase < 128 ? class_3532.method_15340((int)(2 * (blueBase * blueBlend / 255)), (int)0, (int)255) : class_3532.method_15340((int)(255 - 2 * (alphaBlend - blueBase) * (alphaBase - blueBlend) / 255), (int)0, (int)255);
                int green = greenBase < 128 ? class_3532.method_15340((int)(2 * (greenBase * greenBlend / 255)), (int)0, (int)255) : class_3532.method_15340((int)(255 - 2 * (alphaBlend - greenBase) * (alphaBase - greenBlend) / 255), (int)0, (int)255);
                int red = redBase < 128 ? class_3532.method_15340((int)(2 * (redBase * redBlend / 255)), (int)0, (int)255) : class_3532.method_15340((int)(255 - 2 * (alphaBlend - redBase) * (alphaBase - redBlend) / 255), (int)0, (int)255);
                int color = class_5253.class_8045.method_48344((int)alpha, (int)blue, (int)green, (int)red);
                base.method_4305(x, y, color);
            }
        }
    }

    public static IntUnaryOperator getColorOverlayOperator(int redColor, int greenColor, int blueColor) {
        return pixel -> {
            int alphaBase = class_5253.class_8045.method_48342((int)pixel);
            if (alphaBase == 0) {
                return pixel;
            }
            int blueBase = class_5253.class_8045.method_48347((int)pixel);
            int greenBase = class_5253.class_8045.method_48346((int)pixel);
            int redBase = class_5253.class_8045.method_48345((int)pixel);
            int blue = blueBase < 128 ? 2 * (blueBase * blueColor / 255) : 255 - 2 * (255 - blueBase) * (alphaBase - blueColor) / 255;
            int green = greenBase < 128 ? 2 * (greenBase * greenColor / 255) : 255 - 2 * (255 - greenBase) * (alphaBase - greenColor) / 255;
            int red = redBase < 128 ? 2 * (redBase * redColor / 255) : 255 - 2 * (255 - redBase) * (alphaBase - redColor) / 255;
            return class_5253.class_8045.method_48344((int)alphaBase, (int)blue, (int)green, (int)red);
        };
    }

    public static IntUnaryOperator getColorOverlayOperator(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return ImageUtils.getColorOverlayOperator(r, g, b);
    }
}

