/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render.atlas.sources;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_7948;
import net.minecraft.class_7951;
import net.minecraft.class_7958;
import net.minecraft.class_8684;
import org.jetbrains.annotations.NotNull;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.render.ImageUtils;

public class ColoredHearts
implements class_7948 {
    public static class_7951 TYPE;
    private static final Codec<Boolean> IS_HEALTH;
    public static final MapCodec<ColoredHearts> CODEC;
    private final boolean isHealth;

    public ColoredHearts(boolean isHealth) {
        this.isHealth = isHealth;
    }

    public void method_47673(class_3300 resourceManager, class_7948.class_7949 output) {
        if (this.isHealth) {
            this.processColors(resourceManager, output, Configuration.HEALTH.colors, "health");
            this.processColors(resourceManager, output, Configuration.HEALTH.poisonedColors, "health/poisoned");
            this.processColors(resourceManager, output, Configuration.HEALTH.witheredColors, "health/withered");
            this.processColors(resourceManager, output, Configuration.HEALTH.frozenColors, "health/frozen");
        } else {
            this.processColors(resourceManager, output, Configuration.ABSORPTION.colors, "absorbing");
            this.processColors(resourceManager, output, Configuration.ABSORPTION.poisonedColors, "absorbing/poisoned");
            this.processColors(resourceManager, output, Configuration.ABSORPTION.witheredColors, "absorbing/withered");
            this.processColors(resourceManager, output, Configuration.ABSORPTION.frozenColors, "absorbing/frozen");
        }
    }

    private void processColors(class_3300 resMgr, class_7948.class_7949 out, java.util.function.Supplier<List<Integer>> colors, String prefix) {
        Map<Integer, IntUnaryOperator> map = colors.get().stream().map(rgb -> Map.entry(rgb, ImageUtils.getColorOverlayOperator(rgb))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue));
        this.processType(resMgr, out, map, prefix, false, false, false);
        this.processType(resMgr, out, map, prefix, false, true, false);
        this.processType(resMgr, out, map, prefix, false, false, true);
        this.processType(resMgr, out, map, prefix, false, true, true);
        this.processType(resMgr, out, map, prefix, true, false, false);
        this.processType(resMgr, out, map, prefix, true, true, false);
        this.processType(resMgr, out, map, prefix, true, false, true);
        this.processType(resMgr, out, map, prefix, true, true, true);
    }

    private void processType(class_3300 resMgr, class_7948.class_7949 out, Map<Integer, IntUnaryOperator> hexARGBs, String prefix, boolean hardcore, boolean highlight, boolean half) {
        String suffix = (hardcore ? "hardcore_" : "") + (half ? "half" : "full") + (highlight ? "_blinking" : "");
        class_2960 baseLocation = CColorfulHearts.location("heart/" + prefix + "/" + suffix);
        Supplier blendApplier = Suppliers.memoize(() -> this.getBlendApplier(resMgr, baseLocation, hexARGBs.size()));
        class_2960 textureLocation = field_42075.method_45112(baseLocation);
        Optional optional = resMgr.method_14486(textureLocation);
        if (optional.isEmpty()) {
            CColorfulHearts.LOGGER.warn("Missing texture: {}", (Object)textureLocation);
            return;
        }
        class_7958 lazyImage = new class_7958(textureLocation, (class_3298)optional.get(), hexARGBs.size());
        for (Map.Entry<Integer, IntUnaryOperator> entry : hexARGBs.entrySet()) {
            class_2960 spriteLocation = baseLocation.method_48331("_" + String.valueOf(entry.getKey()));
            out.method_47670(spriteLocation, (class_7948.class_7950)new ColoredHeartsSupplier(lazyImage, entry.getValue(), (java.util.function.Supplier<Consumer<class_1011>>)blendApplier, spriteLocation));
        }
    }

    private Consumer<class_1011> getBlendApplier(class_3300 resourceManager, class_2960 spriteLocation, int loadCount) {
        class_2960 normalLocation = field_42075.method_45112(spriteLocation.method_48331("_normal"));
        class_2960 multiplyLocation = field_42075.method_45112(spriteLocation.method_48331("_multiply"));
        class_2960 screenLocation = field_42075.method_45112(spriteLocation.method_48331("_screen"));
        class_2960 overlayLocation = field_42075.method_45112(spriteLocation.method_48331("_overlay"));
        Optional<class_7958> normalOptional = resourceManager.method_14486(normalLocation).map(r -> new class_7958(normalLocation, r, loadCount));
        Optional<class_7958> multiplyOptional = resourceManager.method_14486(multiplyLocation).map(r -> new class_7958(multiplyLocation, r, loadCount));
        Optional<class_7958> screenOptional = resourceManager.method_14486(screenLocation).map(r -> new class_7958(screenLocation, r, loadCount));
        Optional<class_7958> overlayOptional = resourceManager.method_14486(overlayLocation).map(r -> new class_7958(overlayLocation, r, loadCount));
        return image -> {
            normalOptional.ifPresentOrElse(normal -> {
                try {
                    ImageUtils.blendNormal(image, normal.method_47697());
                }
                catch (IOException e) {
                    CColorfulHearts.LOGGER.error((Object)e);
                }
                finally {
                    normal.method_47698();
                }
            }, () -> CColorfulHearts.LOGGER.debug("Normal blend texture not found: {}", (Object)normalLocation));
            multiplyOptional.ifPresentOrElse(multiply -> {
                try {
                    ImageUtils.blendMultiply(image, multiply.method_47697());
                }
                catch (IOException e) {
                    CColorfulHearts.LOGGER.error((Object)e);
                }
                finally {
                    multiply.method_47698();
                }
            }, () -> CColorfulHearts.LOGGER.debug("Multiply blend texture not found: {}", (Object)multiplyLocation));
            screenOptional.ifPresentOrElse(screen -> {
                try {
                    class_1011 screenImg = screen.method_47697();
                    ImageUtils.blendScreen(image, screenImg);
                }
                catch (IOException e) {
                    CColorfulHearts.LOGGER.error((Object)e);
                }
                finally {
                    screen.method_47698();
                }
            }, () -> CColorfulHearts.LOGGER.debug("Screen blend texture not found: {}", (Object)screenLocation));
            overlayOptional.ifPresentOrElse(overlay -> {
                try {
                    ImageUtils.blendOverlay(image, overlay.method_47697());
                }
                catch (IOException e) {
                    CColorfulHearts.LOGGER.error((Object)e);
                }
                finally {
                    overlay.method_47698();
                }
            }, () -> CColorfulHearts.LOGGER.debug("Overlay blend texture not found: {}", (Object)overlayLocation));
        };
    }

    @NotNull
    public class_7951 method_47672() {
        return TYPE;
    }

    static {
        IS_HEALTH = Codec.STRING.comapFlatMap(s -> {
            String lc = s.toLowerCase(Locale.ROOT);
            if (lc.equals("health")) {
                return DataResult.success((Object)true);
            }
            if (lc.equals("absorption")) {
                return DataResult.success((Object)false);
            }
            return DataResult.error(() -> "Unknown heart type " + s);
        }, bool -> bool != false ? "HEALTH" : "ABSORPTION");
        CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IS_HEALTH.fieldOf("heart").forGetter(source -> source.isHealth)).apply((Applicative)instance, ColoredHearts::new));
    }

    private record ColoredHeartsSupplier(class_7958 image, IntUnaryOperator colorOperator, java.util.function.Supplier<Consumer<class_1011>> blend, class_2960 spriteLocation) implements class_7948.class_7950
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public class_7764 apply(class_8684 spriteResourceLoader) {
            try {
                class_1011 image = this.image.method_47697().method_48462(this.colorOperator);
                this.blend.get().accept(image);
                class_7764 class_77642 = new class_7764(this.spriteLocation, new class_7771(image.method_4307(), image.method_4323()), image, class_7368.field_38688);
                return class_77642;
            }
            catch (IOException | IllegalArgumentException e) {
                CColorfulHearts.LOGGER.error("Unable to apply color to {}", (Object)this.spriteLocation, (Object)e);
            }
            finally {
                this.image.method_47698();
            }
            return null;
        }

        public void method_47676() {
            this.image.method_47698();
        }
    }
}

