/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.client.FovUpdateEvent;
import net.blay09.mods.balm.api.event.client.GuiDrawEvent;
import net.blay09.mods.balm.api.event.client.KeyInputEvent;
import net.blay09.mods.balm.api.event.client.OpenScreenEvent;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.client.GuiHelper;
import net.blay09.mods.hardcorerevival.client.KnockoutScreen;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.network.RescueMessage;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class HardcoreRevivalClient {
    private static boolean wasKnockedOut;
    private static boolean isRescuing;
    private static int targetEntity;
    private static float targetProgress;
    private static boolean beingRescued;

    public static void initialize() {
        Balm.getEvents().onEvent(OpenScreenEvent.class, HardcoreRevivalClient::onOpenScreen);
        Balm.getEvents().onEvent(FovUpdateEvent.class, HardcoreRevivalClient::onFovUpdate);
        Balm.getEvents().onEvent(KeyInputEvent.class, HardcoreRevivalClient::onKeyInput);
        Balm.getEvents().onEvent(GuiDrawEvent.Pre.class, HardcoreRevivalClient::onGuiDrawPre);
        Balm.getEvents().onEvent(GuiDrawEvent.Post.class, HardcoreRevivalClient::onGuiDrawPost);
        Balm.getEvents().onTickEvent(TickType.Client, TickPhase.Start, HardcoreRevivalClient::onClientTick);
    }

    private static boolean isKnockedOut() {
        class_746 player = class_310.method_1551().field_1724;
        return player != null && PlayerHardcoreRevivalManager.isKnockedOut((class_1657)player) && player.method_5805();
    }

    public static void onOpenScreen(OpenScreenEvent event) {
        if (HardcoreRevivalClient.isKnockedOut() && event.getScreen() instanceof class_490) {
            event.setScreen((class_437)new KnockoutScreen());
        }
    }

    public static void onFovUpdate(FovUpdateEvent event) {
        if (HardcoreRevivalClient.isKnockedOut()) {
            event.setFov(Float.valueOf((float)class_3532.method_16436((double)((Double)class_310.method_1551().field_1690.method_42454().method_41753()), (double)1.0, (double)0.5)));
        }
    }

    public static void onGuiDrawPre(GuiDrawEvent.Pre event) {
        if (event.getElement() == GuiDrawEvent.Element.HEALTH && HardcoreRevivalClient.isKnockedOut()) {
            int knockoutTicksPassed = PlayerHardcoreRevivalManager.getKnockoutTicksPassed((class_1657)class_310.method_1551().field_1724);
            float redness = (float)Math.sin((float)knockoutTicksPassed / 2.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - redness), (float)(1.0f - redness), (float)1.0f);
        }
    }

    public static void onGuiDrawPost(GuiDrawEvent.Post event) {
        class_332 guiGraphics = event.getGuiGraphics();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (event.getElement() == GuiDrawEvent.Element.ALL) {
            class_310 mc = class_310.method_1551();
            if (HardcoreRevivalClient.isKnockedOut()) {
                class_4587 poseStack = guiGraphics.method_51448();
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 0.0f, -300.0f);
                GuiHelper.drawGradientRectW(guiGraphics, 0, 0, mc.method_22683().method_4489(), mc.method_22683().method_4506(), 0x60500000, -1862336512);
                poseStack.method_22909();
                if (mc.field_1755 == null || mc.field_1755 instanceof class_408) {
                    int width = event.getWindow().method_4486();
                    int height = event.getWindow().method_4502();
                    GuiHelper.renderKnockedOutTitle(guiGraphics, width);
                    GuiHelper.renderDeathTimer(guiGraphics, width, height, beingRescued);
                    if (HardcoreRevivalConfig.getActive().allowAcceptingFate) {
                        class_2561 openDeathScreenKey = mc.field_1690.field_1822.method_16007();
                        class_5250 openDeathScreenText = class_2561.method_43469((String)"gui.hardcorerevival.open_death_screen", (Object[])new Object[]{openDeathScreenKey});
                        guiGraphics.method_27534(mc.field_1772, (class_2561)openDeathScreenText, width / 2, height / 2 + 25, -1);
                    }
                }
            } else {
                class_1657 pointedPlayer;
                class_1297 pointedEntity;
                class_1297 entity;
                if (targetEntity != -1 && targetProgress > 0.0f && (entity = mc.field_1687.method_8469(targetEntity)) instanceof class_1657) {
                    class_5250 textComponent = class_2561.method_43469((String)"gui.hardcorerevival.rescuing", (Object[])new Object[]{entity.method_5476()});
                    if (targetProgress >= 0.75f) {
                        textComponent.method_27693(" ...");
                    } else if (targetProgress >= 0.5f) {
                        textComponent.method_27693(" ..");
                    } else if (targetProgress >= 0.25f) {
                        textComponent.method_27693(" .");
                    }
                    guiGraphics.method_51439(mc.field_1772, (class_2561)textComponent, mc.method_22683().method_4486() / 2 - mc.field_1772.method_27525((class_5348)textComponent) / 2, mc.method_22683().method_4502() / 2 + 30, -1, true);
                }
                if (!PlayerHardcoreRevivalManager.isKnockedOut((class_1657)mc.field_1724) && mc.field_1724 != null && !mc.field_1724.method_7325() && mc.field_1724.method_5805() && !isRescuing && (pointedEntity = class_310.method_1551().field_1692) instanceof class_1657 && PlayerHardcoreRevivalManager.isKnockedOut(pointedPlayer = (class_1657)pointedEntity) && (double)mc.field_1724.method_5739(pointedEntity) <= HardcoreRevivalConfig.getActive().rescueDistance) {
                    class_2561 rescueKeyText = mc.field_1690.field_1904.method_16007();
                    class_5250 textComponent = class_2561.method_43469((String)"gui.hardcorerevival.hold_to_rescue", (Object[])new Object[]{rescueKeyText});
                    guiGraphics.method_51439(mc.field_1772, (class_2561)textComponent, mc.method_22683().method_4486() / 2 - mc.field_1772.method_27525((class_5348)textComponent) / 2, mc.method_22683().method_4502() / 2 + 30, -1, true);
                }
            }
            RenderSystem.enableBlend();
        }
    }

    public static void onKeyInput(KeyInputEvent event) {
        class_310 mc = class_310.method_1551();
        if (HardcoreRevivalClient.isKnockedOut()) {
            while (mc.field_1690.field_1869.method_1436()) {
            }
        }
    }

    public static void onClientTick(class_310 client) {
        if (client.field_1724 != null) {
            if (HardcoreRevivalClient.isKnockedOut()) {
                if (!wasKnockedOut) {
                    Balm.getHooks().setForcedPose((class_1657)client.field_1724, class_4050.field_18077);
                    client.method_1507((class_437)new KnockoutScreen());
                    wasKnockedOut = true;
                }
                PlayerHardcoreRevivalManager.setKnockoutTicksPassed((class_1657)client.field_1724, PlayerHardcoreRevivalManager.getKnockoutTicksPassed((class_1657)client.field_1724) + 1);
            } else {
                if (wasKnockedOut) {
                    Balm.getHooks().setForcedPose((class_1657)client.field_1724, null);
                    wasKnockedOut = false;
                }
                if (client.field_1755 instanceof KnockoutScreen) {
                    client.method_1507(null);
                }
                if (client.field_1690.field_1904.method_1434() && !client.field_1724.method_7325() && client.field_1724.method_5805() && !PlayerHardcoreRevivalManager.isKnockedOut((class_1657)client.field_1724)) {
                    if (!isRescuing) {
                        Balm.getNetworking().sendToServer((class_8710)new RescueMessage(true));
                        isRescuing = true;
                    }
                } else if (isRescuing) {
                    Balm.getNetworking().sendToServer((class_8710)new RescueMessage(false));
                    isRescuing = false;
                }
            }
        }
    }

    public static void setRevivalProgress(int entityId, float progress) {
        if (progress < 0.0f) {
            targetEntity = -1;
            targetProgress = 0.0f;
            Balm.getHooks().setForcedPose((class_1657)class_310.method_1551().field_1724, null);
        } else {
            targetEntity = entityId;
            targetProgress = progress;
            Balm.getHooks().setForcedPose((class_1657)class_310.method_1551().field_1724, class_4050.field_18081);
        }
    }

    public static void setBeingRescued(boolean beingRescued) {
        HardcoreRevivalClient.beingRescued = beingRescued;
    }

    public static boolean isBeingRescued() {
        return beingRescued;
    }

    static {
        targetEntity = -1;
    }
}

