/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.networking;

import com.branders.spawnermod.SpawnerMod;
import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.item.SpawnerKey;
import com.branders.spawnermod.networking.packet.SyncConfigPacket;
import com.branders.spawnermod.networking.packet.SyncSpawnerPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class SpawnerModNetworking {
    public static void registerMessages() {
        PayloadTypeRegistry.playC2S().register(SyncSpawnerPacket.PACKET_ID, SyncSpawnerPacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(SyncConfigPacket.PACKET_ID, SyncConfigPacket.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SyncSpawnerPacket.PACKET_ID, (payload, context) -> {
            class_3218 world = context.player().method_51469();
            if (world == null) {
                SpawnerMod.LOGGER.warn("Server world is NULL, cannot sync spawner.");
                return;
            }
            class_2338 pos = payload.pos();
            short requiredPlayerRange = (short)payload.requiredPlayerRange();
            short delay = (short)payload.delay();
            short spawnCount = (short)payload.spawnCount();
            short maxNearbyEntities = (short)payload.maxNearbyEntities();
            short minSpawnDelay = (short)payload.minSpawnDelay();
            short maxSpawnDelay = (short)payload.maxSpawnDelay();
            class_2636 spawner = (class_2636)world.method_8321(pos);
            class_1917 logic = spawner.method_11390();
            class_2680 blockstate = world.method_8320(pos);
            class_2487 nbt = new class_2487();
            nbt = logic.method_8272(nbt);
            if (requiredPlayerRange == 0) {
                nbt.method_10575("SpawnRange", nbt.method_10568("RequiredPlayerRange"));
            } else {
                nbt.method_10575("SpawnRange", (short)4);
            }
            nbt.method_10575("Delay", delay);
            nbt.method_10575("SpawnCount", spawnCount);
            nbt.method_10575("RequiredPlayerRange", requiredPlayerRange);
            nbt.method_10575("MaxNearbyEntities", maxNearbyEntities);
            nbt.method_10575("MinSpawnDelay", minSpawnDelay);
            nbt.method_10575("MaxSpawnDelay", maxSpawnDelay);
            logic.method_8280((class_1937)world, pos, nbt);
            spawner.method_5431();
            world.method_8413(pos, blockstate, blockstate, 3);
            class_1799 stack = context.player().method_6047();
            if (stack.method_7909() instanceof SpawnerKey) {
                stack.method_7970(1, (class_1309)context.player(), class_1304.field_6173);
            }
            world.method_20290(3004, pos, 0);
        });
    }

    public static void registerClientHandler() {
        ClientPlayNetworking.registerGlobalReceiver(SyncConfigPacket.PACKET_ID, (payload, context) -> {
            ConfigValues.put("disable_spawner_config", payload.config());
            ConfigValues.put("disable_count", payload.count());
            ConfigValues.put("disable_range", payload.range());
            ConfigValues.put("disable_speed", payload.speed());
            ConfigValues.put("limited_spawns_enabled", payload.limitedSpawns());
            ConfigValues.put("limited_spawns_amount", payload.limitedSpawnsAmount());
            ConfigValues.put("default_spawner_range_enabled", payload.isCustomRange());
            ConfigValues.put("default_spawner_range", payload.customRange());
        });
    }
}

