/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils.files;

import com.teamresourceful.resourcefullib.common.lib.Constants;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_8144;
import org.jetbrains.annotations.ApiStatus;

public class GlobalStorage {
    private static final String ID = "resourcefullib";
    private static final String README = "This is created by ResourcefulLib for usage by mods.\nThis directory is used to store data/caches for mods.\n";
    private static boolean initialized = false;
    private static final Path cache;
    private static final Path data;

    @ApiStatus.Internal
    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            Files.createDirectories(cache, new FileAttribute[0]);
            Files.createDirectories(data, new FileAttribute[0]);
            Path readme = cache.resolve("README.txt");
            if (!Files.exists(readme, new LinkOption[0])) {
                Files.writeString(readme, (CharSequence)README, new OpenOption[0]);
            }
            if (!Files.exists(readme = data.resolve("README.txt"), new LinkOption[0])) {
                Files.writeString(readme, (CharSequence)README, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            Constants.LOGGER.warn("Failed to create cache/data directories!", (Throwable)e);
        }
    }

    public static Path getCacheDirectory(String modid) {
        GlobalStorage.init();
        return cache.resolve(modid);
    }

    public static Path getDataDirectory(String modid) {
        GlobalStorage.init();
        return data.resolve(modid);
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            cache = Path.of(System.getenv("LOCALAPPDATA"), ".resourcefullib", "cache");
            data = Path.of(System.getenv("LOCALAPPDATA"), ".resourcefullib", "data");
        } else if (osName.startsWith("Mac OS X") || osName.startsWith("Darwin")) {
            cache = Path.of(System.getProperty("user.home"), "Library", "Caches", ID);
            data = Path.of(System.getProperty("user.home"), "Library", "Application Support", ID);
        } else {
            cache = (Path)class_8144.method_49079((Object)System.getenv("XDG_CACHE_HOME"), home -> Path.of(home, ID), () -> Path.of(System.getProperty("user.home"), ".cache", ID));
            data = (Path)class_8144.method_49079((Object)System.getenv("XDG_DATA_HOME"), home -> Path.of(home, ID), () -> Path.of(System.getProperty("user.home"), ".local", "share", ID));
        }
    }
}

