/*
 * Decompiled with CFR 0.152.
 */
package com.github.getchoo.smoothboot.config;

import com.github.getchoo.smoothboot.SmoothBoot;
import com.github.getchoo.smoothboot.config.SmoothBootConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_156;

public class ConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static SmoothBootConfig readConfig() throws IOException {
        SmoothBootConfig config;
        String configPath = System.getProperty("user.dir") + "/config/threadtweak.json";
        SmoothBoot.LOGGER.debug("Config path: " + configPath);
        try (FileReader reader = new FileReader(configPath);){
            config = (SmoothBootConfig)GSON.fromJson((Reader)reader, SmoothBootConfig.class);
            if (config == null) {
                throw new NullPointerException();
            }
            config.validate();
            try (FileWriter writer = new FileWriter(configPath);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            SmoothBoot.LOGGER.debug("Config: " + String.valueOf(config));
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            config = new SmoothBootConfig();
            File file = new File(configPath);
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(configPath);){
                GSON.toJson((Object)config, (Appendable)writer);
                SmoothBoot.LOGGER.debug("New config file created");
            }
        }
        return config;
    }

    public static void openConfigFile() {
        String configPath = System.getProperty("user.dir") + "/config/threadtweak.json";
        class_156.method_668().method_672(new File(configPath));
    }
}

