/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.screen;

import ht.treechop.client.Client;
import ht.treechop.client.gui.element.ButtonGui;
import ht.treechop.client.gui.element.EmptyGui;
import ht.treechop.client.gui.element.LabeledGui;
import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.element.RowsGui;
import ht.treechop.client.gui.element.ToggleGui;
import ht.treechop.client.gui.util.GUIUtil;
import ht.treechop.client.gui.util.Sprite;
import ht.treechop.client.gui.widget.StickyWidget;
import ht.treechop.client.gui.widget.ToggleWidget;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;

public class ClientSettingsScreen
extends class_437 {
    private static final int ROW_SEPARATION = 1;
    private static final boolean IS_PAUSE_SCREEN = true;
    private static final int SPACE_ABOVE_AND_BELOW_LIST = 10;
    private static final int MIN_HEIGHT = 104;
    private static final int TEXT_HEIGHT = 9;
    protected RowsGui optionsList;
    private class_4185 doneButton;
    private int optionsPage = 0;
    private boolean needToRebuild = false;

    public ClientSettingsScreen() {
        super((class_2561)class_2561.method_43469((String)"treechop.gui.settings.title", (Object[])new Object[]{"HT's TreeChop"}));
    }

    protected void method_25426() {
        super.method_25426();
        this.rebuild();
    }

    private void rebuild() {
        List<NestedGui> optionRows = this.optionsPage == 0 ? this.makePageOne() : this.makePageTwo();
        this.addBufferRows(optionRows);
        optionRows.add(new ButtonGui(this.optionsPage == 0 ? Sprite.PAGE_ONE : Sprite.PAGE_TWO, this.optionsPage == 0 ? Sprite.HIGHLIGHTED_PAGE_ONE : Sprite.HIGHLIGHTED_PAGE_TWO, () -> {
            this.needToRebuild = true;
            this.optionsPage = this.optionsPage == 0 ? 1 : 0;
        }));
        this.optionsList = (RowsGui)this.method_37063((class_364)new RowsGui(1, optionRows));
        this.placeOptionsList();
        int doneButtonWidth = 200;
        this.doneButton = (class_4185)this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.done"), button -> this.method_25419()).method_46434((this.field_22789 - 200) / 2, this.getDoneButtonTop(), 200, 20).method_46431());
        int titleTop = this.optionsList.method_46427() - 10 - 8;
        this.method_37063((class_364)new class_7842(0, titleTop, this.field_22789, 9, this.field_22785, this.field_22793).method_48597());
    }

    private void placeOptionsList() {
        int top = 32;
        int bottom = this.field_22790 - 32;
        int middle = (top + bottom) / 2;
        int listTop = middle - this.optionsList.method_25364() / 2;
        int listBottom = middle + this.optionsList.method_25364() / 2;
        this.optionsList.setBox(0, listTop, this.field_22789, listBottom - listTop);
    }

    private void addBufferRows(List<NestedGui> rows) {
        int missingHeight = 104 - RowsGui.getHeightForRows(rows, 1) - 2;
        if (missingHeight > 0) {
            rows.add(0, new EmptyGui(0, Math.floorDiv(missingHeight, 2)));
            rows.add(new EmptyGui(0, (int)Math.ceil((float)missingHeight / 2.0f)));
        }
    }

    private List<NestedGui> makePageOne() {
        LinkedList<NestedGui> optionRows = new LinkedList<NestedGui>();
        optionRows.add(new LabeledGui(this.field_22793, (class_2561)class_2561.method_43471((String)"treechop.gui.settings.label.chopping"), this.makeToggleSettingRow(SettingsField.CHOPPING, "treechop.gui.settings.tooltip.chopping")));
        optionRows.add(new LabeledGui(this.field_22793, (class_2561)class_2561.method_43471((String)"treechop.gui.settings.label.sneaking_inverts_chopping"), new ToggleGui(() -> Client.getChopSettings().setSneakBehavior(this.getNextSneakBehavior()), () -> ToggleWidget.State.of(Client.getChopSettings().getSneakBehavior() == SneakBehavior.INVERT_CHOPPING, this.isSettingPermitted(SettingsField.SNEAK_BEHAVIOR, (Object)this.getNextSneakBehavior())), this::getSneakCycleTooltip)));
        optionRows.add(new LabeledGui(this.field_22793, (class_2561)class_2561.method_43471((String)"treechop.gui.settings.label.only_chop_trees_with_leaves"), this.makeToggleSettingRow(SettingsField.TREES_MUST_HAVE_LEAVES, "treechop.gui.settings.tooltip.only_chop_trees_with_leaves")));
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_7337()) {
            optionRows.add(new LabeledGui(this.field_22793, (class_2561)class_2561.method_43471((String)"treechop.gui.settings.label.chop_in_creative_mode"), this.makeToggleSettingRow(SettingsField.CHOP_IN_CREATIVE_MODE, "treechop.gui.settings.tooltip.chop_in_creative_mode")));
        }
        return optionRows;
    }

    private LinkedList<NestedGui> makePageTwo() {
        LinkedList<NestedGui> optionRows = new LinkedList<NestedGui>();
        optionRows.add(new LabeledGui(this.field_22793, (class_2561)class_2561.method_43471((String)"treechop.gui.settings.label.chop_in_creative_mode"), this.makeToggleSettingRow(SettingsField.CHOP_IN_CREATIVE_MODE, "treechop.gui.settings.tooltip.chop_in_creative_mode")));
        optionRows.add(new LabeledGui(this.field_22793, (class_2561)class_2561.method_43471((String)"treechop.gui.settings.label.chopping_indicator"), new ToggleGui(() -> Client.setChoppingIndicatorVisibility(!Client.isChoppingIndicatorEnabled()), () -> ToggleWidget.State.of(Client.isChoppingIndicatorEnabled(), true), () -> class_2561.method_43471((String)("treechop.gui.settings.tooltip.chopping_indicator" + (Client.isChoppingIndicatorEnabled() ? ".on" : ".off"))))));
        optionRows.add(new LabeledGui(this.field_22793, (class_2561)class_2561.method_43471((String)"treechop.gui.settings.label.feedback_messages"), new ToggleGui(() -> ConfigHandler.CLIENT.showFeedbackMessages.set((Object)((Boolean)ConfigHandler.CLIENT.showFeedbackMessages.get() == false ? 1 : 0)), () -> ToggleWidget.State.of((Boolean)ConfigHandler.CLIENT.showFeedbackMessages.get(), true), () -> class_2561.method_43471((String)("treechop.gui.settings.tooltip.feedback_messages" + ((Boolean)ConfigHandler.CLIENT.showFeedbackMessages.get() != false ? ".on" : ".off"))))));
        optionRows.add(new LabeledGui(this.field_22793, (class_2561)class_2561.method_43471((String)"treechop.gui.settings.label.tooltips"), new ToggleGui(() -> ConfigHandler.CLIENT.showTooltips.set((Object)((Boolean)ConfigHandler.CLIENT.showTooltips.get() == false ? 1 : 0)), () -> ToggleWidget.State.of((Boolean)ConfigHandler.CLIENT.showTooltips.get(), true), () -> class_2561.method_43471((String)"treechop.gui.settings.tooltip.tooltips"))));
        return optionRows;
    }

    private class_2561 getSneakCycleTooltip() {
        SettingsField field;
        switch (Client.getChopSettings().getSneakBehavior()) {
            case INVERT_CHOPPING: {
                field = SettingsField.CHOPPING;
                break;
            }
            default: {
                return class_2561.method_43471((String)"treechop.gui.settings.tooltip.sneaking_does_nothing");
            }
        }
        String enablesOrDisablesLangKey = Client.getChopSettings().get(field, Boolean.class) != false ? "treechop.gui.settings.tooltip.sneaking_enables_x" : "treechop.gui.settings.tooltip.sneaking_disables_x";
        return class_2561.method_43469((String)enablesOrDisablesLangKey, (Object[])new Object[]{field.getFancyName()});
    }

    private SneakBehavior getNextSneakBehavior() {
        return Client.getChopSettings().getSneakBehavior() == SneakBehavior.NONE ? SneakBehavior.INVERT_CHOPPING : SneakBehavior.NONE;
    }

    private ToggleGui makeToggleSettingRow(SettingsField field, String tooltipLangKey) {
        return new ToggleGui(() -> Client.getChopSettings().set(field, Client.getChopSettings().get(field, Boolean.class) == false), () -> ToggleWidget.State.of(Client.getChopSettings().get(field, Boolean.class), Client.getServerPermissions().isPermitted(new Setting(field, Client.getChopSettings().get(field, Boolean.class) == false))), () -> class_2561.method_43471((String)(tooltipLangKey + (Client.getChopSettings().get(field, Boolean.class) != false ? ".on" : ".off"))));
    }

    private boolean isSettingPermitted(SettingsField field, Object value) {
        return Client.getServerPermissions().isPermitted(new Setting(field, value));
    }

    private StickyWidget.State makeStickyWidgetState(SettingsField field, Object value) {
        return StickyWidget.State.of(Client.getChopSettings().get(field) == value, Client.getServerPermissions().isPermitted(new Setting(field, value)));
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (this.needToRebuild) {
            this.method_37067();
            this.rebuild();
            this.needToRebuild = false;
        }
        this.doneButton.method_46419(this.getDoneButtonTop());
        super.method_25394(gui, mouseX, mouseY, partialTicks);
        if (((Boolean)ConfigHandler.CLIENT.showTooltips.get()).booleanValue()) {
            GUIUtil.renderTooltip(gui);
        }
    }

    public boolean method_25421() {
        return true;
    }

    protected int getDoneButtonTop() {
        return this.optionsList.method_55443() + 10;
    }
}

