/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.slime;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.lunade.slime.LunaSlimesMain;
import net.lunade.slime.config.getter.ConfigValueGetter;
import net.lunade.slime.impl.SlimeInterface;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1621;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import org.jetbrains.annotations.NotNull;

public class SlimeMethods {
    public static void mergeSlimes(@NotNull class_1621 slime1, @NotNull class_1621 slime2) {
        int otherSize;
        int thisSize;
        class_1299 entityType = slime1.method_5864();
        if (slime2.method_5864() == entityType && slime1.method_5805() && slime2.method_5805() && ((thisSize = slime1.method_7152()) > (otherSize = slime2.method_7152()) || thisSize == otherSize) && thisSize <= ConfigValueGetter.maxSize() - 1 && ((SlimeInterface)slime1).lunaSlimes$getMergeCooldown() <= 0 && ((SlimeInterface)slime2).lunaSlimes$getMergeCooldown() <= 0) {
            boolean verticalCollision;
            class_4048 oldDimensions = SlimeMethods.getDimensionsForSize(slime1, thisSize);
            class_4048 inflated = SlimeMethods.getDimensionsForSize(slime1, thisSize + 1);
            class_243 newPos = slime1.method_19538().method_1031(0.0, (double)((inflated.comp_2186() - oldDimensions.comp_2186()) * 0.5f), 0.0);
            class_243 vec3 = slime1.method_18798();
            class_243 vec32 = SlimeMethods.collideWithBox(slime1, vec3, inflated.method_30757(newPos));
            boolean horizontalCollision = !class_3532.method_20390((double)vec3.field_1352, (double)vec32.field_1352) || !class_3532.method_20390((double)vec3.field_1350, (double)vec32.field_1350);
            boolean bl = verticalCollision = vec3.field_1351 != vec32.field_1351;
            if (!horizontalCollision && !verticalCollision) {
                slime1.method_7161(thisSize + 1, true);
                ((SlimeInterface)slime1).lunaSlimes$setMergeCooldown(ConfigValueGetter.mergeCooldown());
                ((SlimeInterface)slime1).lunaSlimes$playWobbleAnim();
                if (ConfigValueGetter.mergeSounds()) {
                    slime1.method_5783(entityType == class_1299.field_6102 ? LunaSlimesMain.MAGMA_MERGE : LunaSlimesMain.SLIME_MERGE, slime1.method_6107(), 1.0f + (slime1.method_59922().method_43057() - slime1.method_59922().method_43057()) * 0.4f);
                }
                ((SlimeInterface)slime2).lunaSlimes$playWobbleAnim();
                if (slime2.method_5947()) {
                    slime1.method_5971();
                }
                if (slime2.method_16914() && !slime1.method_16914()) {
                    slime1.method_5665(slime2.method_5797());
                }
                slime1.method_5684(slime2.method_5655());
                slime1.method_5803(slime2.method_5701());
                slime1.method_20803((int)Math.max((double)slime1.method_20802(), (double)slime2.method_20802() * 0.5));
                slime1.method_32317((int)Math.max((double)slime1.method_32312(), (double)slime2.method_32312() * 0.5));
                slime1.method_33574(newPos);
                if (otherSize - 1 <= 0) {
                    slime2.method_31472();
                } else {
                    slime2.method_7161(otherSize - 1, true);
                }
            }
        }
    }

    public static int spawnSingleSlime(@NotNull class_1621 origin) {
        int i = origin.method_7152();
        int splitOff = 0;
        if (!origin.method_37908().field_9236 && i > 1) {
            class_2561 component = origin.method_5797();
            boolean bl = origin.method_5987();
            float f = (float)i / 4.0f;
            int l = (int)((double)(2 + origin.method_59922().method_43048(3)) * origin.method_59922().method_43058());
            float g = ((float)(l % 2) - 0.5f) * f;
            float h = ((float)(l / 2) - 0.5f) * f;
            class_1299 entityType = origin.method_5864();
            class_1621 slime = (class_1621)entityType.method_5883(origin.method_37908());
            if (slime != null) {
                if (origin.method_5947()) {
                    slime.method_5971();
                }
                slime.method_5665(component);
                slime.method_5977(bl);
                slime.method_5684(origin.method_5655());
                slime.method_5803(origin.method_5701());
                splitOff = i % 2 == 0 ? (int)((double)i * 0.5) : 1;
                slime.method_7161(splitOff, true);
                slime.method_5808(origin.method_23317() + (double)g, origin.method_23318() + 0.5, origin.method_23321() + (double)h, origin.method_59922().method_43057() * 360.0f, 0.0f);
                ((SlimeInterface)origin).lunaSlimes$setMergeCooldown(ConfigValueGetter.onSplitCooldown());
                ((SlimeInterface)slime).lunaSlimes$setMergeCooldown(ConfigValueGetter.splitCooldown());
                ((SlimeInterface)origin).lunaSlimes$playWobbleAnim();
                ((SlimeInterface)slime).lunaSlimes$playWobbleAnim();
                SlimeMethods.spawnSlimeParticles(origin);
                slime.method_20803(origin.method_20802());
                slime.method_32317(origin.method_32312());
                slime.method_18799(origin.method_18798());
                origin.method_37908().method_8649((class_1297)slime);
                if (ConfigValueGetter.splitSounds()) {
                    slime.method_5783(entityType == class_1299.field_6102 ? LunaSlimesMain.MAGMA_SPLIT : LunaSlimesMain.SLIME_SPLIT, slime.method_6107(), 1.0f + (slime.method_59922().method_43057() - slime.method_59922().method_43057()) * 0.4f);
                }
            }
        }
        return splitOff;
    }

    public static void spawnSlimeParticles(@NotNull class_1621 slime) {
        class_1937 class_19372 = slime.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            if (ConfigValueGetter.particles()) {
                level.method_14199(slime.method_7162(), slime.method_23317(), slime.method_23323(0.6666666666666666), slime.method_23321(), level.field_9229.method_43051(slime.method_7152() * 6, slime.method_7152() * 12), (double)(slime.method_17681() / 4.0f), (double)(slime.method_17682() / 4.0f), (double)(slime.method_17681() / 4.0f), 0.05);
            }
        }
    }

    public static void spawnSlimeLandParticles(@NotNull class_1621 slime) {
        class_1937 class_19372 = slime.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            level.method_14199(slime.method_7162(), slime.method_23317(), slime.method_23318(), slime.method_23321(), level.field_9229.method_43051(slime.method_7152() * 6, slime.method_7152() * 8), (double)(slime.method_17681() / 3.5f), 0.0, (double)(slime.method_17681() / 3.5f), 0.05);
        }
    }

    public static float getSlimeScale(class_1621 slime, float partialTick) {
        return (ConfigValueGetter.growAnim() ? ((SlimeInterface)slime).lunaSlimes$getSizeScale(partialTick) : (float)slime.method_7152()) * ((SlimeInterface)slime).lunaSlimes$getDeathProgress(partialTick);
    }

    public static float getSlimeWobbleAnimProgress(class_1621 slime, float partialTick) {
        return ConfigValueGetter.wobbleAnim() ? ((SlimeInterface)slime).lunaSlimes$wobbleAnimProgress(partialTick) : 0.0f;
    }

    @NotNull
    public static Pair<Float, Float> wobbleAnim(class_1621 slime, float partialTick) {
        float cosWobble = (float)Math.cos(((double)SlimeMethods.getSlimeWobbleAnimProgress(slime, partialTick) + 0.3000220978560647) * Math.PI * 5.0);
        return Pair.of((Object)Float.valueOf(cosWobble * 0.1f + 1.0f), (Object)Float.valueOf(-(cosWobble * 0.025f) + 1.0f));
    }

    public static void setSquish(@NotNull class_1621 slime, float squish) {
        if (squish < slime.field_7389) {
            slime.field_7389 = squish;
        }
    }

    public static void setStretch(@NotNull class_1621 slime, float stretch) {
        if (stretch > slime.field_7389) {
            slime.field_7389 = stretch;
        }
    }

    @NotNull
    private static class_4048 getDimensionsForSize(@NotNull class_1621 slime, int size) {
        return slime.method_5864().method_18386().method_18383(0.255f * (float)size);
    }

    private static class_243 collideWithBox(@NotNull class_1621 slime, class_243 vec3, @NotNull class_238 aABB) {
        boolean bool;
        List list = slime.method_37908().method_20743((class_1297)slime, aABB.method_18804(vec3));
        class_243 vec32 = vec3.method_1027() == 0.0 ? vec3 : class_1297.method_20736((class_1297)slime, (class_243)vec3, (class_238)aABB, (class_1937)slime.method_37908(), (List)list);
        boolean bl = bool = slime.method_24828() || vec3.field_1351 != vec32.field_1351 && vec3.field_1351 < 0.0;
        if (slime.method_49476() > 0.0f && bool && (vec3.field_1352 != vec32.field_1352 || vec3.field_1350 != vec32.field_1350)) {
            class_243 vec33 = class_1297.method_20736((class_1297)slime, (class_243)new class_243(vec3.field_1352, (double)slime.method_49476(), vec3.field_1350), (class_238)aABB, (class_1937)slime.method_37908(), (List)list);
            class_243 vec34 = class_1297.method_20736((class_1297)slime, (class_243)new class_243(0.0, (double)slime.method_49476(), 0.0), (class_238)aABB.method_1012(vec3.field_1352, 0.0, vec3.field_1350), (class_1937)slime.method_37908(), (List)list);
            if (vec34.field_1351 < (double)slime.method_49476()) {
                class_243 class_2432;
                class_243 vec35 = class_1297.method_20736((class_1297)slime, (class_243)new class_243(vec3.field_1352, 0.0, vec3.field_1350), (class_238)aABB.method_997(vec34), (class_1937)slime.method_37908(), (List)list).method_1019(vec34);
                if (class_2432.method_37268() > vec33.method_37268()) {
                    vec33 = vec35;
                }
            }
            if (vec33.method_37268() > vec32.method_37268()) {
                return vec33.method_1019(class_1297.method_20736((class_1297)slime, (class_243)new class_243(0.0, -vec33.field_1351 + vec3.field_1351, 0.0), (class_238)aABB.method_997(vec33), (class_1937)slime.method_37908(), (List)list));
            }
        }
        return vec32;
    }
}

