/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.slime.render;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.lunade.slime.config.getter.ConfigValueGetter;
import net.minecraft.class_1921;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class SlimeTextures {
    private static final Map<Integer, class_2960> SLIME_TEXTURES = new Int2ObjectArrayMap();
    private static final Map<Integer, class_2960> MAGMA_CUBE_TEXTURES = new Int2ObjectArrayMap();
    private static final Map<Integer, class_2960> MAGMA_CUBE_OVERLAY_TEXTURES = new Int2ObjectArrayMap();
    private static final Map<Integer, class_1921> MAGMA_CUBE_OVERLAY_RENDER_TYPES = new Int2ObjectArrayMap();
    private static int max = 1;

    public static void setup(int max) {
        for (int i = 1; i < max + 1; ++i) {
            System.out.println(i);
            SlimeTextures.addEveryTexture(i);
        }
    }

    public static class_2960 getSlimeTexture(int size, class_2960 backUp) {
        if (ConfigValueGetter.scaleTextures()) {
            return SLIME_TEXTURES.computeIfAbsent(Math.min(size, max), integer -> backUp);
        }
        return backUp;
    }

    public static class_2960 getMamaCubeTexture(int size, class_2960 backUp) {
        if (ConfigValueGetter.scaleTextures()) {
            return MAGMA_CUBE_TEXTURES.computeIfAbsent(Math.min(size, max), integer -> backUp);
        }
        return backUp;
    }

    public static class_2960 getMagmaCubeOverlayTexture(int size, class_2960 backUp) {
        if (ConfigValueGetter.scaleTextures()) {
            return MAGMA_CUBE_OVERLAY_TEXTURES.computeIfAbsent(Math.min(size, max), integer -> backUp);
        }
        return backUp;
    }

    public static class_1921 getMagmaCubeOverlayRenderType(int size, class_1921 backUp) {
        if (ConfigValueGetter.scaleTextures()) {
            return MAGMA_CUBE_OVERLAY_RENDER_TYPES.computeIfAbsent(Math.min(size, max), integer -> backUp);
        }
        return backUp;
    }

    private static void addEveryTexture(int i) {
        SlimeTextures.addSlimeTexture(i);
        SlimeTextures.addMagmaCubeTexture(i);
        SlimeTextures.addMagmaCubeOverlayTexture(i);
        max = Math.max(i, max);
    }

    private static void addSlimeTexture(int i) {
        SLIME_TEXTURES.put(i, class_2960.method_43902((String)"lunaslimes", (String)("textures/entity/slime/slime_" + i + ".png")));
    }

    private static void addMagmaCubeTexture(int i) {
        MAGMA_CUBE_TEXTURES.put(i, class_2960.method_43902((String)"lunaslimes", (String)("textures/entity/slime/magmacube_" + i + ".png")));
    }

    private static void addMagmaCubeOverlayTexture(int i) {
        MAGMA_CUBE_OVERLAY_TEXTURES.put(i, class_2960.method_43902((String)"lunaslimes", (String)("textures/entity/slime/magmacube_overlay_" + i + ".png")));
    }

    private static void addMagmaCubeOverlayRenderType(int i) {
        MAGMA_CUBE_OVERLAY_RENDER_TYPES.put(i, class_1921.method_23026((class_2960)class_2960.method_43902((String)"lunaslimes", (String)("textures/entity/slime/magmacube_overlay_" + i + ".png"))));
    }
}

