/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import immersive_aircraft.config.configEntries.BooleanConfigEntry;
import immersive_aircraft.config.configEntries.FloatConfigEntry;
import immersive_aircraft.config.configEntries.IntegerConfigEntry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonConfig {
    public static final Logger LOGGER = LogManager.getLogger();
    public int version = 0;
    public final String name;

    int getVersion() {
        return 1;
    }

    public JsonConfig(String name) {
        this.name = name;
        for (Field field : this.getClass().getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                try {
                    if (annotation instanceof IntegerConfigEntry) {
                        IntegerConfigEntry entry = (IntegerConfigEntry)annotation;
                        field.setInt(this, entry.value());
                        continue;
                    }
                    if (annotation instanceof FloatConfigEntry) {
                        FloatConfigEntry entry = (FloatConfigEntry)annotation;
                        field.setFloat(this, entry.value());
                        continue;
                    }
                    if (!(annotation instanceof BooleanConfigEntry)) continue;
                    BooleanConfigEntry entry = (BooleanConfigEntry)annotation;
                    field.setBoolean(this, entry.value());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static File getConfigFile(String id) {
        return new File("./config/" + id + ".json");
    }

    public void save() {
        try (FileWriter writer = new FileWriter(JsonConfig.getConfigFile(this.name));){
            this.version = this.getVersion();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends JsonConfig> T loadOrCreate(T defaultConfig, Class<T> jsonClass) {
        String name = defaultConfig.name;
        if (!JsonConfig.getConfigFile(name).exists()) {
            defaultConfig.save();
            return defaultConfig;
        }
        try (FileReader reader = new FileReader(JsonConfig.getConfigFile(name));){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonConfig config = (JsonConfig)gson.fromJson((Reader)reader, jsonClass);
            if (config.version != config.getVersion()) {
                config = defaultConfig;
            }
            config.save();
            JsonConfig jsonConfig = config;
            return (T)jsonConfig;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config for '%s'! Default config is used for now. Delete the file to reset.".formatted(name));
            LOGGER.error((Object)e);
            return defaultConfig;
        }
    }
}

