/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import org.joml.Vector3f;

public abstract class AirplaneEntity
extends AircraftEntity {
    public AirplaneEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    @Override
    protected boolean useAirplaneControls() {
        return true;
    }

    @Override
    protected double method_7490() {
        Vector3f direction = this.getForwardDirection();
        float speed = (float)this.method_18798().method_1033() * (1.0f - Math.abs(direction.y));
        return (double)Math.max(0.0f, 1.0f - speed * 1.5f) * super.method_7490();
    }

    protected float getBrakeFactor() {
        return 0.95f;
    }

    @Override
    protected void updateController() {
        if (!this.method_5782()) {
            return;
        }
        super.updateController();
        if (this.movementY != 0.0f) {
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + 0.1f * this.movementY)));
            if (this.movementY < 0.0f) {
                this.method_18799(this.method_18798().method_1021((double)this.getBrakeFactor()));
            }
        }
        Vector3f direction = this.getForwardDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.getProperties().get(VehicleStat.ENGINE_SPEED));
        if (this.method_24828() && (double)this.getEngineTarget() < 1.0) {
            thrust = this.getProperties().get(VehicleStat.PUSH_SPEED) / (1.0f + (float)this.method_18798().method_1033() * 5.0f) * this.pressingInterpolatedZ.getSmooth() * (1.0f - this.getEnginePower());
        }
        this.method_18799(this.method_18798().method_1019(this.toVec3d(direction.mul(thrust))));
    }
}

