/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.WeaponRegistry;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.data.VehicleDataLoader;
import immersive_aircraft.entity.DyeableVehicleEntity;
import immersive_aircraft.entity.inventory.SparseSimpleInventory;
import immersive_aircraft.entity.inventory.VehicleInventoryDescription;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import immersive_aircraft.entity.misc.VehicleProperties;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.Telescope;
import immersive_aircraft.entity.weapon.Weapon;
import immersive_aircraft.item.WeaponItem;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.item.upgrade.VehicleUpgrade;
import immersive_aircraft.item.upgrade.VehicleUpgradeRegistry;
import immersive_aircraft.mixin.ServerPlayerEntityMixin;
import immersive_aircraft.network.s2c.OpenGuiRequest;
import immersive_aircraft.screen.VehicleScreenHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5630;
import net.minecraft.class_7225;
import net.minecraft.class_7248;
import net.minecraft.class_9284;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class InventoryVehicleEntity
extends DyeableVehicleEntity
implements class_1265,
class_3908,
class_1263,
class_7248 {
    private final VehicleProperties properties;
    private SparseSimpleInventory inventory;
    protected final Map<Integer, List<Weapon>> weapons = new HashMap<Integer, List<Weapon>>();
    private static final List<WeaponMount> EMPTY_WEAPONS = List.of(WeaponMount.EMPTY);
    private static final Map<WeaponMount.Type, List<WeaponMount>> EMPTY_WEAPONS_MAP = Map.of();

    public InventoryVehicleEntity(class_1299<? extends InventoryVehicleEntity> entityType, class_1937 world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
        this.initInventory();
        this.properties = new VehicleProperties(VehicleDataLoader.get(this.identifier).getProperties(), this);
    }

    public VehicleProperties getProperties() {
        return this.properties;
    }

    public VehicleInventoryDescription getInventoryDescription() {
        return VehicleDataLoader.get(this.identifier).getInventoryDescription();
    }

    public List<WeaponMount> getWeaponMounts(int slot) {
        class_1799 stack = this.method_32318(slot).method_32327();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof WeaponItem) {
            WeaponItem weaponItem = (WeaponItem)class_17922;
            return VehicleDataLoader.get(this.identifier).getWeaponMounts().getOrDefault(slot, EMPTY_WEAPONS_MAP).getOrDefault((Object)weaponItem.getMountType(), EMPTY_WEAPONS);
        }
        return EMPTY_WEAPONS;
    }

    public List<class_1799> getSlots(String slotType) {
        List<SlotDescription> slots = this.getInventoryDescription().getSlots(slotType);
        ArrayList<class_1799> list = new ArrayList<class_1799>(slots.size());
        for (SlotDescription slot : slots) {
            list.add(this.getInventory().method_5438(slot.index()));
        }
        return list;
    }

    public float getTotalUpgrade(VehicleStat stat) {
        float value = 1.0f;
        List<class_1799> upgrades = this.getSlots(VehicleInventoryDescription.UPGRADE);
        for (int step = 0; step < 2; ++step) {
            for (class_1799 stack : upgrades) {
                VehicleUpgrade upgrade = VehicleUpgradeRegistry.INSTANCE.getUpgrade(stack.method_7909());
                if (upgrade == null) continue;
                float u = upgrade.get(stat);
                if (u > 0.0f && step == 1) {
                    value += u;
                    continue;
                }
                if (!(u < 0.0f) || step != 0) continue;
                value *= u + 1.0f;
            }
        }
        return Math.max(0.0f, value);
    }

    protected void initInventory() {
        this.inventory = new SparseSimpleInventory(this.getInventoryDescription().getInventorySize());
        this.inventory.method_5489(this);
    }

    public SparseSimpleInventory getInventory() {
        int inventorySize = this.getInventoryDescription().getInventorySize();
        if (inventorySize != this.inventory.method_5439()) {
            this.initInventory();
        }
        return this.inventory;
    }

    public void method_5453(class_1263 sender) {
    }

    @Override
    protected void dropInventory() {
        for (SlotDescription slot : this.getInventoryDescription().getSlots()) {
            class_1799 stack;
            boolean isCargo = slot.type().equals(VehicleInventoryDescription.INVENTORY);
            if ((!isCargo || !Config.getInstance().dropInventory) && (isCargo || !Config.getInstance().dropUpgrades) || (stack = this.method_32318(slot.index()).method_32327()).method_7960()) continue;
            this.method_5775(stack.method_51164());
        }
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        return new VehicleScreenHandler(i, playerInventory, this);
    }

    public void openInventory(class_3222 player) {
        ((ServerPlayerEntityMixin)player).ic$nextContainerCounter();
        class_1703 screenHandler = this.createMenu(((ServerPlayerEntityMixin)player).getContainerCounter(), player.method_31548(), (class_1657)player);
        if (screenHandler != null) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(this, screenHandler.field_7763), player);
            player.field_7512 = screenHandler;
            ServerPlayerEntityMixin playerAccessor = (ServerPlayerEntityMixin)player;
            screenHandler.method_34248(playerAccessor.getContainerSynchronizer());
        }
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if ((double)this.getHealth() >= 1.0) {
            if (!player.method_37908().field_9236 && player.method_21823() && !this.method_5794((class_1297)player)) {
                class_1297 primaryPassenger = this.method_31483();
                if (primaryPassenger != null) {
                    primaryPassenger.method_5848();
                } else {
                    this.openInventory((class_3222)player);
                }
                return class_1269.field_21466;
            }
            if (this.getPassengerSpace() == 0 && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.openInventory(serverPlayer);
            }
        }
        return super.method_5688(player, hand);
    }

    @Override
    protected void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10566("Inventory", (class_2520)this.getInventory().method_7660((class_7225.class_7874)this.method_56673()));
    }

    @Override
    protected void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        class_2499 nbtList = tag.method_10554("Inventory", 10);
        this.getInventory().method_7659(nbtList, (class_7225.class_7874)this.method_56673());
    }

    @Override
    public void addItemTag(class_1799 stack) {
        super.addItemTag(stack);
        stack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493((List)this.getInventory().method_54454()));
    }

    @Override
    public void readItemTag(class_1799 stack) {
        super.readItemTag(stack);
        class_9288 contents = (class_9288)stack.method_57824(class_9334.field_49622);
        if (contents != null) {
            contents.method_57492(this.getInventory().method_54454());
        }
    }

    @Override
    public void boost() {
        int length = this.getSlots(VehicleInventoryDescription.BOOSTER).stream().mapToInt(s -> {
            class_9284 fireworks = (class_9284)s.method_57824(class_9334.field_49616);
            int l = fireworks == null ? 1 : fireworks.comp_2391();
            s.method_7934(1);
            return l;
        }).sum();
        super.boost(length * 50);
    }

    @Override
    protected void applyBoost() {
        super.applyBoost();
        Vector3f direction = this.getForwardDirection();
        float thrust = 0.05f * (float)this.getBoost() / 100.0f;
        this.method_18799(this.method_18798().method_1019(this.toVec3d(direction.mul(thrust))));
        if (this.field_6012 % 2 == 0) {
            class_243 p = this.method_19538();
            class_243 velocity = this.method_18798().method_1020(this.toVec3d(direction));
            this.method_37908().method_8406((class_2394)class_2398.field_11248, p.method_10216(), p.method_10214(), p.method_10215(), velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }

    @Override
    public boolean canBoost() {
        return this.getSlots(VehicleInventoryDescription.BOOSTER).stream().anyMatch(v -> !v.method_7960()) && this.getBoost() <= 0;
    }

    @Override
    public void method_5773() {
        this.getInventory().tick(this);
        for (SlotDescription slot : this.getInventoryDescription().getSlots(VehicleInventoryDescription.WEAPON)) {
            WeaponRegistry.WeaponConstructor constructor;
            class_1799 weaponItemStack = this.method_32318(slot.index()).method_32327();
            List<Weapon> weapon = this.weapons.get(slot.index());
            if (weaponItemStack.method_7960() && weapon != null) {
                this.weapons.remove(slot.index());
                continue;
            }
            if (weaponItemStack.method_7960() || weapon != null && weapon.get(0).getStack() == weaponItemStack || (constructor = WeaponRegistry.get(weaponItemStack)) == null) continue;
            List<WeaponMount> weaponMounts = this.getWeaponMounts(slot.index());
            ArrayList<Weapon> weapons = new ArrayList<Weapon>(weaponMounts.size());
            for (WeaponMount weaponMount : weaponMounts) {
                weapons.add(constructor.create(this, weaponItemStack, weaponMount, slot.index()));
            }
            this.weapons.put(slot.index(), weapons);
        }
        int gunnerOffset = this.method_5685().size();
        for (List<Weapon> weapons : this.getWeapons().values()) {
            --gunnerOffset;
            for (Weapon weapon : weapons) {
                weapon.setGunnerOffset(Math.max(0, gunnerOffset));
            }
        }
        for (List<Weapon> weapons : this.weapons.values()) {
            for (Weapon w : weapons) {
                w.tick();
            }
        }
        super.method_5773();
    }

    protected float getGroundDecay() {
        return this.getProperties().get(VehicleStat.GROUND_FRICTION);
    }

    protected void applyFriction() {
        float decay = 1.0f - this.getProperties().get(VehicleStat.FRICTION);
        double gravity = this.method_56989();
        if (this.field_5957) {
            gravity *= 0.25;
            decay = 0.9f;
        } else if (this.method_24828()) {
            decay = this.method_5782() ? this.getGroundDecay() : 0.75f;
        }
        class_243 velocity = this.method_18798();
        float hd = this.getProperties().get(VehicleStat.HORIZONTAL_DECAY);
        float vd = this.getProperties().get(VehicleStat.VERTICAL_DECAY);
        this.method_18800(velocity.field_1352 * (double)decay * (double)hd, velocity.field_1351 * (double)decay * (double)vd - gravity, velocity.field_1350 * (double)decay * (double)hd);
        float rf = decay * this.getProperties().get(VehicleStat.ROTATION_DECAY);
        this.pressingInterpolatedX.decay(0.0f, 1.0f - rf);
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - rf);
    }

    public class_5630 method_32318(int slot) {
        return class_5630.method_32328((class_1263)this.getInventory(), (int)slot);
    }

    public Map<Integer, List<Weapon>> getWeapons() {
        return this.weapons;
    }

    @Override
    public float getDurability() {
        return this.getProperties().get(VehicleStat.DURABILITY);
    }

    public boolean isScoping() {
        Collection<List<Weapon>> values = this.getWeapons().values();
        for (List<Weapon> weapons : values) {
            for (Weapon weapon : weapons) {
                Telescope telescope;
                if (!(weapon instanceof Telescope) || !(telescope = (Telescope)weapon).isScoping().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public int method_5439() {
        return this.inventory.method_5439();
    }

    public boolean method_5442() {
        return this.inventory.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.inventory.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.inventory.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.inventory.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.method_5447(slot, stack);
    }

    public void method_5431() {
        this.inventory.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public void method_5448() {
        this.inventory.method_5448();
    }

    public boolean method_5437(int index, class_1799 stack) {
        SlotDescription slotType = this.getInventoryDescription().getSlots().get(index);
        class_1735 slot = slotType.getSlot(this, (class_1263)this.inventory);
        return slot.method_7680(stack);
    }

    public boolean method_49104(class_1263 target, int index, class_1799 stack) {
        SlotDescription slotType = this.getInventoryDescription().getSlots().get(index);
        return slotType.type().equals(VehicleInventoryDescription.INVENTORY);
    }

    public void clientFireWeapons(class_1297 entity) {
        int gunnerIndex = this.method_5685().indexOf(entity);
        for (List<Weapon> weapons : this.getWeapons().values()) {
            int index = 0;
            for (Weapon weapon : weapons) {
                if (weapon.getGunnerOffset() != gunnerIndex) continue;
                weapon.clientFire(index++);
            }
        }
    }

    public void fireWeapon(int slot, int index, Vector3f direction) {
        this.getWeapons().get(slot).get(index).fire(direction);
    }

    public void method_6722(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.openInventory(serverPlayer);
        }
    }
}

