/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.resources.bbmodel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import immersive_aircraft.resources.bbmodel.BBFace;
import immersive_aircraft.resources.bbmodel.BBFaceContainer;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.resources.bbmodel.BBTexture;
import immersive_aircraft.util.Utils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BBCube
extends BBObject
implements BBFaceContainer {
    private static final String[] SIDES = new String[]{"north", "east", "south", "west", "up", "down"};
    private static final Vector3f[] NORMALS = new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};
    private static final int[][] VERTEX_ORDER = new int[][]{{1, 4, 6, 3}, {0, 1, 3, 2}, {5, 0, 2, 7}, {4, 5, 7, 6}, {4, 1, 0, 5}, {7, 2, 3, 6}};
    public final Vector3f from;
    public final Vector3f to;
    public final int inflate;
    public final List<BBFace> faces;
    private final boolean backfaceCulling;

    public BBCube(JsonObject element, BBModel model) {
        super(element);
        int i;
        BBFace f;
        int i2;
        this.from = Utils.parseVector(element, "from");
        this.to = Utils.parseVector(element, "to");
        this.inflate = Utils.getIntElement(element, "inflate");
        this.faces = new LinkedList<BBFace>();
        for (int i3 = 0; i3 < 6; ++i3) {
            BBFace.BBVertex[] vertices = new BBFace.BBVertex[4];
            for (int j = 0; j < 4; ++j) {
                vertices[j] = new BBFace.BBVertex();
            }
            this.faces.add(new BBFace(vertices));
        }
        Vector3f[] positions = this.getPositions();
        for (i2 = 0; i2 < 6; ++i2) {
            int[] order = VERTEX_ORDER[i2];
            for (int j = 0; j < 4; ++j) {
                f = this.faces.get(i2);
                f.vertices[j].x = positions[order[3 - j]].x();
                f.vertices[j].y = positions[order[3 - j]].y();
                f.vertices[j].z = positions[order[3 - j]].z();
            }
        }
        for (i2 = 0; i2 < 6; ++i2) {
            for (int j = 0; j < 4; ++j) {
                BBFace f2 = this.faces.get(i2);
                f2.vertices[j].nx = NORMALS[i2].x();
                f2.vertices[j].ny = NORMALS[i2].y();
                f2.vertices[j].nz = NORMALS[i2].z();
            }
        }
        double[] u = new double[24];
        double[] v = new double[24];
        for (i = 0; i < 6; ++i) {
            JsonObject faceObject = element.getAsJsonObject("faces").getAsJsonObject(SIDES[i]);
            if (Utils.isNull(faceObject, "texture")) continue;
            int id = Utils.getIntElement(faceObject, "texture");
            BBTexture texture = model.getTexture(id);
            BBFace f3 = this.faces.get(i);
            f3.texture = texture;
            float[] uv = new float[4];
            Iterator uvArray = faceObject.getAsJsonArray("uv").iterator();
            for (int j = 0; j < 4; ++j) {
                uv[j] = ((JsonElement)uvArray.next()).getAsFloat();
            }
            for (int rot = Utils.getIntElement(faceObject, "rotation"); rot > 0; rot -= 90) {
                this.roll(u, i);
                this.roll(v, i);
            }
            float textureWidth = model.getTextureWidth(texture);
            float textureHeight = model.getTextureHeight(texture);
            f3.vertices[0].u = uv[0] / textureWidth;
            f3.vertices[0].v = uv[3] / textureHeight;
            f3.vertices[1].u = uv[2] / textureWidth;
            f3.vertices[1].v = uv[3] / textureHeight;
            f3.vertices[2].u = uv[2] / textureWidth;
            f3.vertices[2].v = uv[1] / textureHeight;
            f3.vertices[3].u = uv[0] / textureWidth;
            f3.vertices[3].v = uv[1] / textureHeight;
        }
        for (i = this.faces.size() - 1; i >= 0; --i) {
            f = this.faces.get(i);
            float v0x = f.vertices[1].x - f.vertices[0].x;
            float v0y = f.vertices[1].y - f.vertices[0].y;
            float v0z = f.vertices[1].z - f.vertices[0].z;
            float v1x = f.vertices[2].x - f.vertices[0].x;
            float v1y = f.vertices[2].y - f.vertices[0].y;
            float v1z = f.vertices[2].z - f.vertices[0].z;
            if (f.texture != null && (v0x * v1y - v0y * v1x != 0.0f || v0x * v1z - v0z * v1x != 0.0f || v0y * v1z - v0z * v1y != 0.0f)) continue;
            this.faces.remove(i);
        }
        boolean flat = this.getVolume() < 0.01f;
        this.backfaceCulling = flat && this.faces.size() > 1;
    }

    private float getVolume() {
        float x2 = Float.MIN_VALUE;
        float y2 = Float.MIN_VALUE;
        float z2 = Float.MIN_VALUE;
        float x1 = Float.MAX_VALUE;
        float y1 = Float.MAX_VALUE;
        float z1 = Float.MAX_VALUE;
        for (BBFace f : this.faces) {
            for (BBFace.BBVertex vert : f.vertices) {
                x1 = Math.min(x1, vert.x);
                y1 = Math.min(y1, vert.y);
                z1 = Math.min(z1, vert.z);
                x2 = Math.max(x2, vert.x);
                y2 = Math.max(y2, vert.y);
                z2 = Math.max(z2, vert.z);
            }
        }
        return (x2 - x1) * (y2 - y1) * (z2 - z1);
    }

    @NotNull
    private Vector3f[] getPositions() {
        Vector3f adjustedFrom = this.from;
        Vector3f adjustedTo = this.to;
        Vector3f inflate = new Vector3f((float)this.inflate, (float)this.inflate, (float)this.inflate);
        adjustedFrom.sub((Vector3fc)inflate);
        adjustedTo.add((Vector3fc)inflate);
        adjustedFrom.mul(0.0625f);
        adjustedTo.mul(0.0625f);
        adjustedFrom.sub((Vector3fc)this.origin);
        adjustedTo.sub((Vector3fc)this.origin);
        return new Vector3f[]{new Vector3f(adjustedTo.x(), adjustedTo.y(), adjustedTo.z()), new Vector3f(adjustedTo.x(), adjustedTo.y(), adjustedFrom.z()), new Vector3f(adjustedTo.x(), adjustedFrom.y(), adjustedTo.z()), new Vector3f(adjustedTo.x(), adjustedFrom.y(), adjustedFrom.z()), new Vector3f(adjustedFrom.x(), adjustedTo.y(), adjustedFrom.z()), new Vector3f(adjustedFrom.x(), adjustedTo.y(), adjustedTo.z()), new Vector3f(adjustedFrom.x(), adjustedFrom.y(), adjustedFrom.z()), new Vector3f(adjustedFrom.x(), adjustedFrom.y(), adjustedTo.z())};
    }

    private void roll(double[] u, int i) {
        double lastU = u[i * 4 + 3];
        for (int j = 3; j > 0; --j) {
            u[i * 4 + j] = u[i * 4 + j - 1];
        }
        u[i * 4] = lastU;
    }

    @Override
    public Iterable<BBFace> getFaces() {
        return this.faces;
    }

    @Override
    public boolean enableCulling() {
        return this.backfaceCulling;
    }
}

