/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.block.entity.client;

import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.shirojr.boatism.Boatism;
import net.shirojr.boatism.BoatismClient;
import net.shirojr.boatism.block.custom.FermentBlock;
import net.shirojr.boatism.block.entity.client.FermentBlockEntityModel;
import net.shirojr.boatism.block.entity.custom.FermentBlockEntity;
import net.shirojr.boatism.util.LoggerUtil;
import org.jetbrains.annotations.Nullable;

public class FermentBlockEntityRenderer<T extends FermentBlockEntity>
implements class_827<T> {
    private final FermentBlockEntityModel model;
    private float prevLidOpenTick = 0.0f;

    public FermentBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.model = new FermentBlockEntityModel(ctx.method_32140(BoatismClient.FERMENTER_LAYER));
    }

    public void render(FermentBlockEntity blockEntity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        float normalizedLidOpenState = this.getNormalizedLidOpenState(blockEntity, tickDelta);
        this.prevLidOpenTick = blockEntity.getLidOpeningTick();
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(((class_2350)blockEntity.method_11010().method_11654((class_2769)FermentBlock.FACING)).method_10144()));
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23576((class_2960)Boatism.getId("textures/entity/fermenter.png")));
        this.model.render(normalizedLidOpenState, tickDelta, matrices, vertexConsumer, light, overlay, class_5253.class_5254.method_59554((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
        matrices.method_22909();
    }

    private void renderFluid(@Nullable FluidVariant fluid, double normalizedProgress, class_4597 vertexConsumers, class_4587 matrices, class_243 start, class_243 end) {
        if (fluid == null || fluid.isBlank()) {
            return;
        }
        class_1058 stillSprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        if (stillSprite == null) {
            return;
        }
        float maxFluidHeight = 64.0f;
        class_1921 renderLayer = class_1921.method_29379((class_2960)stillSprite.method_45852());
        class_4588 vertexConsumer = vertexConsumers.getBuffer(renderLayer);
        matrices.method_22903();
        matrices.method_22909();
    }

    private float getNormalizedLidOpenState(FermentBlockEntity blockEntity, float tickDelta) {
        float normalizedLidOpenState;
        if (blockEntity.isLidOpen()) {
            normalizedLidOpenState = 1.0f;
        } else if (blockEntity.isLidClosed()) {
            normalizedLidOpenState = 0.0f;
        } else {
            float interpolated;
            if (this.prevLidOpenTick < (float)blockEntity.getLidOpeningTick()) {
                interpolated = (float)blockEntity.getLidOpeningTick() + tickDelta;
                LoggerUtil.devLogger("Opens");
            } else if (this.prevLidOpenTick == (float)blockEntity.getLidOpeningTick()) {
                interpolated = blockEntity.getLidOpeningTick();
            } else {
                interpolated = (float)blockEntity.getLidOpeningTick() - tickDelta;
                LoggerUtil.devLogger("Closes");
            }
            LoggerUtil.devLogger(String.valueOf(interpolated));
            normalizedLidOpenState = class_3532.method_15363((float)interpolated, (float)0.0f, (float)5.0f) / 5.0f;
        }
        return normalizedLidOpenState;
    }
}

