/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.block.entity.custom;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7225;
import net.shirojr.boatism.block.custom.FermentBlock;
import net.shirojr.boatism.init.BoatismBlockEntities;
import net.shirojr.boatism.init.BoatismFluids;
import net.shirojr.boatism.util.storage.FermentingInventory;
import net.shirojr.boatism.util.tag.BoatismTags;
import org.jetbrains.annotations.Nullable;

public class FermentBlockEntity
extends class_2586 {
    public static final int LID_TOGGLE_DURATION = 5;
    public static final int HEAT_UP_DURATION = 100;
    public static final int MIXING_DURATION = 200;
    public static final long FLUID_CAPACITY = 405000L;
    public static final int STACKS_CAPACITY = 4;
    public static final FluidVariant INPUT_FLUID = FluidVariant.of((class_3611)class_3612.field_15910);
    private int lidOpeningTick;
    private int heatTick;
    private int mixingTick;
    private final FermentingInventory inventory = new FermentingInventory(405000L, FermentingInventory.getSimpleFluidPredicate(FluidVariant.of((class_3611)class_3612.field_15910), FluidVariant.of((class_3611)BoatismFluids.OIL.still())), 4);

    public FermentBlockEntity(class_2338 pos, class_2680 state) {
        super(BoatismBlockEntities.FERMENTER, pos, state);
    }

    public FermentingInventory getInventory() {
        return this.inventory;
    }

    public void modifyInventory(BiConsumer<FermentingInventory, class_1937> inventoryProvider) {
        inventoryProvider.accept(this.inventory, this.method_10997());
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.method_11016());
            this.method_5431();
        }
    }

    public int getLidOpeningTick() {
        return this.lidOpeningTick;
    }

    public void setLidOpeningTick(int lidOpeningTick) {
        this.lidOpeningTick = lidOpeningTick;
        if (this.getLidOpeningTick() >= 5 || this.getLidOpeningTick() <= 0) {
            this.method_5431();
        }
    }

    public boolean isLidOpen() {
        return (Boolean)this.method_11010().method_11654((class_2769)FermentBlock.OPEN) != false && this.getLidOpeningTick() >= 5;
    }

    public boolean isLidClosed() {
        return (Boolean)this.method_11010().method_11654((class_2769)FermentBlock.OPEN) == false && this.getLidOpeningTick() <= 0;
    }

    public int getHeatTick() {
        return this.heatTick;
    }

    public void setHeatTick(int heatTick) {
        this.heatTick = heatTick;
        if (this.getHeatTick() >= 100 || this.getHeatTick() <= 0) {
            this.method_5431();
        }
    }

    public boolean isReceivingHeat() {
        if (this.field_11863 == null) {
            return false;
        }
        class_2680 stateBelow = this.field_11863.method_8320(this.field_11867.method_10074());
        if (!stateBelow.method_28498((class_2769)class_2741.field_12548)) {
            return false;
        }
        return (Boolean)stateBelow.method_11654((class_2769)class_2741.field_12548);
    }

    public boolean canCaptureHeat() {
        return this.getLidOpeningTick() <= 0;
    }

    public boolean isFullyHeated() {
        return this.getHeatTick() >= 100;
    }

    public int getMixingTick() {
        return this.mixingTick;
    }

    public void setMixingTick(int mixingTick) {
        this.mixingTick = mixingTick;
        if (this.getMixingTick() >= 200 || this.getMixingTick() <= 0) {
            this.method_5431();
        }
    }

    public void addMixingTick(int value) {
        this.setMixingTick(class_3532.method_15340((int)(this.getMixingTick() + value), (int)0, (int)200));
    }

    public boolean isValidFluidStack(class_1799 stack) {
        if (stack.method_7960()) {
            return true;
        }
        Storage storage = (Storage)ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM);
        if (storage == null) {
            return false;
        }
        for (StorageView entry : storage) {
            if (((FluidVariant)entry.getResource()).equals((Object)INPUT_FLUID) || entry.isResourceBlank()) continue;
            return false;
        }
        return storage.supportsInsertion();
    }

    public boolean canAcceptFluid(FluidVariant fluid, long amount) {
        SingleFluidStorage fluidStorage = this.getInventory().getFluidStorage();
        return this.isLidOpen() && fluidStorage.getAmount() < fluidStorage.getCapacity();
    }

    public boolean canAcceptFluid(class_1799 stack) {
        if (!this.isValidFluidStack(stack)) {
            return false;
        }
        SingleFluidStorage fluidStorage = this.getInventory().getFluidStorage();
        return this.isLidOpen() && fluidStorage.getAmount() < fluidStorage.getCapacity();
    }

    public boolean hasAllIngredients() {
        if (!this.getInventory().getFluidVariant().equals((Object)INPUT_FLUID)) {
            return false;
        }
        for (class_1799 stack : this.getInventory().method_54454()) {
            if (stack.method_7960()) {
                return false;
            }
            if (stack.method_31573(BoatismTags.Items.FERMENTABLE)) continue;
            return false;
        }
        return true;
    }

    public boolean finishedFermenting() {
        return this.getMixingTick() >= 200;
    }

    private void finishFermenting() {
        this.modifyInventory((fermentingInventory, world) -> {
            long amount = fermentingInventory.getFluidStorage().getAmount();
            fermentingInventory.clearItemsAndFluid();
            fermentingInventory.insertFluid(FluidVariant.of((class_3611)BoatismFluids.OIL.still()), amount);
        });
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            FermentBlock.toggleOpenedState((class_1937)serverWorld, this.method_11016());
        }
    }

    public boolean extractAndFillCanister(class_1657 player, class_1268 hand) {
        block8: {
            ContainerItemContext handContext = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
            Storage itemFluidStorage = (Storage)handContext.find(FluidStorage.ITEM);
            if (itemFluidStorage == null) {
                return false;
            }
            try (Transaction transaction = Transaction.openOuter();){
                Predicate<FluidVariant> filter = variant -> variant.isOf((Object)class_3612.field_15910) || variant.isOf((Object)BoatismFluids.OIL.still());
                long fluidMoved = StorageUtil.move((Storage)this.getInventory().getFluidStorage(), (Storage)itemFluidStorage, filter, (long)81000L, (TransactionContext)transaction);
                if (fluidMoved == 81000L) {
                    transaction.commit();
                    break block8;
                }
                transaction.abort();
                boolean bl = false;
                return bl;
            }
        }
        this.playSound(player.method_37908(), class_3417.field_15126);
        return true;
    }

    public boolean insertAndEmptyCanister(class_1657 player, class_1268 hand) {
        block8: {
            ContainerItemContext handContext = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
            Storage itemFluidStorage = (Storage)handContext.find(FluidStorage.ITEM);
            if (itemFluidStorage == null) {
                return false;
            }
            try (Transaction transaction = Transaction.openOuter();){
                Predicate<FluidVariant> filter = variant -> variant.isOf((Object)class_3612.field_15910) || variant.isOf((Object)BoatismFluids.OIL.still());
                long fluidMoved = StorageUtil.move((Storage)itemFluidStorage, (Storage)this.getInventory().getFluidStorage(), filter, (long)81000L, (TransactionContext)transaction);
                if (fluidMoved == 81000L) {
                    transaction.commit();
                    break block8;
                }
                transaction.abort();
                boolean bl = false;
                return bl;
            }
        }
        this.playSound(player.method_37908(), class_3417.field_14834);
        return true;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, FermentBlockEntity blockEntity) {
        if (world == null) {
            return;
        }
        if (((Boolean)state.method_11654((class_2769)FermentBlock.OPEN)).booleanValue() && blockEntity.getLidOpeningTick() < 5) {
            blockEntity.setLidOpeningTick(blockEntity.getLidOpeningTick() + 1);
            if (blockEntity.isLidOpen()) {
                blockEntity.playSound(world, class_3417.field_46937);
            }
        } else if (!((Boolean)state.method_11654((class_2769)FermentBlock.OPEN)).booleanValue() && blockEntity.getLidOpeningTick() > 0) {
            blockEntity.setLidOpeningTick(blockEntity.getLidOpeningTick() - 1);
            if (blockEntity.isLidClosed()) {
                blockEntity.playSound(world, class_3417.field_46936);
            }
        }
        if (blockEntity.isReceivingHeat() && blockEntity.canCaptureHeat()) {
            if (!blockEntity.isFullyHeated()) {
                blockEntity.setHeatTick(blockEntity.getHeatTick() + 1);
            }
        } else if (blockEntity.getHeatTick() > 0) {
            blockEntity.setHeatTick(blockEntity.getHeatTick() - 1);
        }
        if (blockEntity.isFullyHeated() && blockEntity.hasAllIngredients()) {
            blockEntity.addMixingTick(1);
        } else if (blockEntity.getHeatTick() > 0) {
            blockEntity.addMixingTick(-1);
        }
        if (blockEntity.finishedFermenting()) {
            blockEntity.finishFermenting();
        }
    }

    private void playSound(class_1937 world, class_3414 soundEvent) {
        if (world.method_8608()) {
            return;
        }
        world.method_8396(null, this.method_11016(), soundEvent, class_3419.field_15245, 2.0f, 1.0f);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt, registryLookup);
        return this.method_38244(registryLookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10545("inventory")) {
            class_2499 list = nbt.method_10554("inventory", 10);
            this.getInventory().method_7659(list, registryLookup);
        }
        this.setLidOpeningTick(nbt.method_10550("lidOpeningTick"));
        this.setHeatTick(nbt.method_10550("heatTick"));
        this.setMixingTick(nbt.method_10550("mixingTick"));
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2499 list = this.getInventory().method_7660(registryLookup);
        nbt.method_10566("inventory", (class_2520)list);
        nbt.method_10569("lidOpeningTick", this.getLidOpeningTick());
        nbt.method_10569("heatTick", this.getHeatTick());
        nbt.method_10569("mixingTick", this.getMixingTick());
    }
}

