/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.entity.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2379;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5362;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import net.shirojr.boatism.Boatism;
import net.shirojr.boatism.api.BoatEngineComponent;
import net.shirojr.boatism.api.BoatEngineCoupler;
import net.shirojr.boatism.entity.animation.BoatismAnimation;
import net.shirojr.boatism.init.BoatismEntities;
import net.shirojr.boatism.init.BoatismEntityAttributeModifierIdentifiers;
import net.shirojr.boatism.init.BoatismGameRules;
import net.shirojr.boatism.init.BoatismSounds;
import net.shirojr.boatism.init.BoatismStorage;
import net.shirojr.boatism.network.packet.EngineComponentSyncPacket;
import net.shirojr.boatism.network.packet.StartSoundInstancePacket;
import net.shirojr.boatism.network.packet.StoppedTrackingEnginePacket;
import net.shirojr.boatism.util.BoatEngineExplosionBehaviour;
import net.shirojr.boatism.util.LoggerUtil;
import net.shirojr.boatism.util.data.EngineComponent;
import net.shirojr.boatism.util.data.codec.BoatismCodecs;
import net.shirojr.boatism.util.handler.BoatEngineHandler;
import net.shirojr.boatism.util.handler.EntityHandler;
import net.shirojr.boatism.util.nbt.BoatEngineNbtHelper;
import net.shirojr.boatism.util.sound.SoundInstanceIdentifier;
import net.shirojr.boatism.util.tag.BoatismTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoatEngineEntity
extends class_1309 {
    private final class_1277 mountedInventory;
    private final class_3913 propertyDelegate;
    private static final class_2940<Integer> POWER_LEVEL = class_2945.method_12791(BoatEngineEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> OVERHEAT = class_2945.method_12791(BoatEngineEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<class_2379> ARM_ROTATION = class_2945.method_12791(BoatEngineEntity.class, (class_2941)class_2943.field_13316);
    private static final class_2940<Boolean> SUBMERGED = class_2945.method_12791(BoatEngineEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> RUNNING = class_2945.method_12791(BoatEngineEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Long> FUEL = class_2945.method_12791(BoatEngineEntity.class, (class_2941)class_2943.field_39965);
    private static final class_2940<Boolean> LOCKED = class_2945.method_12791(BoatEngineEntity.class, (class_2941)class_2943.field_13323);
    public static final int INVENTORY_SIZE = 32;
    public final class_7094 leftSpinAnimationState = new class_7094();
    public float spinAnimationTimeout = 0.0f;
    @Nullable
    private UUID hookedBoatEntityUuid;
    @NotNull
    private final BoatEngineHandler engineHandler;
    private class_243 previousLocation = class_243.field_1353;

    public BoatEngineEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
        this.engineHandler = BoatEngineHandler.create(this);
        this.mountedInventory = new class_1277(32);
        this.method_5875(true);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> {
                        if (BoatEngineEntity.this.engineHandler.engineIsRunning()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 1 -> BoatEngineEntity.this.getPowerLevel();
                    case 2 -> Math.round(BoatEngineEntity.this.getFuel() * 100L);
                    case 3 -> Math.round(BoatEngineEntity.this.engineHandler.getMaxFuelCapacity() * 100L);
                    case 4 -> Math.round(BoatEngineEntity.this.getOverheat() * 100.0f);
                    case 5 -> Math.round(BoatEngineEntity.this.engineHandler.getMaxOverHeatCapacity() * 100.0f);
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                if (index == 0) {
                    BoatEngineEntity.this.setPowerLevel(value);
                }
            }

            public int method_17389() {
                return 6;
            }
        };
    }

    public BoatEngineEntity(class_1937 world, double x, double y, double z) {
        this(BoatismEntities.BOAT_ENGINE, world);
        this.method_5814(x, y, z);
    }

    public BoatEngineEntity(class_1937 world, class_1690 hookedBoatEntity) {
        this(BoatismEntities.BOAT_ENGINE, world);
        this.method_23327(hookedBoatEntity.method_23317(), hookedBoatEntity.method_23318(), hookedBoatEntity.method_23321());
        this.hookOntoBoatEntity(hookedBoatEntity);
        this.previousLocation = hookedBoatEntity.method_19538();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(POWER_LEVEL, (Object)0);
        builder.method_56912(OVERHEAT, (Object)Float.valueOf(0.0f));
        builder.method_56912(ARM_ROTATION, (Object)new class_2379(0.0f, 5.0f, 0.0f));
        builder.method_56912(SUBMERGED, (Object)false);
        builder.method_56912(FUEL, (Object)0L);
        builder.method_56912(LOCKED, (Object)false);
        builder.method_56912(RUNNING, (Object)false);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, (double)Boatism.CONFIG.health).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 0.0).method_26868(class_5134.field_23725, 15.0);
    }

    private void updateAnimationStates() {
        if (this.getPowerLevel() > 0) {
            if (this.spinAnimationTimeout <= 0.0f) {
                this.spinAnimationTimeout = BoatismAnimation.SPIN_DURATION_IN_SEC * 20.0f;
                this.leftSpinAnimationState.method_41322(this.field_6012);
            }
            this.spinAnimationTimeout -= 1.0f;
        } else {
            this.leftSpinAnimationState.method_41325();
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.getHookedBoatEntityUuid().ifPresent(hookedBoatEntityUuid -> nbt.method_25927("HookedEntity", hookedBoatEntityUuid));
        BoatEngineNbtHelper.writeItemStacksToNbt((class_2371<class_1799>)this.mountedInventory.method_54454(), "MountedItems", nbt);
        nbt.method_10556("IsRunning", this.isRunning());
        nbt.method_10569("PowerOutput", this.getPowerLevel());
        nbt.method_10548("Overheat", this.getOverheat());
        nbt.method_10566("EngineRotation", (class_2520)this.getArmRotation().method_10255());
        nbt.method_10556("IsSubmerged", this.isSubmerged());
        nbt.method_10548("Fuel", (float)this.getFuel());
        nbt.method_10556("IsLocked", this.isLocked());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("HookedEntity")) {
            this.setHookedBoatEntity(nbt.method_25926("HookedEntity"));
        }
        if (nbt.method_10545("MountedItems")) {
            this.mountedInventory.method_5448();
            this.setMountedItemsFromItemStackList(BoatEngineNbtHelper.readItemStacksFromNbt(nbt, "MountedItems"));
            this.syncComponentListToTrackingClients();
        }
        this.setIsRunning(nbt.method_10577("IsRunning"));
        this.setPowerLevel(Math.min(nbt.method_10550("PowerOutput"), 4));
        this.setOverheat(nbt.method_10583("Overheat"));
        this.setArmRotation(new class_2379(nbt.method_10554("EngineRotation", 5)));
        this.setSubmerged(nbt.method_10577("IsSubmerged"));
        this.setFuel(nbt.method_10537("Fuel"));
        this.setLocked(nbt.method_10577("IsLocked"));
    }

    public void syncComponentListToTrackingClients() {
        if (this.method_37908().method_8608()) {
            return;
        }
        PlayerLookup.tracking((class_1297)this).forEach(player -> {
            ArrayList<EngineComponent> engineComponentList = new ArrayList<EngineComponent>();
            for (int slot = 0; slot < this.getMountedInventory().method_5439(); ++slot) {
                class_1799 stack = this.getMountedInventory().method_5438(slot);
                if (stack.method_7960()) continue;
                engineComponentList.add(new EngineComponent(slot, this.getMountedInventory().method_5438(slot)));
            }
            new EngineComponentSyncPacket(this.method_5628(), engineComponentList).sendPacket((class_3222)player);
        });
    }

    public void method_5773() {
        super.method_5773();
        this.method_5875(true);
        if (this.method_37908().method_8608()) {
            this.updateAnimationStates();
            return;
        }
        if (this.isRunning()) {
            this.getHookedBoatEntity().ifPresent(boatEntity -> {
                double actualSpeed = Math.max(0.0, this.previousLocation.method_1022(this.method_19538()));
                this.modifyVelocity((class_1690)boatEntity);
                if (this.getPowerLevel() > 3 && actualSpeed < 0.1) {
                    this.setOverheat(this.getOverheat() + 2.0f);
                }
                if (this.method_24828() && !this.method_5799() && this.engineHandler.engineIsRunning()) {
                    this.setOverheat(this.getOverheat() + 2.0f);
                }
            });
            this.previousLocation = this.method_19538();
            if (this.isSubmerged()) {
                this.method_5855(this.method_5748());
            }
        }
        this.engineHandler.setSubmerged(this.field_6000);
        this.engineHandler.incrementTick();
    }

    private void modifyVelocity(class_1690 boatEntity) {
        if (boatEntity.method_5642() instanceof class_1657) {
            return;
        }
        if (!this.method_5787()) {
            return;
        }
        if (boatEntity.method_24828()) {
            this.setOverheat(this.getOverheat() + 4.0f);
        } else {
            class_243 newVelocity = boatEntity.method_5720().method_18805(1.0, 0.0, 1.0).method_1029().method_1021((double)this.getPowerLevel() * 0.1).method_1021((double)this.engineHandler.calculateThrustModifier(boatEntity));
            if (boatEntity.method_18798().method_37267() < newVelocity.method_37267()) {
                boatEntity.method_60491(newVelocity);
            }
        }
        boatEntity.field_6037 = true;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            if (stack.method_7909() instanceof BoatEngineComponent) {
                if (this.engineHandler.canEquipPart(stack) && !this.mountedInventoryContains(stack)) {
                    this.addToMountedInventory(stack);
                    if (this.method_37908().method_8608()) {
                        return class_1269.field_5812;
                    }
                    LoggerUtil.devLogger(String.format("Equipped component %s on the engine", stack.method_7964()));
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    player.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), BoatismSounds.BOAT_ENGINE_EQUIP, class_3419.field_15254, 0.7f, 1.0f);
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"warning.boatism.component_is_blocked"), true);
            } else if (stack.method_7960() && this.getMountedInventorySize() > 0) {
                EntityHandler.dropMountedInventory(this, false, true);
                this.syncComponentListToTrackingClients();
                if (this.method_37908().method_8608()) {
                    return class_1269.field_5812;
                }
                player.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), BoatismSounds.BOAT_ENGINE_EQUIP, class_3419.field_15254, 0.7f, 1.0f);
            }
        } else if (stack.method_7960()) {
            if (!this.engineHandler.engineIsRunning()) {
                this.engineHandler.startEngine();
            } else {
                this.engineHandler.stopEngine();
            }
            LoggerUtil.devLogger(String.format("Engine is running: %s", this.engineHandler.engineIsRunning()));
            return class_1269.field_5812;
        }
        return super.method_5688(player, hand);
    }

    public void method_5837(class_3222 player) {
        ArrayList<SoundInstanceIdentifier> identifierList = new ArrayList<SoundInstanceIdentifier>();
        this.syncComponentListToTrackingClients();
        this.sendPacketForStoppingAllSoundInstances(player);
        if (this.engineHandler.engineIsRunning()) {
            identifierList.add(SoundInstanceIdentifier.ENGINE_RUNNING);
        }
        if (this.engineHandler.isLowHealth()) {
            identifierList.add(SoundInstanceIdentifier.ENGINE_LOW_HEALTH);
        }
        if (this.engineHandler.isLowOnFuel()) {
            identifierList.add(SoundInstanceIdentifier.ENGINE_LOW_FUEL);
        }
        if (this.engineHandler.isSubmerged()) {
            identifierList.add(SoundInstanceIdentifier.ENGINE_RUNNING_UNDERWATER);
        }
        if (this.engineHandler.isHeatingUp()) {
            identifierList.add(SoundInstanceIdentifier.ENGINE_OVERHEATING);
        }
        identifierList.forEach(identifier -> this.sendPacketForSoundInstance((SoundInstanceIdentifier)((Object)identifier), player));
        super.method_5837(player);
    }

    public void method_5742(class_3222 player) {
        this.sendPacketForStoppingAllSoundInstances(player);
        super.method_5742(player);
    }

    private void sendPacketForSoundInstance(SoundInstanceIdentifier soundIdentifier, class_3222 player) {
        new StartSoundInstancePacket(this.method_5628(), soundIdentifier.getIdentifier()).sendPacket(player);
        super.method_5742(player);
    }

    private void sendPacketForStoppingAllSoundInstances(class_3222 player) {
        new StoppedTrackingEnginePacket(this.method_5628(), true);
    }

    public class_3913 getPropertyDelegate() {
        return this.propertyDelegate;
    }

    public Optional<class_1690> getHookedBoatEntity() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return Optional.empty();
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_1297 entity = serverWorld.method_14190(this.hookedBoatEntityUuid);
        if (!(entity instanceof class_1690)) {
            return Optional.empty();
        }
        class_1690 boatEntity = (class_1690)entity;
        return Optional.of(boatEntity);
    }

    public Optional<UUID> getHookedBoatEntityUuid() {
        return Optional.ofNullable(this.hookedBoatEntityUuid);
    }

    public void setHookedBoatEntity(UUID uuid) {
        this.hookedBoatEntityUuid = uuid;
    }

    public class_1277 getMountedInventory(@Nullable class_2350 direction) {
        return this.mountedInventory;
    }

    public class_1277 getMountedInventory() {
        return this.getMountedInventory(null);
    }

    @Nullable
    public ItemStorage getMountedInventoryStorage(@Nullable class_2350 direction) {
        return (ItemStorage)BoatismStorage.BoatismApis.ENTITY_ITEM_STORAGE.find((class_1297)this, (Object)direction);
    }

    public int getMountedInventorySize() {
        int i = 0;
        for (class_1799 entry : this.getMountedInventory().method_54454()) {
            if (!(entry.method_7909() instanceof BoatEngineComponent)) continue;
            ++i;
        }
        return i;
    }

    public void setMountedItemsFromItemStackList(LinkedHashSet<BoatismCodecs.MountedInventory.Slot> mountedItems) {
        if (mountedItems.size() > this.getMountedInventory().method_5439()) {
            LoggerUtil.devLogger("inventory size was bigger than expected", true, null);
            return;
        }
        for (BoatismCodecs.MountedInventory.Slot entry : mountedItems) {
            this.getMountedInventory().method_5447(entry.index(), entry.stack());
        }
        this.updateArmorModifier();
    }

    public void setMountedItemsFromComponentList(List<EngineComponent> components) {
        this.mountedInventory.method_5448();
        for (int slot = 0; slot < 32; ++slot) {
            class_1799 stack = class_1799.field_8037;
            for (EngineComponent component : components) {
                if (component.slot() != slot) continue;
                stack = component.componentStack();
                break;
            }
            this.getMountedInventory().method_5447(slot, stack);
        }
        this.updateArmorModifier();
    }

    public void addToMountedInventory(class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof BoatEngineComponent)) {
            return;
        }
        BoatEngineComponent component = (BoatEngineComponent)class_17922;
        this.getMountedInventory().method_5491(component.getMountedItemStack(itemStack));
        if (this.method_37908().method_8608()) {
            return;
        }
        this.updateArmorModifier();
    }

    public boolean mountedInventoryContains(class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof BoatEngineComponent)) {
            return false;
        }
        BoatEngineComponent component = (BoatEngineComponent)class_17922;
        return this.getMountedInventory().method_43256(mountedStack -> mountedStack.method_7909().equals(component.getMountedItemStack(itemStack).method_7909()));
    }

    public void updateArmorModifier() {
        if (this.method_37908().method_8608()) {
            return;
        }
        class_1324 instance = this.method_5996(class_5134.field_23724);
        if (instance == null) {
            return;
        }
        instance.method_6200(BoatismEntityAttributeModifierIdentifiers.ENGINE_COMPONENT_ARMOR.getId());
        class_1322 modifier = new class_1322(BoatismEntityAttributeModifierIdentifiers.ENGINE_COMPONENT_ARMOR.getId(), (double)this.engineHandler.getFullArmorValue(), class_1322.class_1323.field_6328);
        instance.method_26837(modifier);
    }

    public class_1799 method_6118(class_1304 slot) {
        return class_1799.field_8037;
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return BoatismSounds.BOAT_ENGINE_HIT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return BoatismSounds.BOAT_ENGINE_HIT;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        LoggerUtil.devLogger("Tried to equip an item on a BoatEngineEntity!", true, null);
    }

    public void method_6116(class_1304 slot, class_1799 oldStack, class_1799 newStack) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        serverWorld.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), BoatismSounds.BOAT_ENGINE_EQUIP, class_3419.field_15254, 0.75f, 1.0f);
    }

    public void hookOntoBoatEntity(class_1690 boatEntity) {
        if (boatEntity.method_5864().method_20210(BoatismTags.Entities.NOT_HOOKABLE)) {
            LoggerUtil.devLogger("Entity was excluded from being able to hook an engine");
            return;
        }
        ((BoatEngineCoupler)boatEntity).boatism$setBoatEngineEntity(this.method_5667());
        this.hookedBoatEntityUuid = boatEntity.method_5667();
        this.method_5873((class_1297)boatEntity, true);
    }

    public void broadcastToAllPlayerPassengers(class_2561 text, boolean overlay) {
        this.getHookedBoatEntity().ifPresent(boatEntity -> boatEntity.method_5685().forEach(entity -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.method_7353(text, overlay);
            }
        }));
    }

    public boolean method_18397(class_1799 stack) {
        return stack.method_7909() instanceof BoatEngineComponent;
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public boolean method_49108() {
        return super.method_49108();
    }

    public boolean method_30949(class_1297 other) {
        if (other instanceof class_1690) {
            return false;
        }
        return super.method_30949(other);
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_6102() {
        return false;
    }

    public boolean method_6101() {
        return false;
    }

    public Iterable<class_1799> method_5661() {
        return Collections.singleton(class_1799.field_8037);
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
    }

    @NotNull
    public BoatEngineHandler getEngineHandler() {
        return this.engineHandler;
    }

    public int getPowerLevel() {
        return (Integer)this.field_6011.method_12789(POWER_LEVEL);
    }

    public void setPowerLevel(int level) {
        this.field_6011.method_12778(POWER_LEVEL, (Object)level);
    }

    public float getOverheat() {
        return ((Float)this.field_6011.method_12789(OVERHEAT)).floatValue();
    }

    public void setOverheat(float overheat) {
        this.field_6011.method_12778(OVERHEAT, (Object)Float.valueOf(overheat));
    }

    public class_2379 getArmRotation() {
        return (class_2379)this.field_6011.method_12789(ARM_ROTATION);
    }

    public void setArmRotation(class_2379 armRotation) {
        this.field_6011.method_12778(ARM_ROTATION, (Object)armRotation);
    }

    public boolean isSubmerged() {
        return (Boolean)this.field_6011.method_12789(SUBMERGED);
    }

    public void setSubmerged(boolean isSubmerged) {
        this.field_6011.method_12778(SUBMERGED, (Object)isSubmerged);
    }

    public boolean isRunning() {
        return (Boolean)this.field_6011.method_12789(RUNNING);
    }

    public void setIsRunning(boolean shouldRun) {
        this.field_6011.method_12778(RUNNING, (Object)shouldRun);
    }

    public boolean isLocked() {
        return (Boolean)this.field_6011.method_12789(LOCKED);
    }

    public void setLocked(boolean resting) {
        this.field_6011.method_12778(LOCKED, (Object)resting);
    }

    public long getFuel() {
        return (Long)this.field_6011.method_12789(FUEL);
    }

    public void setFuel(long fuel) {
        this.field_6011.method_12778(FUEL, (Object)fuel);
    }

    public boolean hasLowHealth() {
        return this.method_6032() <= Boatism.CONFIG.lowHealth;
    }

    public void onOverheated() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        this.getHookedBoatEntity().ifPresent(boatEntity -> {
            for (class_1297 entry : boatEntity.method_5685()) {
                if (!(entry instanceof class_3222)) continue;
                class_3222 player = (class_3222)entry;
                player.method_7346();
                if (player.method_7337()) continue;
                player.method_6092(new class_1293(class_1294.field_5916, 240, 1, false, false, true));
                player.method_6092(new class_1293(class_1294.field_5920, 80, 1, false, false, true));
            }
        });
        boolean destructiveExplosion = serverWorld.method_8450().method_8355(BoatismGameRules.DESTRUCTIVE_ENGINE_EXPLOSION);
        for (class_1799 stack : this.getMountedInventory().method_54454()) {
            BoatEngineComponent component;
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof BoatEngineComponent) || !((component = (BoatEngineComponent)class_17922).getAdditionalArmor() > 0.0f)) continue;
            destructiveExplosion = false;
        }
        serverWorld.method_8454((class_1297)this, class_1927.method_55108((class_1937)serverWorld, (class_1297)this), (class_5362)new BoatEngineExplosionBehaviour(), this.method_23317(), this.method_23318(), this.method_23321(), 4.0f, destructiveExplosion, class_1937.class_7867.field_40888, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880)class_3417.field_15152);
        this.method_5768();
    }

    public void removeBoatEngine(class_1297 entity) {
        if (!(entity instanceof class_1690)) {
            return;
        }
        class_1690 boatEntity = (class_1690)entity;
        UUID boatEngineUuid = ((BoatEngineCoupler)boatEntity).boatism$getBoatEngineEntityUuid();
        if (boatEngineUuid != null) {
            ((BoatEngineCoupler)boatEntity).boatism$setBoatEngineEntity(null);
        }
        this.method_31472();
    }

    public void method_36209() {
        this.getHookedBoatEntity().ifPresent(boatEntity -> ((BoatEngineCoupler)boatEntity).boatism$setBoatEngineEntity(null));
        super.method_36209();
    }

    public void method_6078(class_1282 damageSource) {
        this.getHookedBoatEntity().ifPresent(boatEntity -> ((BoatEngineCoupler)boatEntity).boatism$setBoatEngineEntity(null));
        super.method_6078(damageSource);
    }
}

