/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.item.custom;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.shirojr.boatism.entity.custom.BoatEngineEntity;
import net.shirojr.boatism.init.BoatismFluids;
import net.shirojr.boatism.init.BoatismSounds;
import org.jetbrains.annotations.Nullable;

public class FuelBucketItem
extends class_1755 {
    public static final long MAX_CAPACITY = 81000L;

    public FuelBucketItem(class_3611 fluid, class_1792.class_1793 settings) {
        super(fluid, settings);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (!(entity instanceof BoatEngineEntity)) {
            return super.method_7847(stack, user, entity, hand);
        }
        BoatEngineEntity boatEngine = (BoatEngineEntity)entity;
        if (boatEngine.isRunning()) {
            user.method_7353((class_2561)class_2561.method_43471((String)"warning.boatism.engine_is_running"), true);
            return class_1269.field_5811;
        }
        try (Transaction transaction = Transaction.openOuter();){
            Storage<FluidVariant> fluidStorage = FuelBucketItem.getFluidStorage(user, hand);
            if (fluidStorage == null) {
                transaction.abort();
                class_1269 class_12692 = class_1269.field_5811;
                return class_12692;
            }
            long extractedAmount = fluidStorage.extract((Object)BoatismFluids.OIL.getFluidVariant(), 81000L, (TransactionContext)transaction);
            boatEngine.getEngineHandler().fillUpFuel(extractedAmount);
        }
        user.method_37908().method_8396(null, boatEngine.method_24515(), BoatismSounds.BOAT_ENGINE_FILL_UP, class_3419.field_15254, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    @Nullable
    public static Storage<FluidVariant> getFluidStorage(class_1657 player, class_1268 hand) {
        ContainerItemContext context = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
        class_1799 stack = player.method_5998(hand);
        return (Storage)FluidStorage.ITEM.find(stack, (Object)context);
    }
}

