/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3419;
import net.minecraft.class_4048;
import net.minecraft.class_8836;
import net.shirojr.boatism.api.BoatEngineCoupler;
import net.shirojr.boatism.api.CustomBoatEngineAttachment;
import net.shirojr.boatism.entity.custom.BoatEngineEntity;
import net.shirojr.boatism.init.BoatismSounds;
import net.shirojr.boatism.item.custom.BaseEngineItem;
import net.shirojr.boatism.mixin.BoatEntityInvoker;
import net.shirojr.boatism.network.packet.BoatEntitySyncPacket;
import net.shirojr.boatism.util.handler.EntityHandler;
import net.shirojr.boatism.util.nbt.BoatEngineNbtHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1690.class})
public abstract class BoatEntityMixin
extends class_8836
implements BoatEngineCoupler,
CustomBoatEngineAttachment {
    @Unique
    @Nullable
    private UUID boatEngineUuid;

    public BoatEntityMixin(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public void boatism$setBoatEngineEntity(@Nullable UUID boatEngineUuid) {
        this.boatEngineUuid = boatEngineUuid;
        if (this.method_37908().method_8608()) {
            return;
        }
        new BoatEntitySyncPacket(this.method_5628(), Optional.ofNullable(this.boatEngineUuid)).sendPacket(PlayerLookup.tracking((class_1297)this));
    }

    @Override
    @Nullable
    public UUID boatism$getBoatEngineEntityUuid() {
        return this.boatEngineUuid;
    }

    @Inject(method={"updatePaddles"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/vehicle/BoatEntity;getVelocity()Lnet/minecraft/util/math/Vec3d;")})
    private void boatism$controlBoatSpeed(CallbackInfo ci, @Local(ordinal=0) LocalFloatRef f) {
        class_1690 boatEntity = (class_1690)this;
        UUID linkedBoatEngineUuid = ((BoatEngineCoupler)boatEntity).boatism$getBoatEngineEntityUuid();
        Optional<BoatEngineEntity> linkedBoatEngine = EntityHandler.getBoatEngineEntityFromUuid(linkedBoatEngineUuid, boatEntity.method_37908(), boatEntity.method_19538(), 10);
        linkedBoatEngine.ifPresent(boatEngine -> {
            float baseSpeed = f.get();
            float powerLevel = (float)boatEngine.getPowerLevel() * 0.008f;
            float thrust = baseSpeed + powerLevel * boatEngine.getEngineHandler().calculateThrustModifier(boatEntity);
            f.set(thrust);
        });
    }

    @Inject(method={"interact"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;startRiding(Lnet/minecraft/entity/Entity;)Z", shift=At.Shift.BEFORE)}, cancellable=true)
    private void boatism$equipEngineEntity(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1799 stack = player.method_6047();
        class_1690 boatEntity = (class_1690)this;
        EntityHandler.engineLinkCleanUp(boatEntity);
        if (((BoatEngineCoupler)boatEntity).boatism$getBoatEngineEntityUuid() != null) {
            return;
        }
        if (stack.method_7909() instanceof BaseEngineItem) {
            if (!this.method_37908().method_8608()) {
                BoatEngineEntity engineEntity = BoatEngineNbtHelper.getBoatEngineEntityFromItemStack(stack, boatEntity);
                this.method_37908().method_8649((class_1297)engineEntity);
                this.boatism$setBoatEngineEntity(engineEntity.method_5667());
                this.method_37908().method_43128(null, boatEntity.method_23317(), boatEntity.method_23318(), boatEntity.method_23321(), BoatismSounds.BOAT_ENGINE_EQUIP, class_3419.field_15254, 0.9f, 1.0f);
                stack.method_7934(1);
            }
            cir.setReturnValue((Object)class_1269.field_5812);
        }
    }

    @Inject(method={"canCollide"}, at={@At(value="HEAD")}, cancellable=true)
    private static void boatism$boatEngineCollision(class_1297 entity, class_1297 other, CallbackInfoReturnable<Boolean> cir) {
        if (other instanceof BoatEngineEntity) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void boatism$readBoatEngineEntry(class_2487 nbt, CallbackInfo ci) {
        class_1690 boatEntity = (class_1690)this;
        if (!nbt.method_10545("BoatEngineUuid")) {
            return;
        }
        ((BoatEngineCoupler)boatEntity).boatism$setBoatEngineEntity(nbt.method_25926("BoatEngineUuid"));
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void boatism$writeBoatEngineEntry(class_2487 nbt, CallbackInfo ci) {
        class_1690 boatEntity = (class_1690)this;
        UUID linkedBoatEngineUuid = ((BoatEngineCoupler)boatEntity).boatism$getBoatEngineEntityUuid();
        if (linkedBoatEngineUuid != null) {
            nbt.method_25927("BoatEngineUuid", linkedBoatEngineUuid);
        }
    }

    @Inject(method={"getPassengerAttachmentPos"}, at={@At(value="HEAD")}, cancellable=true)
    protected void boatism$getPassengerAttachmentPos(class_1297 passenger, class_4048 dimensions, float scaleFactor, CallbackInfoReturnable<class_243> cir) {
        BoatEntityMixin boatEntityMixin;
        if (passenger instanceof BoatEngineEntity && (boatEntityMixin = this) instanceof CustomBoatEngineAttachment) {
            BoatEntityMixin attachment = boatEntityMixin;
            cir.setReturnValue((Object)attachment.boatism$attachmentPos((class_1297)this, dimensions).method_1024(-this.method_36454() * ((float)Math.PI / 180)));
        }
    }

    @Inject(method={"canAddPassenger"}, at={@At(value="HEAD")}, cancellable=true)
    protected void boatism$canAddPassenger(class_1297 passenger, CallbackInfoReturnable<Boolean> info) {
        class_1690 boatEntity = (class_1690)this;
        if (((BoatEngineCoupler)boatEntity).boatism$getBoatEngineEntityUuid() == null) {
            return;
        }
        int maxPassengers = ((BoatEntityInvoker)boatEntity).invokeGetMaxPassenger() + 1;
        if (boatEntity.method_5685().size() < maxPassengers) {
            info.setReturnValue((Object)true);
        }
    }

    @Override
    public class_243 boatism$attachmentPos(class_1297 vehicleEntity, class_4048 dimensions) {
        if (this.method_47885() == class_1690.class_1692.field_40161) {
            return new class_243(0.0, (double)dimensions.comp_2186() * 0.7, -1.2);
        }
        return new class_243(0.0, (double)dimensions.comp_2186() / 3.0, -1.32);
    }

    @Shadow
    public abstract class_1690.class_1692 method_47885();
}

