/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.shirojr.boatism.util.tag.BoatismTags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Shadow
    protected abstract void method_6010(class_6862<class_3611> var1);

    @WrapOperation(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isInLava()Z")})
    private boolean boatism$isInOilTravel(class_1309 instance, Operation<Boolean> original) {
        if (LivingEntityMixin.isInOilFluid(instance)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getFluidHeight(Lnet/minecraft/registry/tag/TagKey;)D")})
    private double boatism$getFluidHeight(class_1309 instance, class_6862<class_3611> tagKey, Operation<Double> original) {
        double lavaHeight = (Double)original.call(new Object[]{instance, tagKey});
        double oilHeight = instance.method_5861(BoatismTags.Fluids.OIL);
        return Math.max(oilHeight, lavaHeight);
    }

    @WrapOperation(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isInLava()Z")})
    private boolean boatism$isInOilMovement(class_1309 instance, Operation<Boolean> original) {
        if (LivingEntityMixin.isInOilFluid(instance)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getFluidHeight(Lnet/minecraft/registry/tag/TagKey;)D", ordinal=1)})
    private double boatism$getFluidHeightForOil(class_1309 instance, class_6862<class_3611> tagKey, Operation<Double> original) {
        double waterHeight = (Double)original.call(new Object[]{instance, tagKey});
        double oilHeight = instance.method_5861(BoatismTags.Fluids.OIL);
        return Math.max(waterHeight, oilHeight);
    }

    @Inject(method={"swimUpward"}, at={@At(value="HEAD")}, cancellable=true)
    private void boatism$swimUpwardInOil(class_6862<class_3611> fluid, CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        if (!livingEntity.method_37908().method_8316(livingEntity.method_24515()).method_15767(BoatismTags.Fluids.OIL)) {
            return;
        }
        livingEntity.method_18799(livingEntity.method_18798().method_1031(0.0, (double)0.033f, 0.0));
        ci.cancel();
    }

    @Inject(method={"applyFluidMovingSpeed"}, at={@At(value="NEW", target="(DDD)Lnet/minecraft/util/math/Vec3d;", shift=At.Shift.BEFORE)}, cancellable=true)
    private void boatism$oilMovingSpeed(double gravity, boolean falling, class_243 motion, CallbackInfoReturnable<class_243> cir) {
        class_1309 livingEntity = (class_1309)this;
        if (!LivingEntityMixin.isInOilFluid(livingEntity)) {
            return;
        }
        if (!falling) {
            return;
        }
        double maxFallingSpeed = 0.001;
        boolean fallingSpeed = Math.abs(motion.field_1351 - 0.005) >= maxFallingSpeed;
        boolean gravitySpeed = Math.abs(motion.field_1351 - gravity / 16.0) < maxFallingSpeed;
        double sinkingSpeed = fallingSpeed && gravitySpeed ? -maxFallingSpeed : motion.field_1351 - gravity / 16.0;
        cir.setReturnValue((Object)new class_243(motion.field_1352, sinkingSpeed, motion.field_1350));
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isSubmergedIn(Lnet/minecraft/registry/tag/TagKey;)Z")})
    private boolean boatism$oilBreathing(class_1309 instance, class_6862<class_3611> tagKey, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{instance, tagKey}) != false || instance.method_5777(BoatismTags.Fluids.OIL);
    }

    @WrapOperation(method={"tickMovement"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;swimUpward(Lnet/minecraft/registry/tag/TagKey;)V", ordinal=1))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isOnGround()Z")})
    private boolean boatism$preventJumpingInOil(class_1309 instance, Operation<Boolean> original) {
        boolean isStandingInOil;
        boolean originalEvaluation = (Boolean)original.call(new Object[]{instance});
        boolean bl = isStandingInOil = originalEvaluation && LivingEntityMixin.isInOilFluid(instance);
        if (isStandingInOil) {
            this.method_6010(BoatismTags.Fluids.OIL);
            return false;
        }
        return originalEvaluation;
    }

    @Unique
    private static boolean isInOilFluid(class_1309 livingEntity) {
        return livingEntity.method_37908().method_8316(livingEntity.method_24515()).method_15767(BoatismTags.Fluids.OIL);
    }
}

