/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.screen.geometry;

import net.minecraft.class_3532;

public class ShapeUtil {

    public static class Square {
        private Position squareStart;
        private Position squareEnd;

        public Square(Position posStart, Position posEnd) {
            this.squareStart = posStart;
            this.squareEnd = posEnd;
        }

        public Square(Position squareStart, int width, int height) {
            this.squareStart = squareStart;
            this.squareEnd = new Position(squareStart.x + width, squareStart.y + height);
        }

        public boolean isPositionInSquare(Position position) {
            return position.x >= this.getSquareStart().x && position.y >= this.getSquareStart().y && position.x <= this.getSquareEnd().x && position.y <= this.getSquareEnd().y;
        }

        public Position getSquareStart() {
            return this.squareStart;
        }

        public void setSquareStart(Position squareStart) {
            this.squareStart = squareStart;
        }

        public Position getSquareEnd() {
            return this.squareEnd;
        }

        public void setSquareEnd(Position squareEnd) {
            this.squareEnd = squareEnd;
        }

        public int getWidth() {
            return class_3532.method_15382((int)(this.getSquareEnd().x - this.getSquareStart().x));
        }

        public int getHeight() {
            return class_3532.method_15382((int)(this.getSquareEnd().y - this.getSquareStart().y));
        }

        public void moveSquare(Position newStartPosition) {
            Position movingDistance = this.getSquareStart().getShiftedValue(newStartPosition);
            this.setSquareStart(newStartPosition);
            this.setSquareEnd(this.getSquareEnd().add(movingDistance));
        }
    }

    public record Position(int x, int y) {
        public Position add(Position input) {
            return new Position(this.x + input.x, this.y + input.y);
        }

        public Position getShiftedValue(Position input) {
            return new Position(input.x - this.x, input.y() - this.y);
        }
    }
}

