/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.screen.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.shirojr.boatism.Boatism;

@Environment(value=EnvType.CLIENT)
public enum EngineGuiElement {
    TOP(176, 1, 29, 15, 3, 2),
    MID(176, 17, 10, 8, 0, 13),
    BOTTOM(176, 26, 6, 18, 1, 17),
    TURBINE(176, 45, 14, 9, 0, 25);

    private final int u;
    private final int v;
    private final int width;
    private final int height;
    private final int xOffset;
    private final int yOffset;
    public static final class_2960 GUI_TEXTURE;

    private EngineGuiElement(int u, int v, int width, int height, int xOffset, int yOffset) {
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public int getU(boolean useHeatedTexture) {
        if (!useHeatedTexture) {
            return this.u;
        }
        return this.u + 30;
    }

    public int getV() {
        return this.v;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public static List<EngineGuiElement> getAllPartsInOrder() {
        ArrayList<EngineGuiElement> parts = new ArrayList<EngineGuiElement>(List.of(EngineGuiElement.values()));
        Collections.reverse(parts);
        return parts;
    }

    public static void renderEngineParts(class_332 context, List<EngineGuiElement> parts, int x, int y, float alpha, boolean useHeatedTexture) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        context.method_51422(1.0f, 1.0f, 1.0f, alpha);
        for (EngineGuiElement part : parts) {
            context.method_25302(GUI_TEXTURE, x + part.getXOffset(), y + part.getYOffset(), part.getU(useHeatedTexture), part.getV(), part.getWidth(), part.getHeight());
        }
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    static {
        GUI_TEXTURE = Boatism.getId("textures/gui/engine_control.png");
    }
}

