/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.sound;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.shirojr.boatism.BoatismClient;
import net.shirojr.boatism.entity.custom.BoatEngineEntity;
import net.shirojr.boatism.sound.instance.SoundInstanceState;
import net.shirojr.boatism.sound.instance.custom.BoatismSoundInstance;
import net.shirojr.boatism.util.LoggerUtil;
import net.shirojr.boatism.util.sound.SoundInstanceIdentifier;

@Environment(value=EnvType.CLIENT)
public class BoatismSoundManager {
    private final class_310 client = class_310.method_1551();
    private final List<SoundInstanceEntry> activeSoundInstances = new ArrayList<SoundInstanceEntry>();

    public List<SoundInstanceEntry> getActiveSoundInstances() {
        return this.activeSoundInstances;
    }

    public void start(SoundInstanceIdentifier soundInstanceIdentifier, BoatismSoundInstance soundInstance) {
        if (!(soundInstance instanceof SoundInstanceState)) {
            return;
        }
        SoundInstanceState newInstanceState = (SoundInstanceState)((Object)soundInstance);
        ArrayList<SoundInstanceEntry> unsupportedSoundInstances = new ArrayList<SoundInstanceEntry>();
        for (SoundInstanceEntry activeInstance : this.activeSoundInstances) {
            LoggerUtil.devLogger(activeInstance.instance.toString());
            Object object = activeInstance.instance;
            if (!(object instanceof SoundInstanceState)) continue;
            SoundInstanceState activeInstanceState = (SoundInstanceState)object;
            if (soundInstance.getBoatEngineEntity().equals((Object)activeInstance.instance.getBoatEngineEntity())) {
                if (newInstanceState.isMainSound() && activeInstanceState.isMainSound()) {
                    unsupportedSoundInstances.add(activeInstance);
                }
                if (soundInstance.equals((Object)activeInstance.instance)) {
                    unsupportedSoundInstances.add(activeInstance);
                }
                for (SoundInstanceIdentifier unsupportedInstance : newInstanceState.unsupportedInstances()) {
                    if (!activeInstance.identifier.equals((Object)unsupportedInstance)) continue;
                    unsupportedSoundInstances.add(activeInstance);
                }
            }
            if (!activeInstance.instance.isFinished()) continue;
            unsupportedSoundInstances.add(activeInstance);
        }
        unsupportedSoundInstances.forEach(this::stop);
        this.activeSoundInstances.add(new SoundInstanceEntry(soundInstanceIdentifier, soundInstance));
        this.client.method_1483().method_4873((class_1113)soundInstance);
        List<SoundInstanceEntry> soundInstances = BoatismClient.soundManager.getActiveSoundInstances();
        for (SoundInstanceEntry entry : soundInstances) {
            if (!entry.identifier.equals((Object)SoundInstanceIdentifier.ENGINE_OVERHEATING)) continue;
            LoggerUtil.devLogger(String.valueOf((Object)entry.instance().getBoatEngineEntity()) + " | " + entry.identifier().toString());
        }
    }

    public void stop(SoundInstanceEntry soundInstanceEntry) {
        for (SoundInstanceEntry entry : this.activeSoundInstances) {
            if (soundInstanceEntry.identifier != entry.identifier) continue;
            soundInstanceEntry.instance.finishSoundInstance();
        }
        this.removeEntriesFromList(List.of(soundInstanceEntry));
    }

    public void stopAllSoundInstancesForBoatEngineEntity(BoatEngineEntity boatEngine, boolean force) {
        for (SoundInstanceEntry entry : this.activeSoundInstances) {
            BoatismSoundInstance boatismSoundInstance;
            if (!entry.instance.getBoatEngineEntity().equals((Object)boatEngine) || !((boatismSoundInstance = entry.instance) instanceof SoundInstanceState)) continue;
            SoundInstanceState activeInstanceState = (SoundInstanceState)((Object)boatismSoundInstance);
            if (!force && activeInstanceState.canRunIfEngineIsTurnedOff(boatEngine)) continue;
            this.client.method_1483().method_4870((class_1113)entry.instance);
        }
        this.activeSoundInstances.clear();
    }

    public void stopAllSoundInstances(boolean sendInformationText) {
        for (SoundInstanceEntry entry : this.activeSoundInstances) {
            this.client.method_1483().method_4870((class_1113)entry.instance);
            if (this.client.field_1724 == null || !sendInformationText) continue;
            this.client.field_1724.method_43496((class_2561)class_2561.method_43470((String)"removed %s for: %s".formatted(new Object[]{entry.identifier, entry.instance.getBoatEngineEntity().toString()})));
        }
        this.activeSoundInstances.clear();
    }

    private void removeEntriesFromList(List<SoundInstanceEntry> unsupportedSoundInstances) {
        for (SoundInstanceEntry entry : unsupportedSoundInstances) {
            this.activeSoundInstances.remove(entry);
        }
    }

    public record SoundInstanceEntry(SoundInstanceIdentifier identifier, BoatismSoundInstance instance) {
    }
}

