/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.sound;

import net.minecraft.class_2960;
import net.shirojr.boatism.BoatismClient;
import net.shirojr.boatism.entity.custom.BoatEngineEntity;
import net.shirojr.boatism.sound.instance.custom.BoatismSoundInstance;
import net.shirojr.boatism.sound.instance.custom.EngineLowFuelSoundInstance;
import net.shirojr.boatism.sound.instance.custom.EngineLowHealthSoundInstance;
import net.shirojr.boatism.sound.instance.custom.EngineOverheatingSoundInstance;
import net.shirojr.boatism.sound.instance.custom.EngineRunningSoundInstance;
import net.shirojr.boatism.sound.instance.custom.EngineSubmergedSoundInstance;
import net.shirojr.boatism.util.LoggerUtil;
import net.shirojr.boatism.util.sound.SoundInstanceIdentifier;

public class BoatismSoundPacketHandler {
    public static void handleSoundPacket(class_2960 identifier, BoatEngineEntity boatEngineEntity) {
        SoundInstanceIdentifier.fromIdentifier(identifier).ifPresent(soundInstanceIdentifier -> {
            BoatismSoundInstance soundInstance;
            switch (soundInstanceIdentifier) {
                case ENGINE_RUNNING: {
                    soundInstance = new EngineRunningSoundInstance(boatEngineEntity);
                    break;
                }
                case ENGINE_RUNNING_UNDERWATER: {
                    soundInstance = new EngineSubmergedSoundInstance(boatEngineEntity);
                    break;
                }
                case ENGINE_LOW_FUEL: {
                    soundInstance = new EngineLowFuelSoundInstance(boatEngineEntity);
                    break;
                }
                case ENGINE_LOW_HEALTH: {
                    soundInstance = new EngineLowHealthSoundInstance(boatEngineEntity);
                    break;
                }
                case ENGINE_OVERHEATING: {
                    soundInstance = new EngineOverheatingSoundInstance(boatEngineEntity);
                    break;
                }
                case NO_SOUND: {
                    BoatismClient.soundManager.stopAllSoundInstancesForBoatEngineEntity(boatEngineEntity, true);
                    return;
                }
                default: {
                    LoggerUtil.LOGGER.error(String.format("Failed to play %s SoundInstance", soundInstanceIdentifier.getIdentifier().method_12832()));
                    return;
                }
            }
            BoatismClient.soundManager.start((SoundInstanceIdentifier)((Object)soundInstanceIdentifier), soundInstance);
        });
    }
}

