/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.sound.instance.custom;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.shirojr.boatism.entity.custom.BoatEngineEntity;
import net.shirojr.boatism.init.BoatismSounds;
import net.shirojr.boatism.sound.instance.SoundInstanceState;
import net.shirojr.boatism.sound.instance.custom.BoatismSoundInstance;
import net.shirojr.boatism.util.handler.BoatEngineHandler;

@Environment(value=EnvType.CLIENT)
public class EngineOverheatingSoundInstance
extends BoatismSoundInstance
implements SoundInstanceState {
    private static final int COOL_BUFFER_MAX = 3;
    private int coolingBuffer = 0;

    public EngineOverheatingSoundInstance(BoatEngineEntity boatEngineEntity) {
        super(boatEngineEntity, BoatismSounds.BOAT_ENGINE_HEAT, 60, 60);
        this.transitionState = BoatismSoundInstance.TransitionState.STARTING;
    }

    @Override
    public boolean method_26273() {
        return super.method_26273();
    }

    @Override
    public boolean isMainSound() {
        return false;
    }

    @Override
    public boolean canRunIfEngineIsTurnedOff(BoatEngineEntity boatEngine) {
        return true;
    }

    @Override
    public void method_16896() {
        boolean isPotentiallyCooling;
        super.method_16896();
        float normalizedOverheatTicks = this.engineHandler.getOverheat() / (float)BoatEngineHandler.MAX_BASE_OVERHEAT;
        boolean bl = isPotentiallyCooling = !this.engineHandler.isHeatingUp();
        if (isPotentiallyCooling) {
            if (this.coolingBuffer > 3) {
                if (!this.transitionState.equals((Object)BoatismSoundInstance.TransitionState.FINISHING)) {
                    this.finishSoundInstance();
                    return;
                }
            } else {
                --this.coolingBuffer;
            }
        } else {
            this.coolingBuffer = 0;
        }
        BoatismSoundInstance.defaultSoundHandling(this);
        this.field_5442 = class_3532.method_16439((float)normalizedOverheatTicks, (float)0.0f, (float)0.7f);
    }
}

