/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.util.handler;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.shirojr.boatism.Boatism;
import net.shirojr.boatism.api.BoatEngineComponent;
import net.shirojr.boatism.entity.custom.BoatEngineEntity;
import net.shirojr.boatism.init.BoatismSounds;
import net.shirojr.boatism.mixin.BoatEntityInvoker;
import net.shirojr.boatism.network.packet.StartSoundInstancePacket;
import net.shirojr.boatism.util.sound.SoundInstanceIdentifier;

public class BoatEngineHandler {
    public static final int MAX_POWER_LEVEL = 9;
    public static final int LIMITED_MAX_POWER_LEVEL = 3;
    public static final long MAX_BASE_FUEL = Boatism.CONFIG.baseFuelCapacityInBuckets * 81000L;
    public static final int MAX_BASE_OVERHEAT = Boatism.CONFIG.maxBaseOverheat;
    private final BoatEngineEntity boatEngine;
    private boolean canPlayOverheat = true;
    private boolean canPlayLowFuel = true;
    private boolean canPlayLowHealth = true;

    private BoatEngineHandler(BoatEngineEntity boatEngine) {
        this.boatEngine = boatEngine;
    }

    public static BoatEngineHandler create(BoatEngineEntity boatEngine) {
        return new BoatEngineHandler(boatEngine);
    }

    public void incrementTick() {
        if (this.breaksWhenSubmerged() && this.isSubmerged()) {
            this.stopEngine();
        }
        if (this.handleHealth()) {
            return;
        }
        if (this.handleOverheating()) {
            return;
        }
        if (this.handleFuel()) {
            return;
        }
    }

    private boolean handleHealth() {
        if (this.isLowHealth()) {
            this.regulateDownIfLimited();
            if (this.canPlayLowHealth) {
                this.boatEngine.broadcastToAllPlayerPassengers((class_2561)class_2561.method_43471((String)"warning.boatism.low_health"), true);
                if (this.engineIsRunning()) {
                    this.changeSoundState(List.of(SoundInstanceIdentifier.ENGINE_LOW_HEALTH));
                }
                this.canPlayLowHealth = false;
            }
        } else if (!this.canPlayLowHealth) {
            this.canPlayLowHealth = true;
        }
        return false;
    }

    private boolean handleFuel() {
        if (this.isLowOnFuel()) {
            this.regulateDownIfLimited();
            if (this.canPlayLowFuel) {
                this.boatEngine.broadcastToAllPlayerPassengers((class_2561)class_2561.method_43471((String)"warning.boatism.low_on_fuel"), true);
                if (this.engineIsRunning()) {
                    this.changeSoundState(List.of(SoundInstanceIdentifier.ENGINE_LOW_FUEL));
                }
                this.canPlayLowFuel = false;
            }
        } else if (!this.canPlayLowFuel) {
            this.canPlayLowFuel = true;
        }
        if (!this.boatEngine.method_37908().method_8608()) {
            if (this.getFuel() <= 0L) {
                this.stopEngine();
                return true;
            }
            if (this.engineIsRunning()) {
                this.consumeFuel(1000L);
            }
        }
        return false;
    }

    private void regulateDownIfLimited() {
        if (this.getPowerLevel() > this.getMaxPowerLevel() && this.engineIsRunning()) {
            this.setPowerLevel(this.getMaxPowerLevel());
        }
    }

    private boolean handleOverheating() {
        if (!this.boatEngine.method_37908().method_8608()) {
            float currentOverHeat = 0.0f;
            if (this.isExperiencingHeavyLoad()) {
                currentOverHeat += 2.0f;
            } else if (this.getOverheat() > 0.0f) {
                currentOverHeat -= 1.0f;
            }
            this.setOverheat(this.getOverheat() + currentOverHeat);
        }
        if (this.isHeatingUp()) {
            if (this.canPlayOverheat) {
                this.boatEngine.broadcastToAllPlayerPassengers((class_2561)class_2561.method_43471((String)"warning.boatism.starting_to_overheat"), true);
                this.changeSoundState(List.of(SoundInstanceIdentifier.ENGINE_OVERHEATING));
                this.canPlayOverheat = false;
            }
        } else if (!this.canPlayOverheat) {
            this.canPlayOverheat = true;
        }
        if (this.isOverheated()) {
            this.stopEngine();
            this.boatEngine.onOverheated();
            return true;
        }
        return false;
    }

    public void startEngine() {
        if (!this.engineCanStart()) {
            this.playSoundEvent(BoatismSounds.BOAT_ENGINE_START_FAIL);
            return;
        }
        this.playSoundEvent(BoatismSounds.BOAT_ENGINE_START);
        this.boatEngine.setIsRunning(true);
        this.initiateSoundState();
    }

    public void stopEngine() {
        if (!this.engineIsRunning()) {
            return;
        }
        this.playSoundEvent(BoatismSounds.BOAT_ENGINE_STOP, 0.7f, 1.0f);
        this.setPowerLevel(0);
        this.boatEngine.setIsRunning(false);
    }

    public boolean engineIsRunning() {
        return this.boatEngine.isRunning();
    }

    public boolean engineCanStart() {
        if ((float)this.getFuel() < 5.0f) {
            return false;
        }
        if (this.isSubmerged() && this.breaksWhenSubmerged()) {
            return false;
        }
        if (this.isOverheated()) {
            return false;
        }
        if (this.boatEngine.isLocked()) {
            return false;
        }
        return !this.boatEngine.isRunning();
    }

    public long getFuel() {
        return this.boatEngine.getFuel();
    }

    public void setFuel(long fuel) {
        this.boatEngine.setFuel(Math.min(this.getMaxFuelCapacity(), fuel));
    }

    public long getMaxFuelCapacity() {
        long maxCapacity = MAX_BASE_FUEL;
        for (class_1799 stack : this.getMountedItems()) {
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof BoatEngineComponent)) continue;
            BoatEngineComponent component = (BoatEngineComponent)class_17922;
            maxCapacity += component.addedFuelCapacity();
        }
        return maxCapacity;
    }

    public long fillUpFuel(long fuel) {
        fuel = Math.max(0L, fuel);
        long fuelMissing = Math.max(0L, this.getMaxFuelCapacity() - this.getFuel());
        long newFuelLevel = Math.clamp(fuel + this.getFuel(), 0L, this.getMaxFuelCapacity());
        if (fuelMissing > 0L && fuel > 0L) {
            this.playSoundEvent(BoatismSounds.BOAT_ENGINE_FILL_UP);
        }
        this.setFuel(newFuelLevel);
        return fuel - fuelMissing;
    }

    public void consumeFuel(long baseFuelConsumption) {
        long consumedFuel = baseFuelConsumption + this.additionalConsumedFuel();
        this.setFuel(Math.max(this.getFuel() - consumedFuel, 0L));
    }

    private long additionalConsumedFuel() {
        long fuelPerTick = 0L;
        for (class_1799 entry : this.getMountedItems()) {
            class_1792 class_17922 = entry.method_7909();
            if (!(class_17922 instanceof BoatEngineComponent)) continue;
            BoatEngineComponent component = (BoatEngineComponent)class_17922;
            fuelPerTick += component.addedConsumedFuel();
        }
        return fuelPerTick;
    }

    public boolean isLowOnFuel() {
        return (double)this.getFuel() < (double)this.getMaxFuelCapacity() * 0.2;
    }

    public int getPowerLevel() {
        return this.boatEngine.getPowerLevel();
    }

    public void setPowerLevel(int powerLevel) {
        powerLevel = Math.max(powerLevel, 0);
        powerLevel = Math.min(powerLevel, 9);
        this.boatEngine.setPowerLevel(powerLevel);
    }

    public int getMaxPowerLevel() {
        if (this.isLowOnFuel() || this.isLowHealth()) {
            return 3;
        }
        return 9;
    }

    public boolean isHeatingUp() {
        return this.getOverheat() > 10.0f;
    }

    public float getOverheat() {
        return this.boatEngine.getOverheat();
    }

    public void setOverheat(float overheat) {
        this.boatEngine.setOverheat(overheat);
    }

    public boolean isOverheated() {
        return this.getOverheat() > this.getMaxOverHeatCapacity();
    }

    public float getMaxOverHeatCapacity() {
        float maxCapacity = MAX_BASE_OVERHEAT;
        for (class_1799 stack : this.getMountedItems()) {
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof BoatEngineComponent)) continue;
            BoatEngineComponent component = (BoatEngineComponent)class_17922;
            maxCapacity += component.addedOverheatTolerance();
        }
        return maxCapacity;
    }

    public boolean isExperiencingHeavyLoad() {
        if (!this.engineIsRunning()) {
            return false;
        }
        if (this.getPowerLevel() > 3 && (double)this.getPowerLevel() * 0.1 < this.boatEngine.method_18798().method_37267()) {
            return true;
        }
        return this.getPowerLevel() >= 7;
    }

    public boolean isSubmerged() {
        return this.boatEngine.isSubmerged();
    }

    public void setSubmerged(boolean isSubmerged) {
        if (isSubmerged == this.isSubmerged()) {
            return;
        }
        this.boatEngine.setSubmerged(isSubmerged);
        this.changeSoundState(List.of(SoundInstanceIdentifier.ENGINE_RUNNING_UNDERWATER));
    }

    public boolean breaksWhenSubmerged() {
        for (class_1799 entry : this.getMountedItems()) {
            BoatEngineComponent component;
            class_1792 class_17922 = entry.method_7909();
            if (!(class_17922 instanceof BoatEngineComponent) || !(component = (BoatEngineComponent)class_17922).waterProofsEngine()) continue;
            return false;
        }
        return true;
    }

    public boolean isLowHealth() {
        return (double)this.boatEngine.method_6032() < (double)this.boatEngine.method_6063() * 0.2;
    }

    public float getFullArmorValue() {
        float armor = 0.0f;
        for (class_1799 entry : this.boatEngine.getMountedInventory().method_54454()) {
            class_1792 class_17922 = entry.method_7909();
            if (!(class_17922 instanceof BoatEngineComponent)) continue;
            BoatEngineComponent component = (BoatEngineComponent)class_17922;
            armor += component.getAdditionalArmor();
        }
        return armor;
    }

    public float calculateThrustModifier(class_1690 hookedBoatEntity) {
        if (hookedBoatEntity == null) {
            return 0.0f;
        }
        ArrayList boatComponentStacks = new ArrayList();
        int passengerCount = Math.max(hookedBoatEntity.method_5685().size() - 1, 0);
        int maxPassenger = ((BoatEntityInvoker)hookedBoatEntity).invokeGetMaxPassenger();
        float thrust = 1.0f;
        this.getMountedItems().forEach(stack -> {
            BoatEngineComponent component;
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof BoatEngineComponent && (component = (BoatEngineComponent)patt0$temp).addedThrust() > 0.0f) {
                boatComponentStacks.add(stack);
            }
        });
        for (class_1799 thrustModifierStack : boatComponentStacks) {
            class_1792 class_17922 = thrustModifierStack.method_7909();
            if (!(class_17922 instanceof BoatEngineComponent)) continue;
            BoatEngineComponent engineComponent = (BoatEngineComponent)class_17922;
            thrust += engineComponent.addedThrust();
        }
        float passengerDeficit = (float)passengerCount / (float)maxPassenger;
        return thrust * class_3532.method_16439((float)passengerDeficit, (float)1.0f, (float)0.7f);
    }

    public boolean canEquipPart(class_1799 stack) {
        if (!(stack.method_7909() instanceof BoatEngineComponent)) {
            return false;
        }
        ArrayList<class_1792> flaggedParts = new ArrayList<class_1792>();
        for (class_1799 entry : this.getMountedItems()) {
            class_1792 class_17922 = entry.method_7909();
            if (!(class_17922 instanceof BoatEngineComponent)) continue;
            BoatEngineComponent component = (BoatEngineComponent)class_17922;
            flaggedParts.addAll(component.getConflictingParts());
        }
        return !flaggedParts.contains(stack.method_7909());
    }

    public List<class_1799> getMountedItems() {
        return this.boatEngine.getMountedInventory().method_54454();
    }

    public void initiateSoundState() {
        ArrayList<SoundInstanceIdentifier> identifierList = new ArrayList<SoundInstanceIdentifier>();
        if (this.engineIsRunning()) {
            identifierList.add(SoundInstanceIdentifier.ENGINE_RUNNING);
        }
        if (this.isLowHealth()) {
            identifierList.add(SoundInstanceIdentifier.ENGINE_LOW_HEALTH);
        }
        if (this.isLowOnFuel()) {
            identifierList.add(SoundInstanceIdentifier.ENGINE_LOW_FUEL);
        }
        if (this.isSubmerged()) {
            identifierList.add(SoundInstanceIdentifier.ENGINE_RUNNING_UNDERWATER);
        }
        if (this.isHeatingUp()) {
            identifierList.add(SoundInstanceIdentifier.ENGINE_OVERHEATING);
        }
        this.changeSoundState(identifierList);
    }

    public void changeSoundState(List<SoundInstanceIdentifier> changedSoundList) {
        class_1937 class_19372 = this.boatEngine.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        PlayerLookup.around((class_3218)serverWorld, (class_243)this.boatEngine.method_19538(), (double)60.0).forEach(player -> {
            for (SoundInstanceIdentifier entry : changedSoundList) {
                new StartSoundInstancePacket(this.boatEngine.method_5628(), entry.getIdentifier()).sendPacket((class_3222)player);
            }
        });
    }

    private void playSoundEvent(class_3414 soundEvent) {
        this.playSoundEvent(soundEvent, 1.0f, 1.0f);
    }

    private void playSoundEvent(class_3414 soundEvent, float volume, float pitch) {
        if (this.boatEngine.method_37908().method_8608()) {
            return;
        }
        this.boatEngine.method_37908().method_8396(null, this.boatEngine.method_24515(), soundEvent, class_3419.field_15254, volume, pitch);
    }
}

