/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.util.nbt;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2379;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.shirojr.boatism.api.BoatEngineComponent;
import net.shirojr.boatism.entity.custom.BoatEngineEntity;
import net.shirojr.boatism.init.BoatismDataComponents;
import net.shirojr.boatism.init.BoatismItems;
import net.shirojr.boatism.util.data.codec.BoatismCodecs;

public class BoatEngineNbtHelper {
    public static void writeItemStacksToNbt(class_2371<class_1799> stacks, String name, class_2487 nbt) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 stack = (class_1799)stacks.get(i);
            if (stack.method_7960()) continue;
            BoatismCodecs.MountedInventory.Slot slot = new BoatismCodecs.MountedInventory.Slot(i, stack);
            BoatismCodecs.MountedInventory.Slot.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)slot).result().ifPresent(arg_0 -> nbtList.add(arg_0));
        }
        if (nbtList.isEmpty()) {
            return;
        }
        nbt.method_10566(name, (class_2520)nbtList);
    }

    public static LinkedHashSet<BoatismCodecs.MountedInventory.Slot> readItemStacksFromNbt(class_2487 nbt, String name) {
        LinkedHashSet<BoatismCodecs.MountedInventory.Slot> stacks = new LinkedHashSet<BoatismCodecs.MountedInventory.Slot>();
        if (nbt.method_10573(name, 9)) {
            class_2499 nbtList = nbt.method_10554(name, 10);
            nbtList.forEach(nbtElement -> BoatismCodecs.MountedInventory.Slot.CODEC.parse((DynamicOps)class_2509.field_11560, nbtElement).result().ifPresent(stacks::add));
        }
        return stacks;
    }

    public static class_1799 getItemStackFromBoatEngineEntity(BoatEngineEntity engineEntity) {
        class_1799 engineStack = new class_1799((class_1935)BoatismItems.BASE_ENGINE);
        engineEntity.getHookedBoatEntityUuid().ifPresent(uuid -> engineStack.method_57379(BoatismDataComponents.HOOKED_ENTITY, uuid));
        LinkedHashSet<BoatismCodecs.MountedInventory.Slot> mountedInventory = new LinkedHashSet<BoatismCodecs.MountedInventory.Slot>();
        for (int i = 0; i < engineEntity.getMountedInventory().method_54454().size(); ++i) {
            class_1799 stack = engineEntity.getMountedInventory().method_5438(i);
            if (stack.method_7960()) continue;
            mountedInventory.add(new BoatismCodecs.MountedInventory.Slot(i, stack));
        }
        engineStack.method_57379(BoatismDataComponents.MOUNTED_ITEMS, mountedInventory);
        engineStack.method_57379(BoatismDataComponents.IS_RUNNING, (Object)engineEntity.isRunning());
        engineStack.method_57379(BoatismDataComponents.POWER_OUTPUT, (Object)engineEntity.getPowerLevel());
        engineStack.method_57379(BoatismDataComponents.OVERHEAT, (Object)Float.valueOf(engineEntity.getOverheat()));
        engineStack.method_57379(BoatismDataComponents.ROTATION, (Object)engineEntity.getArmRotation());
        engineStack.method_57379(BoatismDataComponents.IS_SUBMERGED, (Object)engineEntity.isSubmerged());
        engineStack.method_57379(BoatismDataComponents.FUEL, (Object)engineEntity.getFuel());
        engineStack.method_57379(BoatismDataComponents.IS_LOCKED, (Object)engineEntity.isLocked());
        return engineStack;
    }

    public static List<class_1799> getMountedItemsFromBoatEngineEntity(BoatEngineEntity engineEntity) {
        ArrayList<class_1799> returnedItemStacks = new ArrayList<class_1799>();
        engineEntity.getMountedInventory().method_54454().forEach(stack -> {
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof BoatEngineComponent) {
                BoatEngineComponent component = (BoatEngineComponent)patt0$temp;
                returnedItemStacks.add(component.getReturnedItemStack((class_1799)stack));
            }
        });
        return returnedItemStacks;
    }

    public static BoatEngineEntity getBoatEngineEntityFromItemStack(class_1799 stack, class_1690 linkedBoat) {
        BoatEngineEntity boatEngine = new BoatEngineEntity(linkedBoat.method_37908(), linkedBoat);
        LinkedHashSet mountedInventory = (LinkedHashSet)stack.method_57824(BoatismDataComponents.MOUNTED_ITEMS);
        if (mountedInventory != null) {
            boatEngine.setMountedItemsFromItemStackList(mountedInventory);
        }
        boatEngine.setIsRunning((Boolean)stack.method_57825(BoatismDataComponents.IS_RUNNING, (Object)false));
        boatEngine.setPowerLevel(class_3532.method_15340((int)((Integer)stack.method_57825(BoatismDataComponents.POWER_OUTPUT, (Object)0)), (int)0, (int)4));
        float overheat = (float)class_3532.method_15350((double)((Float)stack.method_57825(BoatismDataComponents.OVERHEAT, (Object)Float.valueOf(0.0f))).floatValue(), (double)0.0, (double)((double)boatEngine.getEngineHandler().getMaxOverHeatCapacity() * 0.8));
        boatEngine.setOverheat(overheat);
        boatEngine.setArmRotation((class_2379)stack.method_57825(BoatismDataComponents.ROTATION, (Object)new class_2379(0.0f, 0.0f, 0.0f)));
        boatEngine.setSubmerged((Boolean)stack.method_57825(BoatismDataComponents.IS_SUBMERGED, (Object)false));
        boatEngine.setFuel((Long)stack.method_57825(BoatismDataComponents.FUEL, (Object)0L));
        boatEngine.setLocked((Boolean)stack.method_57825(BoatismDataComponents.IS_LOCKED, (Object)false));
        return boatEngine;
    }
}

