/*
 * Decompiled with CFR 0.152.
 */
package net.shirojr.boatism.util.storage;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_7225;
import net.shirojr.boatism.util.LoggerUtil;
import net.shirojr.boatism.util.data.FluidStack;
import net.shirojr.boatism.util.data.TransactionalLong;
import net.shirojr.boatism.util.tag.BoatismTags;
import org.jetbrains.annotations.Nullable;

public class FermentingInventory
extends class_1277 {
    @Nullable
    private Predicate<FluidVariant> filter;
    private final SingleFluidStorage fluidStorage;
    private final InventoryStorage inventoryWrapper = InventoryStorage.of((class_1263)this, null);

    public FermentingInventory(long fluidCapacity, @Nullable Predicate<FluidVariant> filter, int stacksSize) {
        super(stacksSize);
        this.filter = filter;
        this.fluidStorage = SingleFluidStorage.withFixedCapacity((long)fluidCapacity, () -> ((FermentingInventory)this).method_5431());
    }

    public FermentingInventory(long fluidCapacity, @Nullable Predicate<FluidVariant> filter, class_1799 ... stacks) {
        super(stacks);
        this.filter = filter;
        this.fluidStorage = SingleFluidStorage.withFixedCapacity((long)fluidCapacity, () -> ((FermentingInventory)this).method_5431());
    }

    public FluidVariant getFluidVariant() {
        return (FluidVariant)this.getFluidStorage().getResource();
    }

    public void setFilter(@Nullable Predicate<FluidVariant> filter) {
        this.filter = filter;
        if (filter == null || !filter.test((FluidVariant)this.getFluidStorage().getResource())) {
            this.clearFluidStorage();
        }
    }

    public boolean isFluidAllowed(FluidVariant fluid) {
        if (this.filter == null) {
            LoggerUtil.LOGGER.error("Fermenting Inventory filter wasn't set");
            return false;
        }
        return this.filter.test(fluid);
    }

    public boolean hasFluidStorageEnoughSpace(int amount) {
        return this.getFluidStorage().getAmount() + (long)amount <= this.getFluidStorage().getCapacity();
    }

    public SingleFluidStorage getFluidStorage() {
        return this.fluidStorage;
    }

    public boolean method_27070(class_1799 stack) {
        if (stack.method_31573(BoatismTags.Items.FERMENTABLE) && super.method_27070(stack)) {
            return true;
        }
        ContainerItemContext context = ContainerItemContext.withConstant((class_1799)stack);
        Storage itemFluidStorage = (Storage)FluidStorage.ITEM.find(stack, (Object)context);
        if (itemFluidStorage == null) {
            return false;
        }
        if (!this.getFluidStorage().supportsInsertion()) {
            return false;
        }
        if (this.getFluidStorage().getAmount() >= this.getFluidStorage().getCapacity()) {
            return false;
        }
        for (StorageView fluidEntry : itemFluidStorage) {
            FluidVariant fluid;
            if (fluidEntry.isResourceBlank() || !this.isFluidAllowed(fluid = (FluidVariant)fluidEntry.getResource()) || this.getFluidStorage().getAmount() + fluidEntry.getAmount() > this.getFluidStorage().getCapacity()) continue;
            return true;
        }
        return false;
    }

    public boolean insert(class_1799 stack) {
        Transaction transaction;
        if (!this.method_27070(stack)) {
            return false;
        }
        ContainerItemContext context = ContainerItemContext.withConstant((class_1799)stack);
        Storage itemFluidStorage = (Storage)FluidStorage.ITEM.find(stack, (Object)context);
        if (itemFluidStorage != null) {
            transaction = Transaction.openOuter();
            try {
                long movedAmount = StorageUtil.move((Storage)itemFluidStorage, (Storage)this.getFluidStorage(), this::isFluidAllowed, (long)81000L, (TransactionContext)transaction);
                if (movedAmount == 81000L) {
                    transaction.commit();
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        transaction = Transaction.openOuter();
        try {
            long insertedAmount = this.inventoryWrapper.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
            if (insertedAmount == (long)stack.method_7947()) {
                transaction.commit();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        return false;
    }

    public int method_5444() {
        return 1;
    }

    public Optional<Long> insertFluid(FluidVariant fluid, long amount) {
        if (fluid.isOf((Object)FluidVariant.blank().getFluid())) {
            this.clearFluidStorage();
            return Optional.of(0L);
        }
        TransactionalLong overflow = new TransactionalLong(0L);
        try (Transaction transaction = Transaction.openOuter();){
            if (!this.isFluidAllowed(fluid)) {
                transaction.abort();
            }
            long insertedAmount = this.getFluidStorage().insert((TransferVariant)fluid, amount, (TransactionContext)transaction);
            overflow.set((TransactionContext)transaction, Math.max(0L, amount - insertedAmount));
            transaction.commit();
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
        return Optional.of(overflow.get());
    }

    public long extractFluid(long amount) {
        TransactionalLong underflow = new TransactionalLong(0L);
        try (Transaction transaction = Transaction.openOuter();){
            long extractedAmount = this.getFluidStorage().extract((TransferVariant)this.getFluidVariant(), amount, (TransactionContext)transaction);
            underflow.set((TransactionContext)transaction, Math.max(0L, amount - extractedAmount));
            transaction.commit();
        }
        return underflow.get();
    }

    public void clearFluidStorage() {
        FluidVariant fluidVariant = (FluidVariant)this.fluidStorage.getResource();
        if (fluidVariant == null || this.getFluidStorage().isResourceBlank()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            this.getFluidStorage().extract((TransferVariant)fluidVariant, this.getFluidStorage().getAmount(), (TransactionContext)transaction);
            transaction.commit();
        }
    }

    public void clearItemsAndFluid() {
        super.method_5448();
        this.clearFluidStorage();
        this.method_5431();
    }

    public boolean method_5442() {
        if (!super.method_5442()) {
            return false;
        }
        return this.getFluidStorage().getAmount() <= 0L;
    }

    public String toString() {
        return super.toString() + ((FluidVariant)this.getFluidStorage().getResource()).toString() + this.getFluidStorage().getAmount() + "/" + this.getFluidStorage().getCapacity();
    }

    public void method_7659(class_2499 nbtList, class_7225.class_7874 registries) {
        super.method_7659(nbtList, registries);
        this.clearFluidStorage();
        DataResult fluidStorageData = FluidStack.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbtList);
        fluidStorageData.result().ifPresent(fluidStack -> this.insertFluid(fluidStack.variant(), fluidStack.amount()));
    }

    public class_2499 method_7660(class_7225.class_7874 registries) {
        class_2499 list = super.method_7660(registries);
        FluidStack fluidStack = new FluidStack(this.getFluidVariant(), this.getFluidStorage().getAmount());
        DataResult fluidNbt = FluidStack.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)fluidStack);
        fluidNbt.result().ifPresent(arg_0 -> list.add(arg_0));
        return list;
    }

    public static Predicate<FluidVariant> getSimpleFluidPredicate(FluidVariant ... allowedFluid) {
        return fluidVariant -> Arrays.asList(allowedFluid).contains(fluidVariant);
    }
}

