/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import terrablender.api.ParameterUtils;
import terrablender.api.Region;

public class VanillaParameterOverlayBuilder {
    private Map<class_6544.class_4762, class_5321<class_1959>> mappings = Maps.newHashMap();

    public void add(class_6544.class_4762 point, class_5321<class_1959> biome) {
        this.mappings.put(point, biome);
    }

    public List<Pair<class_6544.class_4762, class_5321<class_1959>>> build() {
        HashSet standalonePoints = Sets.newHashSet(this.mappings.keySet());
        HashMultimap adjacentPoints = HashMultimap.create();
        this.permuteMappings((arg_0, arg_1) -> VanillaParameterOverlayBuilder.lambda$build$0((SetMultimap)adjacentPoints, standalonePoints, arg_0, arg_1));
        ImmutableList.Builder outBuilder = ImmutableList.builder();
        outBuilder.addAll(this.mappings.entrySet().stream().map(entry -> Pair.of((Object)((class_6544.class_4762)entry.getKey()), (Object)((class_5321)entry.getValue()))).toList());
        if (!standalonePoints.isEmpty()) {
            outBuilder.addAll(standalonePoints.stream().flatMap(point -> VanillaParameterOverlayBuilder.inversePoints(List.of(point)).stream().map(inversePoint -> Pair.of((Object)inversePoint, Region.DEFERRED_PLACEHOLDER))).toList());
        }
        for (Adjacency adjacency : adjacentPoints.keySet()) {
            Set values = adjacentPoints.get((Object)adjacency);
            if (values.isEmpty()) continue;
            outBuilder.addAll(VanillaParameterOverlayBuilder.inversePoints(List.copyOf(values)).stream().map(point -> Pair.of((Object)point, Region.DEFERRED_PLACEHOLDER)).toList());
        }
        return outBuilder.build();
    }

    private void permuteMappings(BiConsumer<class_6544.class_4762, class_6544.class_4762> consumer) {
        List entries = this.mappings.entrySet().stream().toList();
        if (entries.size() == 0) {
            throw new RuntimeException("Need at least one entry to permute!");
        }
        if (entries.size() == 1) {
            class_6544.class_4762 point = (class_6544.class_4762)((Map.Entry)entries.get(0)).getKey();
            consumer.accept(point, point);
        } else {
            for (int i = 0; i < entries.size(); ++i) {
                class_6544.class_4762 pointA = (class_6544.class_4762)((Map.Entry)entries.get(i)).getKey();
                for (int j = i; j < entries.size(); ++j) {
                    consumer.accept(pointA, (class_6544.class_4762)((Map.Entry)entries.get(j)).getKey());
                }
            }
        }
    }

    private static List<class_6544.class_4762> inversePoints(List<class_6544.class_4762> values) {
        ArrayList temperatures = Lists.newArrayList();
        ArrayList humidities = Lists.newArrayList();
        ArrayList continentalnesses = Lists.newArrayList();
        ArrayList erosions = Lists.newArrayList();
        ArrayList depths = Lists.newArrayList();
        ArrayList weirdnesses = Lists.newArrayList();
        for (class_6544.class_4762 point : values) {
            temperatures.add(point.comp_105());
            humidities.add(point.comp_106());
            continentalnesses.add(point.comp_107());
            erosions.add(point.comp_108());
            depths.add(point.comp_109());
            weirdnesses.add(point.comp_110());
        }
        temperatures.sort(Comparator.comparing(class_6544.class_6546::comp_103));
        humidities.sort(Comparator.comparing(class_6544.class_6546::comp_103));
        continentalnesses.sort(Comparator.comparing(class_6544.class_6546::comp_103));
        erosions.sort(Comparator.comparing(class_6544.class_6546::comp_103));
        depths.sort(Comparator.comparing(class_6544.class_6546::comp_103));
        weirdnesses.sort(Comparator.comparing(class_6544.class_6546::comp_103));
        return new ParameterUtils.ParameterPointListBuilder().temperature((class_6544.class_6546[])VanillaParameterOverlayBuilder.inverseParameters(temperatures).toArray(class_6544.class_6546[]::new)).humidity((class_6544.class_6546[])VanillaParameterOverlayBuilder.inverseParameters(humidities).toArray(class_6544.class_6546[]::new)).continentalness((class_6544.class_6546[])VanillaParameterOverlayBuilder.inverseParameters(continentalnesses).toArray(class_6544.class_6546[]::new)).erosion((class_6544.class_6546[])VanillaParameterOverlayBuilder.inverseParameters(erosions).toArray(class_6544.class_6546[]::new)).depth((class_6544.class_6546[])VanillaParameterOverlayBuilder.inverseParameters(depths).toArray(class_6544.class_6546[]::new)).weirdness((class_6544.class_6546[])VanillaParameterOverlayBuilder.inverseParameters(weirdnesses).toArray(class_6544.class_6546[]::new)).build();
    }

    private static List<class_6544.class_6546> inverseParameters(List<class_6544.class_6546> values) {
        if (values.isEmpty()) {
            return List.of(class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f));
        }
        ArrayList out = Lists.newArrayList();
        float prevMax = -1.0f;
        for (class_6544.class_6546 value : values) {
            float min = class_6544.method_38666((long)value.comp_103());
            float max = class_6544.method_38666((long)value.comp_104());
            if (min - prevMax > 0.0f) {
                out.add(class_6544.class_6546.method_38121((float)prevMax, (float)min));
            }
            prevMax = max;
        }
        if (prevMax < 1.0f) {
            out.add(class_6544.class_6546.method_38121((float)prevMax, (float)1.0f));
        }
        return out;
    }

    private static /* synthetic */ void lambda$build$0(SetMultimap adjacentPoints, Set standalonePoints, class_6544.class_4762 a, class_6544.class_4762 b) {
        if (a.equals((Object)b)) {
            return;
        }
        for (Adjacency adjacency : Adjacency.values()) {
            if (!adjacency.isAdjacent(a, b)) continue;
            adjacentPoints.put((Object)adjacency, (Object)a);
            adjacentPoints.put((Object)adjacency, (Object)b);
            standalonePoints.remove(a);
            standalonePoints.remove(b);
        }
    }

    private static enum Adjacency {
        TEMPERATURE(class_6544.class_4762::comp_105),
        HUMIDITY(class_6544.class_4762::comp_106),
        CONTINENTALNESS(class_6544.class_4762::comp_107),
        EROSION(class_6544.class_4762::comp_108),
        DEPTH(class_6544.class_4762::comp_109),
        WEIRDNESS(class_6544.class_4762::comp_110);

        Function<class_6544.class_4762, class_6544.class_6546> getter;

        private Adjacency(Function<class_6544.class_4762, class_6544.class_6546> getter) {
            this.getter = getter;
        }

        public class_6544.class_6546 getParameter(class_6544.class_4762 point) {
            return this.getter.apply(point);
        }

        public boolean isAdjacent(class_6544.class_4762 a, class_6544.class_4762 b) {
            for (Adjacency adjacency : Adjacency.values()) {
                class_6544.class_6546 paramA = adjacency.getParameter(a);
                class_6544.class_6546 paramB = adjacency.getParameter(b);
                if (adjacency == this && paramA.equals((Object)paramB)) {
                    return false;
                }
                if (adjacency == this || paramA.equals((Object)paramB)) continue;
                return false;
            }
            return true;
        }
    }
}

