/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.armorful.client.renderer.layers;

import com.google.common.collect.Maps;
import dev.imb11.armorful.util.ArmorfulUtil;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1634;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.minecraft.class_617;
import net.minecraft.class_918;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class VexArmorLayer
extends class_3887<class_1634, class_617> {
    private static final Map<String, class_2960> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final class_572 innerModel;
    private final class_572 outerModel;

    public VexArmorLayer(class_3883<class_1634, class_617> pRenderer, class_5599 modelSets) {
        super(pRenderer);
        this.innerModel = new class_572(modelSets.method_32072(class_5602.field_27639));
        this.outerModel = new class_572(modelSets.method_32072(class_5602.field_27677));
    }

    public void copyPropertiesTo(class_572 pModel) {
        pModel.field_3398.method_17138(((class_617)this.method_17165()).method_32008().method_32086("head"));
        pModel.field_3391.method_17138(((class_617)this.method_17165()).method_32008().method_32086("body"));
        pModel.field_3401.method_17138(((class_617)this.method_17165()).method_32008().method_32086("body").method_32086("right_arm"));
        pModel.field_27433.method_17138(((class_617)this.method_17165()).method_32008().method_32086("body").method_32086("left_arm"));
        pModel.field_3392.method_17138(((class_617)this.method_17165()).method_32008().method_32086("body"));
        pModel.field_3397.method_17138(((class_617)this.method_17165()).method_32008().method_32086("body"));
    }

    public void render(class_4587 pMatrixStack, class_4597 pBuffer, int pPackedLight, class_1634 pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.copyPropertiesTo(this.innerModel);
        this.copyPropertiesTo(this.outerModel);
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, class_1304.field_6174, pPackedLight, this.getArmorModel(class_1304.field_6174));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, class_1304.field_6172, pPackedLight, this.getArmorModel(class_1304.field_6172));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, class_1304.field_6166, pPackedLight, this.getArmorModel(class_1304.field_6166));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, class_1304.field_6169, pPackedLight, this.getArmorModel(class_1304.field_6169));
    }

    private void renderArmorPiece(class_4587 pPoseStack, class_4597 pBuffer, class_1634 pLivingEntity, class_1304 pSlot, int p_117123_, class_572 pModel) {
        class_1799 itemstack = pLivingEntity.method_6118(pSlot);
        class_1792 class_17922 = itemstack.method_7909();
        if (class_17922 instanceof class_1738) {
            class_1738 armoritem = (class_1738)class_17922;
            if (armoritem.method_7685() == pSlot) {
                this.setPartVisibility(pModel, pSlot);
                class_572 model = this.getArmorModel(pSlot);
                boolean flag1 = itemstack.method_7958();
                if (armoritem.method_57347().method_57832(class_9334.field_49644)) {
                    int i = ((class_9282)armoritem.method_57347().method_57829(class_9334.field_49644)).comp_2384();
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderModel(pPoseStack, pBuffer, p_117123_, flag1, (class_3879)model, f, f1, f2, this.getArmorResource(itemstack, pSlot, null));
                    this.renderModel(pPoseStack, pBuffer, p_117123_, flag1, (class_3879)model, 1.0f, 1.0f, 1.0f, this.getArmorResource(itemstack, pSlot, "overlay"));
                } else {
                    this.renderModel(pPoseStack, pBuffer, p_117123_, flag1, (class_3879)model, 1.0f, 1.0f, 1.0f, this.getArmorResource(itemstack, pSlot, null));
                }
            }
            if (armoritem.method_7685() == class_1304.field_6174) {
                pPoseStack.method_22903();
                pPoseStack.method_22909();
            }
        }
    }

    protected void setPartVisibility(class_572 pModel, class_1304 pSlot) {
        pModel.method_2805(false);
        switch (pSlot) {
            case field_6169: {
                pModel.field_3398.field_3665 = true;
                pModel.field_3394.field_3665 = true;
                pModel.field_3398.field_37938 = 0.8f;
                pModel.field_3398.field_37939 = 0.8f;
                pModel.field_3398.field_37940 = 0.8f;
                pModel.field_3398.field_3656 -= 13.0f;
                break;
            }
            case field_6174: {
                pModel.field_3391.field_3665 = true;
                pModel.field_3401.field_3665 = true;
                pModel.field_27433.field_3665 = true;
                pModel.field_3401.field_3656 -= -11.5f;
                pModel.field_3401.field_3655 += 0.25f;
                pModel.field_3401.field_3657 -= 3.0f;
                pModel.field_3401.field_37938 = 0.8f;
                pModel.field_3401.field_37939 = 0.8f;
                pModel.field_3401.field_37940 = 0.8f;
                pModel.field_27433.field_37938 = 0.8f;
                pModel.field_27433.field_37939 = 0.8f;
                pModel.field_27433.field_37940 = 0.8f;
                pModel.field_27433.field_3656 -= -11.5f;
                pModel.field_27433.field_3655 += 0.25f;
                pModel.field_27433.field_3657 -= -3.0f;
                pModel.field_3391.field_37938 = 0.8f;
                pModel.field_3391.field_37939 = 0.8f;
                pModel.field_3391.field_37940 = 0.8f;
                pModel.field_3391.field_3656 -= 9.0f;
                break;
            }
            case field_6172: {
                pModel.field_3391.field_3665 = true;
                pModel.field_3392.field_3665 = true;
                pModel.field_3397.field_3665 = true;
                pModel.field_3391.field_3656 -= 6.0f;
                pModel.field_3391.field_3655 -= -0.6f;
                pModel.field_3391.field_37938 = 0.6f;
                pModel.field_3391.field_37939 = 0.6f;
                pModel.field_3391.field_37940 = 0.75f;
                pModel.field_3392.field_37938 = 0.6f;
                pModel.field_3392.field_37939 = 0.6f;
                pModel.field_3392.field_37940 = 0.7f;
                pModel.field_3392.field_3656 = 20.0f;
                pModel.field_3392.field_3657 = -1.5f;
                pModel.field_3392.field_3655 = 1.5f;
                pModel.field_3397.field_37938 = 0.6f;
                pModel.field_3397.field_37939 = 0.6f;
                pModel.field_3397.field_37940 = 0.7f;
                pModel.field_3397.field_3656 = 20.0f;
                pModel.field_3397.field_3657 = 1.5f;
                pModel.field_3397.field_3655 = 1.5f;
                break;
            }
            case field_6166: {
                pModel.field_3392.field_3665 = true;
                pModel.field_3397.field_3665 = true;
                pModel.field_3392.field_3656 = 20.0f;
                pModel.field_3392.field_37938 = 0.6f;
                pModel.field_3392.field_37939 = 0.6f;
                pModel.field_3392.field_37940 = 0.7f;
                pModel.field_3392.field_3657 = -1.5f;
                pModel.field_3392.field_3655 = 1.5f;
                pModel.field_3397.field_37938 = 0.6f;
                pModel.field_3397.field_37939 = 0.6f;
                pModel.field_3397.field_37940 = 0.7f;
                pModel.field_3397.field_3656 = 20.0f;
                pModel.field_3397.field_3657 = 1.5f;
                pModel.field_3397.field_3655 = 1.5f;
            }
        }
    }

    private void renderModel(class_4587 pPoseStack, class_4597 pBuffer, int p_117109_, boolean p_117111_, class_3879 pModel, float p_117114_, float p_117115_, float p_117116_, class_2960 armorResource) {
        class_4588 vertexconsumer = class_918.method_27952((class_4597)pBuffer, (class_1921)class_1921.method_23576((class_2960)armorResource), (boolean)false);
        pModel.method_60879(pPoseStack, vertexconsumer, p_117109_, class_4608.field_21444);
    }

    private class_572 getArmorModel(class_1304 pSlot) {
        return this.usesInnerModel(pSlot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(class_1304 pSlot) {
        return pSlot == class_1304.field_6172;
    }

    public class_2960 getArmorResource(class_1799 stack, class_1304 slot, String type) {
        String s1;
        class_2960 resourcelocation;
        class_1738 item = (class_1738)stack.method_7909();
        String texture = item.method_7686().method_55840();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        if ((resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type)))) == null) {
            resourcelocation = ArmorfulUtil.defaultID(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

