/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.armorful.mixin.illagers;

import com.google.common.collect.Maps;
import dev.imb11.armorful.loot.ArmorfulLootTables;
import dev.imb11.armorful.util.ArmorfulUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3732;
import net.minecraft.class_3763;
import net.minecraft.class_3765;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3763.class})
public abstract class AbstractRaiderMixin
extends class_3732 {
    @Unique
    private static final Map<class_1304, class_2960> EQUIPMENT_SLOT_ITEMS = (Map)class_156.method_654((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(class_1304.field_6169, ArmorfulLootTables.ILLAGER_HELMET);
        slotItems.put(class_1304.field_6174, ArmorfulLootTables.ILLAGER_CHEST);
        slotItems.put(class_1304.field_6172, ArmorfulLootTables.ILLAGER_LEGGINGS);
        slotItems.put(class_1304.field_6166, ArmorfulLootTables.ILLAGER_FEET);
    });

    @Shadow
    @Nullable
    public abstract class_3765 method_16478();

    protected AbstractRaiderMixin(class_1299<? extends class_3763> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Unique
    private static float getWaveArmorChances(int waves) {
        return switch (waves) {
            case 1 -> 0.32f;
            case 2 -> 0.34f;
            case 3 -> 0.38f;
            case 4 -> 0.4f;
            case 5 -> 0.42f;
            case 6 -> 0.44f;
            case 7 -> 0.48f;
            case 8 -> 0.52f;
            default -> 0.0f;
        };
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="TAIL")}, cancellable=false)
    public void finalizeSpawn(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, CallbackInfoReturnable<class_1315> cir) {
        if (world instanceof class_3218) {
            if (this.method_16478() != null || spawnReason == class_3730.field_16467) {
                this.giveArmorOnRaids();
            } else {
                ArmorfulUtil.giveArmorNaturally(this.field_5974, (class_1309)this, difficulty);
            }
        }
    }

    @Unique
    public void giveArmorOnRaids() {
        float difficultyChance = this.method_37908().method_8407() == class_1267.field_5807 ? 0.3f : 0.65f;
        int illagerWaves = this.method_16478().method_16490();
        float waveChances = AbstractRaiderMixin.getWaveArmorChances(illagerWaves);
        if (this.method_59922().method_43057() < waveChances) {
            boolean flag = true;
            for (class_1304 equipmentslottype : class_1304.values()) {
                if (equipmentslottype.method_5925() != class_1304.class_1305.field_6178) continue;
                if (!flag && this.field_5974.method_43057() < difficultyChance) break;
                flag = false;
                for (class_1799 stack : this.getItemsFromLootTable(equipmentslottype)) {
                    this.method_5673(equipmentslottype, stack);
                }
            }
        }
    }

    @Unique
    public List<class_1799> getItemsFromLootTable(class_1304 slot) {
        if (EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            class_52 loot = this.method_37908().method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)EQUIPMENT_SLOT_ITEMS.get(slot)));
            class_8567.class_8568 lootcontext$builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this);
            return loot.method_51878(lootcontext$builder.method_51875(ArmorfulLootTables.SLOT));
        }
        return null;
    }
}

