/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModTags;
import artifacts.util.AbilityHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_9139;

public record UpgradeToolTierAbility(Value<Tier> tier) implements ArtifactAbility
{
    public static final MapCodec<UpgradeToolTierAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.TOOL_TIER.codec().fieldOf("tier").forGetter(UpgradeToolTierAbility::tier)).apply((Applicative)instance, UpgradeToolTierAbility::new));
    public static final class_9139<ByteBuf, UpgradeToolTierAbility> STREAM_CODEC = class_9139.method_56434(ValueTypes.TOOL_TIER.streamCodec(), UpgradeToolTierAbility::tier, UpgradeToolTierAbility::new);

    public static boolean canHarvestWithTier(class_1309 entity, class_2680 state) {
        if (state.method_26164(ModTags.MINEABLE_WITH_DIGGING_CLAWS)) {
            Tier tier = Tier.fromLevel(AbilityHelper.maxInt((ArtifactAbility.Type)ModAbilities.UPGRADE_TOOL_TIER.comp_349(), entity, ability -> ((Tier)((Object)((Object)ability.tier().get()))).getLevel(), false));
            return UpgradeToolTierAbility.isCorrectTierForDrops(tier, state);
        }
        return false;
    }

    public static boolean isCorrectTierForDrops(Tier tier, class_2680 state) {
        if (!state.method_29291()) {
            return true;
        }
        int i = tier.getLevel();
        if (state.method_26164(class_3481.field_33717)) {
            return i >= 4;
        }
        if (state.method_26164(class_3481.field_33718)) {
            return i >= 3;
        }
        if (state.method_26164(class_3481.field_33719)) {
            return i >= 2;
        }
        return i >= 1;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.UPGRADE_TOOL_TIER.comp_349();
    }

    @Override
    public boolean isNonCosmetic() {
        return this.tier().get() != Tier.NONE;
    }

    @Override
    public void addAbilityTooltip(List<class_5250> tooltip) {
        class_2960 id = ModAbilities.REGISTRY.getId(this.getType());
        tooltip.add(class_2561.method_43469((String)"%s.tooltip.ability.%s".formatted(id.method_12836(), id.method_12832()), (Object[])new Object[]{UpgradeToolTierAbility.getTierName((Tier)((Object)this.tier.get()))}));
    }

    public static class_2561 getTierName(Tier tier) {
        return class_2561.method_43471((String)"%s.tooltip.tool_tier.%s".formatted("artifacts", tier.method_15434()));
    }

    public static enum Tier implements class_3542
    {
        NONE(0),
        WOOD(1),
        STONE(2),
        IRON(3),
        DIAMOND(4),
        NETHERITE(5);

        private final int level;

        private Tier(int level) {
            this.level = level;
        }

        public static Tier fromLevel(int level) {
            return switch (level) {
                case 0 -> NONE;
                case 1 -> WOOD;
                case 2 -> STONE;
                case 3 -> IRON;
                case 4 -> DIAMOND;
                default -> NETHERITE;
            };
        }

        public int getLevel() {
            return this.level;
        }

        public String method_15434() {
            return this.toString().toLowerCase();
        }
    }
}

