/*
 * Decompiled with CFR 0.152.
 */
package artifacts.event;

import artifacts.Artifacts;
import artifacts.ability.ApplyCooldownAfterDamageAbility;
import artifacts.ability.ArtifactAbility;
import artifacts.ability.AttractItemsAbility;
import artifacts.ability.SwimInAirAbility;
import artifacts.ability.mobeffect.ApplyMobEffectAfterDamageAbility;
import artifacts.ability.mobeffect.AttacksInflictMobEffectAbility;
import artifacts.ability.retaliation.RetaliationAbility;
import artifacts.attribute.DynamicAttributeModifier;
import artifacts.integration.EquipmentIntegrationUtils;
import artifacts.item.UmbrellaItem;
import artifacts.mixin.accessors.MobAccessor;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModTags;
import artifacts.util.AbilityHelper;
import artifacts.util.DamageSourceHelper;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1752;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_4174;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9331;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class ArtifactEvents {
    public static void register() {
        PlayerEvent.DROP_ITEM.register(AttractItemsAbility::onItemToss);
        EntityEvent.LIVING_HURT.register(ArtifactEvents::onAttackBurningLivingHurt);
        EntityEvent.LIVING_HURT.register(ArtifactEvents::onLightningHurt);
        EntityEvent.LIVING_HURT.register(AttacksInflictMobEffectAbility::onLivingHurt);
        EntityEvent.ADD.register(ArtifactEvents::onEntityJoinWorld);
        TickEvent.PLAYER_PRE.register(SwimInAirAbility::onHeliumFlamingoTick);
    }

    public static void livingUpdate(class_1309 entity) {
        ArtifactEvents.onItemTick(entity);
        UmbrellaItem.onLivingUpdate(entity);
        DynamicAttributeModifier.tickModifiers(entity);
    }

    public static void onLivingDamaged(class_1309 entity, class_1282 source, float amount) {
        ArtifactEvents.absorbDamage(entity, source, amount);
        ApplyMobEffectAfterDamageAbility.onLivingDamaged(entity, source, amount);
        ApplyCooldownAfterDamageAbility.onLivingDamaged(entity, source);
    }

    public static void onItemChanged(class_1309 entity, class_1799 oldStack, class_1799 newStack) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        List oldAbilities = (List)oldStack.method_57824((class_9331)ModDataComponents.ABILITIES.comp_349());
        List newAbilities = (List)newStack.method_57824((class_9331)ModDataComponents.ABILITIES.comp_349());
        if (oldAbilities == null || oldAbilities.equals(newAbilities)) {
            return;
        }
        if (newAbilities == null) {
            newAbilities = List.of();
        }
        for (ArtifactAbility ability : oldAbilities) {
            if (newAbilities.contains(ability)) continue;
            boolean wasActive = ability.isEnabled() && AbilityHelper.isToggledOn(ability.getType(), entity);
            ability.onUnequip(entity, wasActive);
        }
    }

    public static void onItemTick(class_1309 entity) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        EquipmentIntegrationUtils.findAllEquippedBy(entity, stack -> stack.method_57826((class_9331)ModDataComponents.ABILITIES.comp_349())).forEach(stack -> {
            for (ArtifactAbility ability : AbilityHelper.getAbilities(stack)) {
                class_1657 player;
                boolean isActive = ability.isActive(entity);
                boolean isOnCooldown = entity instanceof class_1657 && (player = (class_1657)entity).method_7357().method_7904(stack.method_7909());
                ability.wornTick(entity, isOnCooldown, isActive);
            }
        });
    }

    public static EventResult onAttackBurningLivingHurt(class_1309 entity, class_1282 damageSource, float amount) {
        class_1309 attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && DamageSourceHelper.isMeleeAttack(damageSource) && !entity.method_5753()) {
            int duration = (int)attacker.method_45325(ModAttributes.ATTACK_BURNING_DURATION);
            entity.method_5639((float)duration);
        }
        return EventResult.pass();
    }

    public static void doPostAttackEffects(class_1309 entity, class_1282 damageSource) {
        ArtifactEvents.activateRetaliationAbility((ArtifactAbility.Type)ModAbilities.SET_ATTACKERS_ON_FIRE.comp_349(), entity, damageSource);
        ArtifactEvents.activateRetaliationAbility((ArtifactAbility.Type)ModAbilities.THORNS.comp_349(), entity, damageSource);
        ArtifactEvents.activateRetaliationAbility((ArtifactAbility.Type)ModAbilities.STRIKE_ATTACKERS_WITH_LIGHTNING.comp_349(), entity, damageSource);
    }

    private static void activateRetaliationAbility(ArtifactAbility.Type<? extends RetaliationAbility> type, class_1309 entity, class_1282 damageSource) {
        AbilityHelper.forEach(type, entity, (ability, stack) -> ability.onLivingHurt(entity, (class_1799)stack, damageSource), true);
    }

    private static EventResult onEntityJoinWorld(class_1297 entity, class_1937 level) {
        class_1314 creeper;
        if (entity instanceof class_1314 && (creeper = (class_1314)entity).method_5864().method_20210(ModTags.CREEPERS)) {
            Predicate<class_1309> predicate = target -> AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SCARE_CREEPERS.comp_349(), target);
            ((MobAccessor)creeper).getGoalSelector().method_6277(3, (class_1352)new class_1338(creeper, class_1657.class, predicate, 6.0f, 1.0, 1.3, class_1301.field_6156::test));
        }
        return EventResult.pass();
    }

    public static void onPlaySoundAtEntity(class_1309 entity, float volume, float pitch) {
        if (Artifacts.CONFIG.general.modifyHurtSounds.get().booleanValue()) {
            AbilityHelper.forEach((ArtifactAbility.Type)ModAbilities.MODIFY_HURT_SOUND.comp_349(), entity, ability -> entity.method_5783((class_3414)ability.soundEvent().comp_349(), volume, pitch));
        }
    }

    private static EventResult onLightningHurt(class_1309 entity, class_1282 damageSource, float amount) {
        if (!entity.method_37908().method_8608() && amount > 0.0f && AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.DAMAGE_IMMUNITY.comp_349(), entity, ability -> damageSource.method_48789(ability.tag()))) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static class_1799 applySmeltOresAbility(class_1799 original, @Nullable class_1297 entity, @Nullable class_2680 state, Consumer<Integer> experienceConsumer) {
        if (entity instanceof class_1309) {
            class_1799 smeltingResult;
            Optional recipe;
            class_1309 livingEntity = (class_1309)entity;
            if (AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.SMELT_ORES.comp_349(), livingEntity) && state != null && state.method_26164(ModTags.ORES) && original.method_31573(ModTags.RAW_MATERIALS) && (recipe = livingEntity.method_37908().method_8433().method_8132(class_3956.field_17546, (class_9695)new class_9696(original), livingEntity.method_37908())).isPresent() && !(smeltingResult = ((class_3861)((class_8786)recipe.get()).comp_1933()).method_8110((class_7225.class_7874)livingEntity.method_37908().method_30349())).method_7960()) {
                experienceConsumer.accept(ArtifactEvents.getExperience(((class_3861)((class_8786)recipe.get()).comp_1933()).method_8171()));
                return smeltingResult.method_46651(smeltingResult.method_7947() * original.method_7947());
            }
        }
        return original;
    }

    private static int getExperience(float experience) {
        int amount = class_3532.method_15375((float)experience);
        if (Math.random() < (double)class_3532.method_22450((float)experience)) {
            ++amount;
        }
        return amount;
    }

    public static int modifyUseDuration(int originalDuration, class_1799 item, class_1309 entity) {
        if (originalDuration <= 0) {
            return originalDuration;
        }
        if (item.method_7976() == class_1839.field_8950) {
            return (int)Math.max(1L, Math.round((double)originalDuration / entity.method_45325(ModAttributes.EATING_SPEED)));
        }
        if (item.method_7976() == class_1839.field_8946) {
            return (int)Math.max(1L, Math.round((double)originalDuration / entity.method_45325(ModAttributes.DRINKING_SPEED)));
        }
        return originalDuration;
    }

    public static int modifyExperience(int originalXp, class_1309 entity, class_1657 attacker) {
        if (attacker == null || entity instanceof class_1657 || originalXp <= 0) {
            return originalXp;
        }
        double multiplier = attacker.method_45325(ModAttributes.ENTITY_EXPERIENCE);
        int droppedXp = (int)Math.round((double)originalXp * multiplier);
        return Math.max(0, droppedXp);
    }

    public static void absorbDamage(class_1309 entity, class_1282 damageSource, float amount) {
        class_1309 attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && DamageSourceHelper.isMeleeAttack(damageSource)) {
            AbilityHelper.forEach((ArtifactAbility.Type)ModAbilities.ATTACKS_ABSORB_DAMAGE.comp_349(), attacker, ability -> {
                float damageDealt;
                double absorptionRatio = (Double)ability.absorptionRatio().get();
                double maxHealthAbsorbed = ((Integer)ability.maxDamageAbsorbed().get()).intValue();
                float damageAbsorbed = (float)Math.min(maxHealthAbsorbed, absorptionRatio * (double)(damageDealt = Math.min(amount, entity.method_6032())));
                if (damageAbsorbed > 0.0f && (Double)ability.absorptionChance().get() > entity.method_59922().method_43058()) {
                    attacker.method_6025(damageAbsorbed);
                }
            });
        }
    }

    public static float getModifiedFriction(float friction, class_1309 entity, class_2248 block) {
        if (ModTags.isInTag(block, class_3481.field_15467) && friction > 0.6f) {
            double slipperinessReduction = entity.method_45325(ModAttributes.SLIP_RESISTANCE);
            return class_3532.method_16439((float)((float)slipperinessReduction), (float)friction, (float)0.6f);
        }
        return friction;
    }

    public static void applyBoneMealAfterEating(class_1309 entity, class_4174 properties) {
        if (!entity.method_37908().method_8608() && AbilityHelper.hasAbilityActive((ArtifactAbility.Type)ModAbilities.GROW_PLANTS_AFTER_EATING.comp_349(), entity) && properties.comp_2491() > 0 && !properties.comp_2493() && entity.method_24828() && entity.method_25936().method_26164(ModTags.ROOTED_BOOTS_GRASS)) {
            class_1752.method_7720((class_1799)new class_1799((class_1935)class_1802.field_8324), (class_1937)entity.method_37908(), (class_2338)entity.method_23312());
        }
    }
}

