/*
 * Decompiled with CFR 0.152.
 */
package artifacts.integration;

import artifacts.integration.EquipmentIntegration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class EquipmentIntegrationUtils {
    private static final Map<String, EquipmentIntegration> INTEGRATIONS = new LinkedHashMap<String, EquipmentIntegration>();

    @Nullable
    public static EquipmentIntegration getIntegration(String name) {
        return INTEGRATIONS.get(name);
    }

    public static void setupIntegrations() {
        INTEGRATIONS.values().forEach(EquipmentIntegration::setup);
    }

    public static void registerIntegration(EquipmentIntegration integration) {
        String name = integration.name();
        if (INTEGRATIONS.containsKey(name)) {
            throw new IllegalStateException("Duplicate Equipment Integration detected! [Name: " + name + "]");
        }
        INTEGRATIONS.put(name, integration);
    }

    public static Stream<class_1799> findAllEquippedBy(class_1309 entity, Predicate<class_1799> predicate) {
        Stream<class_1799> allEquippedStacks = Stream.of(new class_1799[0]);
        for (EquipmentIntegration integration : INTEGRATIONS.values()) {
            allEquippedStacks = Stream.concat(allEquippedStacks, integration.findAllEquippedBy(entity, predicate));
        }
        return allEquippedStacks;
    }

    public static void iterateEquippedAccessories(class_1309 entity, Consumer<class_1799> consumer) {
        for (EquipmentIntegration integration : INTEGRATIONS.values()) {
            integration.iterateEquippedAccessories(entity, consumer);
        }
    }

    public static <T> T reduceAccessories(class_1309 entity, T init, BiFunction<class_1799, T, T> f) {
        for (EquipmentIntegration integration : INTEGRATIONS.values()) {
            init = integration.reduceAccessories(entity, init, f);
        }
        return init;
    }

    public static boolean equipAccessory(class_1309 entity, class_1799 stack) {
        for (EquipmentIntegration integration : INTEGRATIONS.values()) {
            if (!integration.equipAccessory(entity, stack)) continue;
            return true;
        }
        return false;
    }
}

