/*
 * Decompiled with CFR 0.152.
 */
package artifacts.integration.client;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.integration.client.ClientEquipmentIntegration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class ClientEquipmentIntegrationUtils {
    private static final Map<String, ClientEquipmentIntegration> INTEGRATIONS = new LinkedHashMap<String, ClientEquipmentIntegration>();

    public static void registerIntegration(ClientEquipmentIntegration integration) {
        String name = integration.name();
        if (INTEGRATIONS.containsKey(name)) {
            throw new IllegalStateException("Duplicate Client Equipment Integration detected! [Name: " + name + "]");
        }
        INTEGRATIONS.put(name, integration);
    }

    public static boolean hasIntegration(String name) {
        return INTEGRATIONS.containsKey(name);
    }

    public static void registerArtifactRenderer(class_1792 item, Supplier<ArtifactRenderer> rendererSupplier) {
        for (ClientEquipmentIntegration value : INTEGRATIONS.values()) {
            value.registerArtifactRenderer(item, rendererSupplier);
        }
    }

    @Nullable
    public static ArtifactRenderer getArtifactRenderer(class_1792 item) {
        for (ClientEquipmentIntegration value : INTEGRATIONS.values()) {
            ArtifactRenderer renderer = value.getArtifactRenderer(item);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    public static void renderArm(class_4587 matrixStack, class_4597 buffer, int light, class_742 player, class_1306 side) {
        for (ClientEquipmentIntegration integration : INTEGRATIONS.values()) {
            integration.renderArm(matrixStack, buffer, light, player, side);
        }
    }
}

