/*
 * Decompiled with CFR 0.152.
 */
package artifacts.integration.impl.accessories;

import artifacts.event.ArtifactEvents;
import artifacts.integration.EquipmentIntegration;
import artifacts.item.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import artifacts.util.DamageSourceHelper;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.EquipAction;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import it.unimi.dsi.fastutil.Pair;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import net.minecraft.class_9334;

public class AccessoriesIntegration
implements EquipmentIntegration {
    @Override
    public void setup() {
        PlatformServices.platformHelper.registryEntryAddCallback(item -> {
            if (item instanceof WearableArtifactItem) {
                WearableArtifactItem wearableArtifactItem = (WearableArtifactItem)((Object)item);
                AccessoriesAPI.registerAccessory((class_1792)item, (Accessory)new WearableArtifactAccessory(wearableArtifactItem));
            }
        });
        AccessoryChangeCallback.EVENT.register((prevStack, currentStack, slotReference, slotStateChange) -> ArtifactEvents.onItemChanged(slotReference.entity(), prevStack, currentStack));
    }

    @Override
    public Stream<class_1799> findAllEquippedBy(class_1309 entity, Predicate<class_1799> predicate) {
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)entity);
        Stream<class_1799> stacks = Stream.empty();
        if (capability != null) {
            stacks = capability.getEquipped(predicate).stream().map(SlotEntryReference::stack);
        }
        return stacks;
    }

    @Override
    public void iterateEquippedAccessories(class_1309 entity, Consumer<class_1799> consumer) {
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)entity);
        if (capability != null) {
            capability.getAllEquipped().forEach(slotEntryReference -> consumer.accept(slotEntryReference.stack()));
        }
    }

    @Override
    public <T> T reduceAccessories(class_1309 entity, T init, BiFunction<class_1799, T, T> f) {
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)entity);
        if (capability != null) {
            for (SlotEntryReference slotEntryReference : capability.getAllEquipped()) {
                init = f.apply(slotEntryReference.stack(), (class_1799)init);
            }
        }
        return init;
    }

    @Override
    public boolean equipAccessory(class_1309 entity, class_1799 stack) {
        Pair possibleLocation;
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)entity);
        if (capability != null && (possibleLocation = capability.canEquipAccessory(stack, false)) != null) {
            ((EquipAction)possibleLocation.second()).equipStack(stack);
            return true;
        }
        return false;
    }

    @Override
    public String name() {
        return "accessories";
    }

    public record WearableArtifactAccessory(WearableArtifactItem item) implements Accessory
    {
        public DropRule getDropRule(class_1799 stack, SlotReference reference, class_1282 source) {
            if (DamageSourceHelper.shouldDestroyWornItemsOnDeath(reference.entity())) {
                return DropRule.DESTROY;
            }
            return super.getDropRule(stack, reference, source);
        }

        public SoundEventData getEquipSound(class_1799 stack, SlotReference reference) {
            return new SoundEventData(class_6880.method_40223((Object)this.item.getEquipSound()), 1.0f, this.item.getEquipSoundPitch());
        }

        public boolean canEquipFromUse(class_1799 stack) {
            return stack.method_57824(class_9334.field_50075) == null;
        }
    }
}

