/*
 * Decompiled with CFR 0.152.
 */
package artifacts.integration.impl.trinkets;

import artifacts.event.ArtifactEvents;
import artifacts.integration.EquipmentIntegration;
import artifacts.item.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import artifacts.util.DamageSourceHelper;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.event.TrinketEquipCallback;
import dev.emi.trinkets.api.event.TrinketUnequipCallback;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3545;

public class TrinketsIntegration
implements EquipmentIntegration {
    @Override
    public void setup() {
        PlatformServices.platformHelper.registryEntryAddCallback(item -> {
            if (item instanceof WearableArtifactItem) {
                WearableArtifactItem wearableArtifactItem = (WearableArtifactItem)((Object)item);
                TrinketsApi.registerTrinket((class_1792)item, (Trinket)new WearableArtifactTrinket(wearableArtifactItem));
            }
        });
        TrinketEquipCallback.EVENT.register((stack, slot, entity) -> ArtifactEvents.onItemChanged(entity, class_1799.field_8037, stack));
        TrinketUnequipCallback.EVENT.register((stack, slot, entity) -> ArtifactEvents.onItemChanged(entity, stack, class_1799.field_8037));
    }

    @Override
    public Stream<class_1799> findAllEquippedBy(class_1309 entity, Predicate<class_1799> predicate) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).map(TrinketComponent::getAllEquipped).orElse(List.of()).stream().map(class_3545::method_15441);
    }

    @Override
    public void iterateEquippedAccessories(class_1309 entity, Consumer<class_1799> consumer) {
        TrinketsApi.getTrinketComponent((class_1309)entity).ifPresent(component -> {
            for (Map map : component.getInventory().values()) {
                for (TrinketInventory inventory : map.values()) {
                    for (int i = 0; i < inventory.method_5439(); ++i) {
                        class_1799 item = inventory.method_5438(i);
                        if (item.method_7960()) continue;
                        consumer.accept(item);
                    }
                }
            }
        });
    }

    @Override
    public <T> T reduceAccessories(class_1309 entity, T init, BiFunction<class_1799, T, T> f) {
        Optional component = TrinketsApi.getTrinketComponent((class_1309)entity);
        if (component.isPresent()) {
            for (Map map : ((TrinketComponent)component.get()).getInventory().values()) {
                for (TrinketInventory inventory : map.values()) {
                    for (int i = 0; i < inventory.method_5439(); ++i) {
                        class_1799 item = inventory.method_5438(i);
                        if (item.method_7960()) continue;
                        init = f.apply(item, (class_1799)init);
                    }
                }
            }
        }
        return init;
    }

    @Override
    public boolean equipAccessory(class_1309 entity, class_1799 stack) {
        return TrinketItem.equipItem((class_1309)entity, (class_1799)stack);
    }

    @Override
    public String name() {
        return "trinkets";
    }

    public record WearableArtifactTrinket(WearableArtifactItem item) implements Trinket
    {
        public TrinketEnums.DropRule getDropRule(class_1799 stack, SlotReference slot, class_1309 entity) {
            if (DamageSourceHelper.shouldDestroyWornItemsOnDeath(entity)) {
                return TrinketEnums.DropRule.DESTROY;
            }
            return super.getDropRule(stack, slot, entity);
        }
    }
}

