/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item;

import artifacts.Artifacts;
import artifacts.ability.ArtifactAbility;
import artifacts.ability.AttributeModifierAbility;
import artifacts.ability.IncreaseEnchantmentLevelAbility;
import artifacts.config.value.Value;
import artifacts.integration.EquipmentIntegration;
import artifacts.integration.EquipmentIntegrationUtils;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class WearableArtifactItem
extends class_1792 {
    private final class_6880<class_3414> equipSound;
    private final float equipSoundPitch;

    public WearableArtifactItem(class_1792.class_1793 properties, class_6880<class_3414> equipSound, float equipSoundPitch) {
        super(properties);
        this.equipSound = equipSound;
        this.equipSoundPitch = equipSoundPitch;
    }

    public class_3414 getEquipSound() {
        return (class_3414)this.equipSound.comp_349();
    }

    public float getEquipSoundPitch() {
        return this.equipSoundPitch;
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> list, class_1836 tooltipFlag) {
        if (Artifacts.CONFIG.client.showTooltips.get().booleanValue() && !PlatformServices.platformHelper.isModLoaded("curios") && !PlatformServices.platformHelper.isModLoaded("trinkets") && !PlatformServices.platformHelper.isModLoaded("accessories")) {
            list.add((class_2561)class_2561.method_43471((String)"%s.tooltip.missing_dependency".formatted("artifacts")).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        } else {
            super.method_7851(itemStack, tooltipContext, list, tooltipFlag);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        EquipmentIntegration integration = EquipmentIntegrationUtils.getIntegration("trinkets");
        if (!stack.method_57826(class_9334.field_50075) && integration != null && integration.equipAccessory((class_1309)player, stack)) {
            player.method_5783(this.getEquipSound(), 1.0f, this.getEquipSoundPitch());
            return class_1271.method_29237((Object)stack, (boolean)level.method_8608());
        }
        return super.method_7836(level, player, hand);
    }

    public static class Builder {
        private final String itemName;
        private class_6880<class_3414> equipSound = class_3417.field_14883;
        private float equipSoundPitch = 1.0f;
        private final List<ArtifactAbility> abilities = new ArrayList<ArtifactAbility>();
        private final class_1792.class_1793 properties = new class_1792.class_1793();

        public Builder(String itemName) {
            this.itemName = itemName;
        }

        public Builder equipSound(class_3414 equipSound) {
            return this.equipSound((class_6880<class_3414>)class_7923.field_41172.method_47983((Object)equipSound));
        }

        public Builder equipSound(class_6880<class_3414> equipSound) {
            this.equipSound = equipSound;
            return this;
        }

        public Builder equipSoundPitch(float pitch) {
            this.equipSoundPitch = pitch;
            return this;
        }

        public Builder addAttributeModifier(class_6880<class_1320> attribute, Value<Double> amount, class_1322.class_1323 operation) {
            return this.addAttributeModifier(attribute, amount, operation, true);
        }

        public Builder addAttributeModifier(class_6880<class_1320> attribute, Value<Double> amount, class_1322.class_1323 operation, boolean ignoreCooldown) {
            return this.addAbility(new AttributeModifierAbility(attribute, amount, operation, Artifacts.id(this.itemName + "/" + ((class_5321)attribute.method_40230().orElseThrow()).method_29177().method_12832()), ignoreCooldown));
        }

        public Builder increasesEnchantment(class_5321<class_1887> enchantment, Value<Integer> amount) {
            return this.addAbility(new IncreaseEnchantmentLevelAbility(enchantment, amount));
        }

        public Builder addAbility(ArtifactAbility ability) {
            this.abilities.add(ability);
            return this;
        }

        public Builder properties(Consumer<class_1792.class_1793> consumer) {
            consumer.accept(this.properties);
            return this;
        }

        public WearableArtifactItem build() {
            this.properties.arch$tab(ModItems.CREATIVE_TAB);
            this.properties.method_57349((class_9331)ModDataComponents.ABILITIES.comp_349(), this.abilities);
            this.properties.method_7889(1).method_7894(class_1814.field_8903).method_24359();
            return new WearableArtifactItem(this.properties, this.equipSound, this.equipSoundPitch);
        }
    }
}

