/*
 * Decompiled with CFR 0.152.
 */
package com.nopoisonregen;

import com.nopoisonregen.Constants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class CommonClass {
    public static final Map<class_6880<class_1291>, class_6880<class_1291>> cancelableEffectMap = new HashMap<class_6880<class_1291>, class_6880<class_1291>>();

    public static void refreshCache(List<? extends String> cancelableEffects) {
        Constants.LOGGER.info("Refreshing NMPR canceling effects");
        cancelableEffectMap.clear();
        for (String string : cancelableEffects) {
            String[] values;
            if (!string.contains(",") || (values = string.split(",")).length != 2) continue;
            String value1 = values[0];
            class_2960 location1 = class_2960.method_12829((String)value1);
            String value2 = values[1];
            class_2960 location2 = class_2960.method_12829((String)value2);
            if (location1 == null || location2 == null) continue;
            class_6880 effect1 = class_7923.field_41174.method_55841(location1).orElse(null);
            class_6880 effect2 = class_7923.field_41174.method_55841(location2).orElse(null);
            if (effect1 == null || effect2 == null) continue;
            cancelableEffectMap.put((class_6880<class_1291>)effect1, (class_6880<class_1291>)effect2);
        }
    }

    public static boolean isEffectApplicable(class_1293 effectInstance, class_1309 livingEntity) {
        class_1291 applicableEffect = (class_1291)effectInstance.method_5579().comp_349();
        class_1937 level = livingEntity.method_37908();
        if (!level.field_9236 && !cancelableEffectMap.isEmpty()) {
            for (Map.Entry<class_6880<class_1291>, class_6880<class_1291>> entry : cancelableEffectMap.entrySet()) {
                class_1293 instance1;
                int secondEffectTime;
                int firstEffectTime;
                int remainingTime;
                class_6880<class_1291> effect1 = entry.getKey();
                class_6880<class_1291> effect2 = entry.getValue();
                if (effect1 == null || effect2 == null) continue;
                if (effect1 == applicableEffect && livingEntity.method_6059(effect2)) {
                    class_1293 instance2 = livingEntity.method_6112(effect2);
                    if (instance2 == null || (remainingTime = (firstEffectTime = instance2.method_5584() * (instance2.method_5578() + 1)) - (secondEffectTime = effectInstance.method_5584() * (effectInstance.method_5578() + 1))) != 0) continue;
                    livingEntity.method_6016(effect2);
                    return false;
                }
                if (effect2 != applicableEffect || !livingEntity.method_6059(effect1) || (instance1 = livingEntity.method_6112(effect1)) == null || (remainingTime = (firstEffectTime = instance1.method_5584() * (instance1.method_5578() + 1)) - (secondEffectTime = effectInstance.method_5584() * (effectInstance.method_5578() + 1))) != 0) continue;
                livingEntity.method_6016(effect1);
                return false;
            }
        }
        return true;
    }

    public static void onLivingTick(class_1309 livingEntity) {
        class_1937 level = livingEntity.method_37908();
        if (!level.field_9236 && level.method_8510() % 20L == 0L && !cancelableEffectMap.isEmpty()) {
            for (Map.Entry<class_6880<class_1291>, class_6880<class_1291>> entry : cancelableEffectMap.entrySet()) {
                class_6880<class_1291> effect1 = entry.getKey();
                class_6880<class_1291> effect2 = entry.getValue();
                if (effect1 == null || effect2 == null || !livingEntity.method_6059(effect1) || !livingEntity.method_6059(effect2)) continue;
                class_1293 instance1 = livingEntity.method_6112(effect1);
                class_1293 instance2 = livingEntity.method_6112(effect2);
                if (instance1 == null || instance2 == null) continue;
                int firstEffectTime = instance1.method_5584() * (instance1.method_5578() + 1);
                int secondEffectTime = instance2.method_5584() * (instance2.method_5578() + 1);
                int remainingTime = firstEffectTime - secondEffectTime;
                livingEntity.method_6016(effect1);
                livingEntity.method_6016(effect2);
                if (remainingTime < 0) {
                    livingEntity.method_6092(new class_1293(effect2, -remainingTime));
                    continue;
                }
                if (remainingTime <= 0) continue;
                livingEntity.method_6092(new class_1293(effect1, remainingTime));
            }
        }
    }
}

