/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils;

import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_4135;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static <T> boolean iteratePage(List<T> list, int page, int pageSize, BiConsumer<T, Integer> consumer) {
        int index = Util.getIndex(page, pageSize);
        int toIndex = Math.min(index + pageSize, list.size());
        if (toIndex <= index) {
            return false;
        }
        for (T value : list.subList(index, toIndex)) {
            consumer.accept(value, ++index);
        }
        return true;
    }

    public static int getIndex(int page, int pageSize) {
        return pageSize * (page - 1);
    }

    public static int getPage(int index, int pageSize) {
        return (index + pageSize - 1) / pageSize;
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> sortByValue(Map<K, V> map) {
        ObjectArrayList entries = new ObjectArrayList(map.entrySet());
        entries.sort((c1, c2) -> ((Comparable)c2.getValue()).compareTo((Comparable)c1.getValue()));
        return entries;
    }

    public static CompletableFuture<Suggestions> suggestAll(SuggestionsBuilder builder, String ... suggestions) {
        for (String suggestion : suggestions) {
            builder.suggest(suggestion);
        }
        return builder.buildFuture();
    }

    public static boolean hasTasks(class_1355 selector) {
        return Util.hasTasks(selector, null);
    }

    public static boolean hasTasks(class_1355 selector, @Nullable Predicate<class_1352> predicate) {
        for (class_4135 wrapped : selector.method_35115()) {
            if (!wrapped.method_19056() || predicate != null && !predicate.test(wrapped.method_19058())) continue;
            return true;
        }
        return false;
    }

    public static <T, R> ObjectArrayList<R> map(Collection<T> collection, Function<T, R> function) {
        ObjectArrayList result = new ObjectArrayList(collection.size());
        for (T value : collection) {
            R mapped = function.apply(value);
            if (mapped == null) continue;
            result.add(mapped);
        }
        return result;
    }
}

