/*
 * Decompiled with CFR 0.152.
 */
package net.snackbag.tt20.util;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.snackbag.tt20.TT20;
import net.snackbag.tt20.config.JSONConfiguration;
import net.snackbag.tt20.util.MaskType;
import net.snackbag.tt20.util.RegistryIndex;

public class Mask {
    private final JSONConfiguration file;
    private final MaskType maskType;
    private final class_2378<?> registry;
    private final RegistryIndex index;
    private final Set<class_2960> entries;

    public Mask(class_2378<?> registry, JSONConfiguration file, String maskKey) {
        this.file = file;
        this.maskType = MaskType.fromString(file.getAsString("type"));
        this.registry = registry;
        this.index = RegistryIndex.getIndex(this.registry);
        this.entries = new HashSet<class_2960>();
        for (JsonElement element : file.getAsArray(maskKey)) {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                TT20.LOGGER.error("(TT20) Mask element '" + String.valueOf(element) + "' isn't a string");
                return;
            }
            this.entries.addAll(this.manageEntry(element.getAsString()));
        }
    }

    public List<class_2960> manageEntry(String entry) {
        String[] split = entry.split(":");
        if (split.length != 2) {
            TT20.LOGGER.error("(TT20) '" + entry + "' is not a valid identifier. Correct format is <namespace>:<path>");
            return new ArrayList<class_2960>();
        }
        if (split[0].equals("*") && split[1].equals("*")) {
            return this.index.getIdentifiers();
        }
        if (!split[0].equals("*") && !split[1].equals("*")) {
            return List.of(class_2960.method_60655((String)split[0], (String)split[1]));
        }
        if (split[0].equals("*") && !split[1].equals("*")) {
            return this.index.getPathIndex().getOrDefault(split[1], new ArrayList());
        }
        if (!split[0].equals("*") && split[1].equals("*")) {
            return this.index.getNamespaceIndex().getOrDefault(split[0], new ArrayList());
        }
        return null;
    }

    public class_2378<?> getRegistry() {
        return this.registry;
    }

    public JSONConfiguration getFile() {
        return this.file;
    }

    public boolean matches(class_2960 identifier) {
        return this.entries.contains(identifier);
    }

    public boolean isOkay(class_2960 identifier) {
        if (this.maskType == MaskType.WHITELIST) {
            return this.entries.contains(identifier);
        }
        return !this.entries.contains(identifier);
    }
}

