/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.recipe;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.EmiRecipeCategoryProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

public class EmiRecipeCategory
implements EmiRenderable {
    public class_2960 id;
    public EmiRenderable icon;
    public EmiRenderable simplified;
    public Comparator<EmiRecipe> sorter;

    public EmiRecipeCategory(class_2960 id, EmiRenderable icon) {
        this(id, icon, icon);
    }

    public EmiRecipeCategory(class_2960 id, EmiRenderable icon, EmiRenderable simplified) {
        this(id, icon, simplified, EmiRecipeSorting.none());
    }

    public EmiRecipeCategory(class_2960 id, EmiRenderable icon, EmiRenderable simplified, Comparator<EmiRecipe> sorter) {
        this.id = id;
        this.icon = icon;
        this.simplified = simplified;
        this.sorter = sorter;
    }

    public class_2561 getName() {
        return EmiPort.translatable(EmiUtil.translateId("emi.category.", this.getId()));
    }

    public class_2960 getId() {
        return this.id;
    }

    @Override
    public void render(class_332 draw, int x, int y, float delta) {
        EmiRecipeCategoryProperties.getIcon(this).render(draw, x, y, delta);
    }

    public void renderSimplified(class_332 draw, int x, int y, float delta) {
        EmiRecipeCategoryProperties.getSimplifiedIcon(this).render(draw, x, y, delta);
    }

    public List<class_5684> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.add(class_5684.method_32662((class_5481)EmiPort.ordered(this.getName())));
        if (EmiUtil.showAdvancedTooltips()) {
            list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.literal(this.id.toString(), class_124.field_1063))));
        }
        if (EmiConfig.appendModId) {
            list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.literal(EmiUtil.getModName(this.getId().method_12836()), class_124.field_1078, class_124.field_1056))));
        }
        return list;
    }

    @Nullable
    public Comparator<EmiRecipe> getSort() {
        return this.sorter;
    }
}

