/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.emi.emi.EmiPort;
import dev.emi.emi.data.EmiResourceReloadListener;
import dev.emi.emi.runtime.EmiLog;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class EmiDataLoader<T>
extends class_4080<T>
implements EmiResourceReloadListener {
    private static final Gson GSON = new Gson();
    private final class_2960 id;
    private final String path;
    private final Supplier<T> baseSupplier;
    private final DataConsumer<T> prepare;
    private final Consumer<T> apply;

    public EmiDataLoader(class_2960 id, String path, Supplier<T> baseSupplier, DataConsumer<T> prepare, Consumer<T> apply) {
        this.id = id;
        this.path = path;
        this.baseSupplier = baseSupplier;
        this.prepare = prepare;
        this.apply = apply;
    }

    public T method_18789(class_3300 manager, class_3695 profiler) {
        T t = this.baseSupplier.get();
        for (class_2960 id : EmiPort.findResources(manager, this.path, i -> i.endsWith(".json"))) {
            if (!id.method_12836().equals("emi")) continue;
            for (class_3298 resource : manager.method_14489(id)) {
                try {
                    InputStreamReader reader = new InputStreamReader(EmiPort.getInputStream(resource));
                    JsonObject json = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    this.prepare.accept(t, json, id);
                }
                catch (Exception e) {
                    EmiLog.error("Error loading data for " + String.valueOf(this.id) + " in " + String.valueOf(id));
                    e.printStackTrace();
                }
            }
        }
        return t;
    }

    public void method_18788(T t, class_3300 manager, class_3695 profiler) {
        this.apply.accept(t);
    }

    @Override
    public class_2960 getEmiId() {
        return this.id;
    }

    public static interface DataConsumer<T> {
        public void accept(T var1, JsonObject var2, class_2960 var3);
    }
}

