/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_9283;
import net.minecraft.class_9334;

public class EmiFireworkStarRecipe
extends EmiPatternCraftingRecipe {
    private static final List<class_1769> DYES = Stream.of(class_1767.values()).map(class_1769::method_7803).toList();
    private static final List<class_1792> SHAPES = List.of(class_1802.field_8814, class_1802.field_8153, class_1802.field_8397, class_1802.field_8398, class_1802.field_8791, class_1802.field_8681, class_1802.field_8575, class_1802.field_8712, class_1802.field_8470);
    private static final List<class_1792> EFFECTS = List.of(class_1802.field_8477, class_1802.field_8601);

    public EmiFireworkStarRecipe(class_2960 id) {
        super(List.of(EmiIngredient.of(DYES.stream().map(i -> EmiStack.of((class_1935)i)).collect(Collectors.toList())), EmiIngredient.of(SHAPES.stream().map(i -> EmiStack.of((class_1935)i)).collect(Collectors.toList())), EmiIngredient.of(EFFECTS.stream().map(i -> EmiStack.of((class_1935)i)).collect(Collectors.toList())), EmiStack.of((class_1935)class_1802.field_8054)), EmiStack.of((class_1935)class_1802.field_8450), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(EmiStack.of((class_1935)class_1802.field_8054), x, y);
        }
        int s = slot - 1;
        return new GeneratedSlotWidget(r -> {
            List<class_1792> items = this.getItems((Random)r);
            if (s < items.size()) {
                return EmiStack.of((class_1935)items.get(s));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(this::getFireworkStar, this.unique, x, y);
    }

    private List<class_1769> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private List<class_1792> getItems(Random random) {
        ArrayList items = Lists.newArrayList();
        int amount = random.nextInt(4);
        if (amount < 2) {
            items.add(EFFECTS.get(amount));
        } else if (amount == 2) {
            items.add(EFFECTS.get(0));
            items.add(EFFECTS.get(1));
        }
        amount = random.nextInt(10);
        if (amount < 9) {
            items.add(SHAPES.get(amount));
        }
        items.addAll(this.getDyes(random, 8 - items.size()));
        return items;
    }

    private EmiStack getFireworkStar(Random random) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8450);
        List<class_1792> items = this.getItems(random);
        class_9283.class_1782 type = class_9283.class_1782.field_7976;
        IntArrayList colors = new IntArrayList();
        boolean flicker = false;
        boolean trail = false;
        for (class_1792 item : items) {
            if (class_1802.field_8601.equals(item)) {
                flicker = true;
                continue;
            }
            if (class_1802.field_8477.equals(item)) {
                trail = true;
                continue;
            }
            if (class_1802.field_8814.equals(item)) {
                type = class_9283.class_1782.field_7977;
                continue;
            }
            if (class_1802.field_8397.equals(item)) {
                type = class_9283.class_1782.field_7973;
                continue;
            }
            if (class_1802.field_8153.equals(item)) {
                type = class_9283.class_1782.field_7970;
                continue;
            }
            if (SHAPES.contains(item)) {
                type = class_9283.class_1782.field_7974;
                continue;
            }
            class_1769 dyeItem = (class_1769)item;
            colors.add(dyeItem.method_7802().method_7790());
        }
        stack.method_57379(class_9334.field_49615, (Object)new class_9283(type, (IntList)colors, IntList.of(), trail, flicker));
        return EmiStack.of(stack);
    }
}

