/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9636;

public class EmiGrindstoneDisenchantingRecipe
implements EmiRecipe {
    private static final class_2960 BACKGROUND = EmiPort.id("minecraft", "textures/gui/container/grindstone.png");
    private final int uniq = EmiUtil.RANDOM.nextInt();
    private final class_1792 tool;
    private final class_2960 id;

    public EmiGrindstoneDisenchantingRecipe(class_1792 tool, class_2960 id) {
        this.tool = tool;
        this.id = id;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.GRINDING;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of((class_1935)this.tool));
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((class_1935)this.tool));
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }

    @Override
    public int getDisplayWidth() {
        return 116;
    }

    @Override
    public int getDisplayHeight() {
        return 56;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, 116, 56, 30, 15);
        widgets.addGeneratedSlot(r -> this.getTool((Random)r, true), this.uniq, 18, 3).drawBack(false);
        widgets.addGeneratedSlot(r -> this.getTool((Random)r, false), this.uniq, 98, 18).drawBack(false).recipeContext(this);
    }

    private EmiStack getTool(Random random, Boolean enchanted) {
        class_1799 itemStack = new class_1799((class_1935)this.tool);
        int enchantments = 1 + Math.max(random.nextInt(5), random.nextInt(3));
        ArrayList list = Lists.newArrayList();
        block0: for (int i = 0; i < enchantments; ++i) {
            int lvl;
            class_1887 enchantment = this.getEnchantment(random);
            int maxLvl = enchantment.method_8183();
            int minLvl = enchantment.method_8187();
            int n = lvl = maxLvl > 0 ? random.nextInt(maxLvl) + 1 : 0;
            if (lvl < minLvl) {
                lvl = minLvl;
            }
            for (class_1887 e : list) {
                if (e != enchantment && class_1887.method_60033((class_6880)EmiPort.getEnchantmentRegistry().method_47983((Object)e), (class_6880)EmiPort.getEnchantmentRegistry().method_47983((Object)enchantment))) continue;
                continue block0;
            }
            list.add(enchantment);
            if (EmiPort.getEnchantmentRegistry().method_47983((Object)enchantment).method_40220(class_9636.field_51551)) {
                itemStack.method_7978(EmiPort.getEnchantmentRegistry().method_47983((Object)enchantment), lvl);
                continue;
            }
            if (!enchanted.booleanValue()) continue;
            itemStack.method_7978(EmiPort.getEnchantmentRegistry().method_47983((Object)enchantment), lvl);
        }
        return EmiStack.of(itemStack);
    }

    private class_1887 getEnchantment(Random random) {
        List<class_1887> enchantments = EmiPort.getEnchantmentRegistry().method_10220().filter(i -> i.method_8192(this.tool.method_7854())).toList();
        int enchantment = random.nextInt(enchantments.size());
        return enchantments.get(enchantment);
    }
}

