/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.chess.EmiChess;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.SidebarType;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiFavorite;
import dev.emi.emi.runtime.EmiFavorites;
import dev.emi.emi.runtime.EmiPersistentData;
import dev.emi.emi.screen.EmiScreenManager;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class EmiSidebars {
    public static List<EmiIngredient> craftables = List.of();
    public static List<EmiIngredient> lookupHistory = Lists.newArrayList();
    public static List<EmiIngredient> craftHistory = Lists.newArrayList();

    public static List<? extends EmiIngredient> getStacks(SidebarType type) {
        return switch (type) {
            case SidebarType.INDEX -> {
                if (EmiConfig.editMode) {
                    yield EmiStackList.stacks;
                }
                yield EmiStackList.filteredStacks;
            }
            case SidebarType.CRAFTABLES -> craftables;
            case SidebarType.FAVORITES -> EmiFavorites.favoriteSidebar;
            case SidebarType.LOOKUP_HISTORY -> lookupHistory;
            case SidebarType.CRAFT_HISTORY -> craftHistory;
            case SidebarType.CHESS -> EmiChess.SIDEBAR;
            default -> List.of();
        };
    }

    public static void lookup(EmiIngredient stack) {
        if (!stack.isEmpty()) {
            if (lookupHistory.size() >= 1 && lookupHistory.get(0).equals(stack)) {
                return;
            }
            lookupHistory.remove(stack);
            lookupHistory.add(0, stack);
            EmiPersistentData.save();
            EmiScreenManager.repopulatePanels(SidebarType.LOOKUP_HISTORY);
        }
    }

    public static void craft(EmiRecipe recipe) {
        if (!recipe.getOutputs().isEmpty()) {
            if (craftHistory.size() >= 1 && EmiApi.getRecipeContext(craftHistory.get(0)).equals(recipe)) {
                return;
            }
            EmiFavorite.Craftable stack = new EmiFavorite.Craftable(recipe);
            craftHistory.removeIf(i -> {
                EmiFavorite.Craftable c;
                return i instanceof EmiFavorite.Craftable && (c = (EmiFavorite.Craftable)i).getRecipe().equals(recipe);
            });
            craftHistory.add(0, stack);
            EmiPersistentData.save();
            EmiScreenManager.repopulatePanels(SidebarType.CRAFT_HISTORY);
        }
    }

    public static void save(JsonObject json) {
        EmiIngredient stack;
        int i;
        JsonArray arr = new JsonArray();
        for (i = 0; i < 1024 && i < lookupHistory.size(); ++i) {
            stack = lookupHistory.get(i);
            JsonElement el = EmiIngredientSerializer.getSerialized(stack);
            if (el == null || el.isJsonNull()) continue;
            arr.add(el);
        }
        json.add("lookup_history", (JsonElement)arr);
        arr = new JsonArray();
        for (i = 0; i < 1024 && i < craftHistory.size(); ++i) {
            stack = craftHistory.get(i);
            EmiRecipe recipe = EmiApi.getRecipeContext(stack);
            if (recipe == null || recipe.getId() == null) continue;
            arr.add(recipe.getId().toString());
        }
        json.add("craft_history", (JsonElement)arr);
    }

    public static void load(JsonObject json) {
        lookupHistory.clear();
        if (class_3518.method_15264((JsonObject)json, (String)"lookup_history")) {
            for (JsonElement el : class_3518.method_15261((JsonObject)json, (String)"lookup_history")) {
                EmiIngredient stack = EmiIngredientSerializer.getDeserialized(el);
                if (stack.isEmpty()) continue;
                lookupHistory.add(stack);
            }
        }
        craftHistory.clear();
        if (class_3518.method_15264((JsonObject)json, (String)"craft_history")) {
            for (JsonElement el : class_3518.method_15261((JsonObject)json, (String)"craft_history")) {
                String s;
                class_2960 class_29602;
                if (!class_3518.method_15286((JsonElement)el) || !((class_29602 = class_2960.method_12829((String)(s = el.getAsString()))) instanceof class_2960)) continue;
                class_2960 id = class_29602;
                EmiRecipe recipe = EmiApi.getRecipeManager().getRecipe(id);
                if (recipe == null) continue;
                craftHistory.add(new EmiFavorite.Craftable(recipe));
            }
        }
    }
}

