/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiLog;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_777;
import net.minecraft.class_8251;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class StackBatcher {
    private static MethodHandle sodiumSpriteHandle;
    private final BatcherVertexConsumerProvider imm;
    private final class_4597 unlitFacade;
    private final Map<class_1921, class_291> buffers = new LinkedHashMap<class_1921, class_291>();
    private final Set<class_1058> spritesToUpdate = Sets.newHashSet();
    private boolean populated = false;
    private boolean dirty = false;
    private int x;
    private int y;
    private int z;
    public static final List<class_1921> EXTRA_RENDER_LAYERS;

    public static boolean isEnabled() {
        return EmiConfig.useBatchedRenderer;
    }

    public StackBatcher() {
        HashMap<class_1921, class_9799> buffers = new HashMap<class_1921, class_9799>();
        this.assign(buffers, class_1921.method_23577());
        this.assign(buffers, class_1921.method_23581());
        this.assign(buffers, class_1921.method_23583());
        this.assign(buffers, class_4722.method_24073());
        this.assign(buffers, class_4722.method_24074());
        this.assign(buffers, class_4722.method_24076());
        this.assign(buffers, class_1921.method_23590());
        this.assign(buffers, class_1921.method_23591());
        for (class_1921 layer : EXTRA_RENDER_LAYERS) {
            this.assign(buffers, layer);
        }
        this.imm = new BatcherVertexConsumerProvider(new class_9799(256), buffers);
        this.unlitFacade = new UnlitFacade(this.imm);
    }

    private void assign(Map<class_1921, class_9799> buffers, class_1921 layer) {
        buffers.put(layer, new class_9799(layer.method_22722()));
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public void repopulate() {
        this.dirty = true;
    }

    public void begin(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        if (this.dirty) {
            this.populated = false;
            this.dirty = false;
            this.spritesToUpdate.clear();
        }
    }

    public void render(Batchable batchable, class_332 draw, int x, int y, float delta) {
        if (!this.populated) {
            try {
                batchable.renderForBatch(batchable.isSideLit() ? this.imm : this.unlitFacade, draw, x - this.x, y + this.y, this.z, delta);
            }
            catch (Throwable t) {
                if (EmiConfig.devMode) {
                    EmiLog.error("Batchable threw exception during batched rendering. See log for info");
                    t.printStackTrace();
                }
                batchable.setUnbatchable();
            }
        }
    }

    public void render(EmiIngredient stack, class_332 draw, int x, int y, float delta) {
        this.render(stack, draw, x, y, delta, -3);
    }

    public void render(EmiIngredient stack, class_332 draw, int x, int y, float delta, int flags) {
        Batchable b;
        if (stack instanceof Batchable && !(b = (Batchable)((Object)stack)).isUnbatchable() && StackBatcher.isEnabled() && (flags & 1) != 0) {
            if (!this.populated) {
                try {
                    b.renderForBatch(b.isSideLit() ? this.imm : this.unlitFacade, draw, x - this.x, y + this.y, this.z, delta);
                    if (sodiumSpriteHandle != null && !stack.isEmpty()) {
                        class_1799 is = stack.getEmiStacks().get(0).getItemStack();
                        class_310 client = class_310.method_1551();
                        class_1087 model = client.method_1480().method_4012().method_3308(is);
                        if (model != null) {
                            List<class_777> quads = EmiPort.getQuads(model);
                            for (class_777 quad : quads) {
                                if (quad == null) continue;
                                this.spritesToUpdate.add(quad.method_35788());
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    if (EmiConfig.devMode) {
                        EmiLog.error("Stack threw exception during batched rendering. See log for info");
                        t.printStackTrace();
                    }
                    b.setUnbatchable();
                }
            }
            stack.render(draw, x, y, delta, flags & 0xFFFFFFFE);
        } else {
            stack.render(draw, x, y, delta, flags);
        }
    }

    public void draw() {
        if (!StackBatcher.isEnabled()) {
            return;
        }
        if (sodiumSpriteHandle != null) {
            try {
                for (class_1058 sprite : this.spritesToUpdate) {
                    sodiumSpriteHandle.invoke(sprite);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!this.populated) {
            this.bake();
            this.populated = true;
        }
        RenderSystem.enableDepthTest();
        class_308.method_24211();
        Matrix4f mat = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        mat.mul((Matrix4fc)new Matrix4f().translation((float)this.x, (float)this.y, 0.0f));
        for (Map.Entry<class_1921, class_291> en : this.buffers.entrySet()) {
            en.getKey().method_23516();
            EmiPort.setShader(en.getValue(), mat);
            en.getKey().method_23518();
        }
        class_286.method_34420();
    }

    private void bake() {
        this.imm.drawCurrentLayer();
        this.buffers.values().forEach(class_291::close);
        this.buffers.clear();
        for (Map.Entry<class_1921, class_287> entry : this.imm.getPendingLayerBuffers().entrySet()) {
            this.bake(entry.getKey(), entry.getValue());
        }
        this.imm.getPendingLayerBuffers().clear();
    }

    public void bake(class_1921 layer, class_287 bldr) {
        class_9801 builtBuffer = bldr.method_60794();
        if (builtBuffer == null) {
            return;
        }
        class_291 vb = new class_291(class_291.class_8555.field_44794);
        vb.method_1353();
        vb.method_1352(builtBuffer);
        this.buffers.put(layer, vb);
    }

    static {
        try {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("me.jellysquid.mods.sodium.client.render.texture.SpriteUtil");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sodiumSpriteHandle = MethodHandles.lookup().findStatic(clazz, "markSpriteActive", MethodType.methodType(Void.TYPE, class_1058.class));
            if (sodiumSpriteHandle != null) {
                EmiLog.info("Discovered Sodium");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EXTRA_RENDER_LAYERS = Lists.newArrayList();
    }

    private static class BatcherVertexConsumerProvider
    implements class_4597 {
        protected final class_9799 fallbackBuffer;
        protected final Map<class_1921, class_9799> layerBuffers;
        protected final Map<class_1921, class_287> pending = new HashMap<class_1921, class_287>();
        protected class_1921 currentLayer = null;

        protected BatcherVertexConsumerProvider(class_9799 fallbackBuffer, Map<class_1921, class_9799> layerBuffers) {
            this.fallbackBuffer = fallbackBuffer;
            this.layerBuffers = layerBuffers;
        }

        public class_4588 getBuffer(class_1921 renderLayer) {
            class_287 bufferBuilder = this.pending.get(renderLayer);
            if (bufferBuilder == null) {
                class_9799 allocator = this.layerBuffers.get(renderLayer);
                if (allocator != null) {
                    bufferBuilder = new class_287(allocator, renderLayer.method_23033(), renderLayer.method_23031());
                } else {
                    if (this.currentLayer != null) {
                        this.draw(this.currentLayer);
                    }
                    bufferBuilder = new class_287(this.fallbackBuffer, renderLayer.method_23033(), renderLayer.method_23031());
                    this.currentLayer = renderLayer;
                }
                this.pending.put(renderLayer, bufferBuilder);
            }
            return bufferBuilder;
        }

        private class_9799 getBufferInternal(class_1921 layer) {
            return this.layerBuffers.getOrDefault(layer, this.fallbackBuffer);
        }

        public void drawCurrentLayer() {
            if (this.currentLayer != null) {
                class_1921 renderLayer = this.currentLayer;
                if (!this.layerBuffers.containsKey(renderLayer)) {
                    this.draw(renderLayer);
                }
                this.currentLayer = null;
            }
        }

        public void draw(class_1921 layer) {
            class_9799 bufferAllocator = this.getBufferInternal(layer);
            boolean isSameAsCurrentLayer = Objects.equals(this.currentLayer, layer);
            if (!isSameAsCurrentLayer && bufferAllocator == this.fallbackBuffer) {
                return;
            }
            class_287 builder = this.pending.remove(layer);
            if (builder == null) {
                return;
            }
            class_9801 buffer = builder.method_60794();
            if (buffer != null) {
                buffer.method_60819(bufferAllocator, class_8251.field_43361);
                layer.method_60895(buffer);
            }
            if (isSameAsCurrentLayer) {
                this.currentLayer = null;
            }
        }

        public Map<class_1921, class_287> getPendingLayerBuffers() {
            return this.pending;
        }
    }

    private static class UnlitFacade
    implements class_4597 {
        private final class_4597 delegate;
        private final IdentityHashMap<class_4588, class_4588> cache = new IdentityHashMap();

        public UnlitFacade(class_4597 delegate) {
            this.delegate = delegate;
        }

        public class_4588 getBuffer(class_1921 layer) {
            return this.cache.computeIfAbsent(this.delegate.getBuffer(layer), Consumer::new);
        }

        private static final class Consumer
        implements class_4588 {
            private final class_4588 delegate;

            private Consumer(class_4588 delegate) {
                this.delegate = delegate;
            }

            public class_4588 method_22914(float x, float y, float z) {
                this.delegate.method_22914(0.0f, -1.0f, 0.0f);
                return this;
            }

            public class_4588 method_22912(float x, float y, float z) {
                this.delegate.method_22912(x, y, z);
                return this;
            }

            public class_4588 method_22913(float u, float v) {
                this.delegate.method_22913(u, v);
                return this;
            }

            public class_4588 method_60796(int u, int v) {
                this.delegate.method_60796(u, v);
                return this;
            }

            public class_4588 method_22921(int u, int v) {
                this.delegate.method_22921(u, v);
                return this;
            }

            public class_4588 method_1336(int r, int g, int b, int a) {
                this.delegate.method_1336(r, g, b, a);
                return this;
            }
        }
    }

    public static interface Batchable {
        public boolean isSideLit();

        public boolean isUnbatchable();

        public void setUnbatchable();

        public void renderForBatch(class_4597 var1, class_332 var2, int var3, int var4, int var5, float var6);
    }

    public static class ClaimedCollection {
        private Set<StackBatcher> claimed = Sets.newHashSet();
        private List<StackBatcher> unclaimed = Lists.newArrayList();

        public StackBatcher claim() {
            StackBatcher batcher = this.unclaimed.isEmpty() ? new StackBatcher() : this.unclaimed.remove(this.unclaimed.size() - 1);
            this.claimed.add(batcher);
            return batcher;
        }

        public void unclaim(StackBatcher batcher) {
            this.claimed.remove(batcher);
            this.unclaimed.add(batcher);
        }

        public void unclaimAll() {
            for (StackBatcher batcher : this.claimed) {
                this.unclaimed.add(batcher);
            }
            this.claimed.clear();
        }
    }
}

